/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.util.Types;

public class GenericBindingProvider<B> {
    private final AnnotationStrategy annotationStrategy;
    private final BindingFactory<B> factory;

    public GenericBindingProvider(AnnotationStrategy annotationStrategy, BindingFactory<B> factory) {
        this.annotationStrategy = Objects.requireNonNull(annotationStrategy, "annotationStrategy");
        this.factory = Objects.requireNonNull(factory, "factory");
    }

    public List<B> ofConstructorAndMembers(Constructor<?> constructor, Class<?> cls) throws DefinitionException {
        List<B> bindings = this.ofConstructor(constructor);
        bindings.addAll(this.ofMembers(cls));
        return bindings;
    }

    public List<B> ofConstructor(Constructor<?> constructor) throws DefinitionException {
        return this.ofExecutable(constructor, constructor.getDeclaringClass());
    }

    public List<B> ofMembers(Class<?> cls) throws DefinitionException {
        ArrayList<B> bindings = new ArrayList<B>();
        Map typeArguments = null;
        for (Class<?> currentInjectableClass = cls; currentInjectableClass != null; currentInjectableClass = currentInjectableClass.getSuperclass()) {
            for (Field field : currentInjectableClass.getDeclaredFields()) {
                if (this.annotationStrategy.getInjectAnnotations((AnnotatedElement)field).isEmpty()) continue;
                if (Modifier.isFinal(field.getModifiers())) {
                    throw new DefinitionException((AnnotatedElement)field, "of [" + cls + "] cannot be final");
                }
                if (typeArguments == null && (typeArguments = Types.getTypeArguments(cls, Object.class)) == null) {
                    throw new IllegalArgumentException("ownerType must be assignable to field's declaring class: " + cls + "; declaring class: " + currentInjectableClass);
                }
                Type type = Types.resolveVariables((Map)typeArguments, (Type)field.getGenericType());
                bindings.add(this.factory.create(type, field));
            }
            for (AccessibleObject accessibleObject : currentInjectableClass.getDeclaredMethods()) {
                if (this.annotationStrategy.getInjectAnnotations((AnnotatedElement)accessibleObject).isEmpty()) continue;
                if (((Method)accessibleObject).getParameterCount() == 0) {
                    throw new DefinitionException((AnnotatedElement)accessibleObject, "of [" + cls + "] must have parameters");
                }
                bindings.addAll(this.ofExecutable((Executable)accessibleObject, cls));
            }
        }
        return bindings;
    }

    public List<B> ofMethod(Method method, Type ownerType) throws DefinitionException {
        List<B> bindings = this.ofExecutable(method, ownerType);
        if (!Modifier.isStatic(method.getModifiers())) {
            bindings.add(this.ownerBinding(ownerType));
        }
        return bindings;
    }

    public List<B> ofField(Field field, Type ownerType) throws DefinitionException {
        return Modifier.isStatic(field.getModifiers()) ? List.of() : List.of(this.ownerBinding(ownerType));
    }

    public Constructor<?> getAnnotatedConstructor(Class<?> cls) throws DefinitionException {
        return this.getConstructor(cls, true);
    }

    public <T> Constructor<T> getConstructor(Class<T> cls) throws DefinitionException {
        return this.getConstructor(cls, false);
    }

    private <T> Constructor<T> getConstructor(Class<T> cls, boolean annotatedOnly) throws DefinitionException {
        Constructor<?>[] declaredConstructors;
        Constructor<?> suitableConstructor = null;
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : declaredConstructors = cls.getDeclaredConstructors()) {
            if (!this.annotationStrategy.getInjectAnnotations(constructor).isEmpty()) {
                if (suitableConstructor != null) {
                    throw new DefinitionException(cls, "cannot have multiple Inject annotated constructors");
                }
                suitableConstructor = constructor;
                continue;
            }
            if (annotatedOnly || constructor.getParameterCount() != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            defaultConstructor = constructor;
        }
        if (suitableConstructor == null && defaultConstructor == null) {
            throw new DefinitionException(cls, "should have at least one suitable constructor; annotate a constructor" + (annotatedOnly ? "" : " or provide an empty public constructor"));
        }
        return suitableConstructor == null ? defaultConstructor : suitableConstructor;
    }

    private List<B> ofExecutable(Executable executable, Type ownerType) throws DefinitionException {
        Type[] params = executable.getGenericParameterTypes();
        Parameter[] parameters = executable.getParameters();
        ArrayList<B> bindings = new ArrayList<B>();
        Map typeArguments = Types.getTypeArguments((Type)ownerType, executable.getDeclaringClass());
        if (typeArguments == null) {
            throw new IllegalArgumentException("ownerType must be assignable to declaring class: " + ownerType + "; declaring class: " + executable.getDeclaringClass());
        }
        for (int i = 0; i < parameters.length; ++i) {
            Type type = Types.resolveVariables((Map)typeArguments, (Type)params[i]);
            bindings.add(this.factory.create(type, parameters[i]));
        }
        return bindings;
    }

    private B ownerBinding(Type ownerType) throws DefinitionException {
        return this.factory.create(ownerType, null);
    }

    public static interface BindingFactory<B> {
        public B create(Type var1, AnnotatedElement var2) throws DefinitionException;
    }
}

