/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.int4.dirk.spi.instantiation.InjectionTargetExtension;

public class InjectionTargetExtensionStore {
    private final Map<Class<?>, InjectionTargetExtension<?, ?>> extensions = new HashMap();

    public InjectionTargetExtensionStore(Collection<InjectionTargetExtension<?, ?>> extensions) {
        for (InjectionTargetExtension<?, ?> extension : extensions) {
            Class targetClass = extension.getTargetClass();
            if (targetClass == null) {
                throw new IllegalArgumentException("extension " + extension + " target class cannot be null");
            }
            if (!targetClass.isInterface()) {
                throw new IllegalArgumentException("extension " + extension + " target class must be an interface: " + targetClass);
            }
            if (targetClass.getTypeParameters().length == 0) {
                throw new IllegalArgumentException("extension " + extension + " target class must declare at least one type parameter: " + targetClass);
            }
            this.extensions.put(targetClass, extension);
        }
    }

    public <T, E> InjectionTargetExtension<T, E> getExtension(Class<T> cls) {
        InjectionTargetExtension<?, ?> extension = this.extensions.get(cls);
        if (extension == null) {
            return null;
        }
        InjectionTargetExtension<?, ?> cast = extension;
        return cast;
    }
}

