/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition.factory;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.core.definition.injection.Constructable;
import org.int4.dirk.core.definition.injection.Injection;
import org.int4.dirk.core.util.Description;
import org.int4.dirk.spi.config.LifeCycleCallbacks;

public class ClassObjectFactory<T>
implements Constructable<T> {
    private static final Set<Object> UNDER_CONSTRUCTION = ConcurrentHashMap.newKeySet();
    private final Constructor<T> constructor;
    private final LifeCycleCallbacks lifeCycleCallbacks;

    public ClassObjectFactory(Constructor<T> constructor, LifeCycleCallbacks lifeCycleCallbacks) {
        this.constructor = Objects.requireNonNull(constructor, "constructor cannot be null");
        this.lifeCycleCallbacks = Objects.requireNonNull(lifeCycleCallbacks, "lifeCycleCallbacks cannot be null");
        constructor.setAccessible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(List<Injection> injections) throws CreationException {
        if (UNDER_CONSTRUCTION.contains(this)) {
            throw new CreationException("[" + this.constructor.getDeclaringClass() + "] already under construction (dependency creation loop in setter, initializer or post-construct method?)");
        }
        try {
            UNDER_CONSTRUCTION.add(this);
            T instance = this.constructInstance(injections);
            ClassObjectFactory.injectInstance(instance, injections);
            try {
                this.lifeCycleCallbacks.postConstruct(instance);
            }
            catch (InvocationTargetException e) {
                throw new CreationException("[" + this.constructor.getDeclaringClass() + "] threw exception during post construction", e.getCause());
            }
            T t = instance;
            return t;
        }
        finally {
            UNDER_CONSTRUCTION.remove(this);
        }
    }

    @Override
    public void destroy(T instance) {
        this.lifeCycleCallbacks.preDestroy(instance);
    }

    private T constructInstance(List<Injection> injections) throws CreationException {
        try {
            Object[] values = new Object[this.constructor.getParameterCount()];
            int parameterIndex = 0;
            for (Injection injection : injections) {
                if (injection.getTarget() != this.constructor) continue;
                values[parameterIndex++] = injection.getValue();
            }
            return this.constructor.newInstance(values);
        }
        catch (InvocationTargetException e) {
            throw new CreationException("[" + this.constructor + "] call failed", e.getCause());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(this.constructor + " call failed", e);
        }
    }

    private static void injectInstance(Object instance, List<Injection> injections) throws CreationException {
        Object[] values = null;
        int parameterIndex = 0;
        for (Injection injection : injections) {
            AccessibleObject accessibleObject = injection.getTarget();
            if (accessibleObject instanceof Field) {
                Field field = (Field)accessibleObject;
                try {
                    Object valueToSet = injection.getValue();
                    if (valueToSet == null) continue;
                    field.set(instance, valueToSet);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException(field + " inject failed", e);
                }
            }
            if (!(accessibleObject instanceof Method)) continue;
            Method method = (Method)accessibleObject;
            if (values == null) {
                values = new Object[method.getParameterCount()];
            }
            values[parameterIndex++] = injection.getValue();
            if (parameterIndex != method.getParameterCount()) continue;
            try {
                method.invoke(instance, values);
            }
            catch (InvocationTargetException e) {
                throw new CreationException(Description.of(method) + " inject failed", e.getCause());
            }
            catch (Exception e) {
                throw new IllegalStateException(method + " inject failed", e);
            }
            values = null;
            parameterIndex = 0;
        }
    }
}

