/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.definition.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.core.definition.injection.Constructable;
import org.int4.dirk.core.definition.injection.Injection;
import org.int4.dirk.core.util.Description;

public class MethodObjectFactory<T>
implements Constructable<T> {
    private final Method method;
    private final boolean isStatic;

    public MethodObjectFactory(Method method) {
        this.method = method;
        this.isStatic = Modifier.isStatic(method.getModifiers());
        method.setAccessible(true);
    }

    @Override
    public T create(List<Injection> injections) throws CreationException {
        try {
            Object[] values = new Object[injections.size() - (this.isStatic ? 0 : 1)];
            Object instance = null;
            int parameterIndex = 0;
            for (Injection injection : injections) {
                if (injection.getTarget() instanceof Method) {
                    values[parameterIndex++] = injection.getValue();
                    continue;
                }
                instance = injection.getValue();
            }
            Object value = this.method.invoke(instance, values);
            return (T)value;
        }
        catch (InvocationTargetException e) {
            throw new CreationException(Description.of(this.method) + " call failed", e.getCause());
        }
        catch (Exception e) {
            throw new IllegalStateException(this.method + " call failed", e);
        }
    }

    @Override
    public void destroy(T instance) {
    }
}

