/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.store;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.int4.dirk.api.definition.AmbiguousDependencyException;
import org.int4.dirk.api.definition.AmbiguousRequiredDependencyException;
import org.int4.dirk.api.definition.CyclicDependencyException;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.api.definition.ScopeConflictException;
import org.int4.dirk.api.definition.UnsatisfiedDependencyException;
import org.int4.dirk.api.definition.UnsatisfiedRequiredDependencyException;
import org.int4.dirk.core.definition.Binding;
import org.int4.dirk.core.definition.ExtendedScopeResolver;
import org.int4.dirk.core.definition.Injectable;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.core.store.QualifiedTypeStore;
import org.int4.dirk.core.store.Resolver;
import org.int4.dirk.spi.config.ProxyStrategy;
import org.int4.dirk.spi.instantiation.TypeTrait;
import org.int4.dirk.util.Types;

public class InjectableStore
implements Resolver<Injectable<?>> {
    private final Map<Class<?>, Map<Key, Node>> nodes = new HashMap();
    private final QualifiedTypeStore<Injectable<?>> qualifiedTypeStore;
    private final ProxyStrategy proxyStrategy;

    public InjectableStore(ProxyStrategy proxyStrategy) {
        this.proxyStrategy = Objects.requireNonNull(proxyStrategy, "proxyStrategy");
        this.qualifiedTypeStore = new QualifiedTypeStore<Injectable>(i -> new Key(i.getType(), i.getQualifiers()), i -> i.getTypes());
    }

    @Override
    public Set<Injectable<?>> resolve(Key key) {
        Node node;
        Map<Key, Node> map = this.nodes.get(Types.raw((Type)key.getType()));
        if (map != null && (node = map.get(key)) != null) {
            return new HashSet(node.sources);
        }
        return this.qualifiedTypeStore.resolve(key);
    }

    public boolean contains(Key key) {
        return this.qualifiedTypeStore.contains(key);
    }

    public synchronized void putAll(Collection<Injectable<?>> injectables) throws DependencyException {
        this.qualifiedTypeStore.putAll(injectables);
        try {
            this.ensureNoCyclicDependencies(injectables);
            for (Injectable<?> injectable : injectables) {
                this.ensureRequiredBindingsAreAvailable(injectable);
            }
            RegistrationViolation violation = this.addInjectables(injectables);
            if (violation != null) {
                this.removeInjectables(injectables);
                violation.doThrow();
            }
        }
        catch (Exception e) {
            this.qualifiedTypeStore.removeAll(injectables);
            throw e;
        }
    }

    public synchronized void removeAll(Collection<Injectable<?>> injectables) throws DependencyException {
        this.qualifiedTypeStore.removeAll(injectables);
        try {
            RemoveViolation violation = this.removeInjectables(injectables);
            if (violation != null) {
                this.addInjectables(injectables);
                violation.doThrow();
            }
            InjectableStore.removeScopedInstances(injectables);
        }
        catch (Exception e) {
            this.qualifiedTypeStore.putAll(injectables);
            throw e;
        }
    }

    private static void removeScopedInstances(Collection<Injectable<?>> injectables) {
        for (Injectable<?> injectable : injectables) {
            injectable.getScopeResolver().remove(injectable);
        }
    }

    private RegistrationViolation addInjectables(Collection<Injectable<?>> injectables) {
        for (Injectable<?> injectable : injectables) {
            for (Binding binding : injectable.getBindings()) {
                this.addTarget(binding.getElementKey(), !binding.isOptional() && binding.getTypeTraits().contains(TypeTrait.REQUIRES_AT_LEAST_ONE), binding.getTypeTraits().contains(TypeTrait.REQUIRES_AT_MOST_ONE), injectables);
            }
        }
        return this.addSources(injectables);
    }

    private RemoveViolation removeInjectables(Collection<Injectable<?>> injectables) {
        for (Injectable<?> injectable : injectables) {
            for (Binding binding : injectable.getBindings()) {
                this.removeTarget(binding.getElementKey(), !binding.isOptional() && binding.getTypeTraits().contains(TypeTrait.REQUIRES_AT_LEAST_ONE), binding.getTypeTraits().contains(TypeTrait.REQUIRES_AT_MOST_ONE));
            }
        }
        return this.removeSources(injectables);
    }

    private void ensureRequiredBindingsAreAvailable(Injectable<?> injectable) throws AmbiguousDependencyException, UnsatisfiedDependencyException, ScopeConflictException {
        for (Binding binding : injectable.getBindings()) {
            if (!binding.getTypeTraits().contains(TypeTrait.REQUIRES_AT_MOST_ONE)) continue;
            Key elementKey = binding.getElementKey();
            Set<Injectable<?>> injectables = this.qualifiedTypeStore.resolve(elementKey);
            if (injectables.size() > 1) {
                throw new AmbiguousDependencyException("Multiple candidates for dependency [" + elementKey + "] required for " + binding + ": " + injectables);
            }
            if (!binding.isOptional() && binding.getTypeTraits().contains(TypeTrait.REQUIRES_AT_LEAST_ONE) && injectables.size() < 1) {
                throw new UnsatisfiedDependencyException("Missing dependency [" + elementKey + "] required for " + binding);
            }
            if (binding.getTypeTraits().contains(TypeTrait.LAZY) || injectables.isEmpty()) continue;
            Injectable<?> dependency = injectables.iterator().next();
            this.ensureBindingScopeIsValid(injectable, dependency);
        }
    }

    private void ensureBindingScopeIsValid(Injectable<?> injectable, Injectable<?> dependentInjectable) throws ScopeConflictException {
        boolean needsProxy;
        ExtendedScopeResolver dependentScopeResolver = dependentInjectable.getScopeResolver();
        ExtendedScopeResolver injectableScopeResolver = injectable.getScopeResolver();
        boolean bl = needsProxy = !dependentScopeResolver.isPseudoScope() && !dependentScopeResolver.getAnnotation().equals(injectableScopeResolver.getAnnotation());
        if (needsProxy) {
            try {
                this.proxyStrategy.createProxyFactory(Types.raw((Type)dependentInjectable.getType()));
            }
            catch (Exception e) {
                throw new ScopeConflictException("Type [" + injectable.getType() + "] with scope [" + injectableScopeResolver.getAnnotation() + "] is dependent on [" + dependentInjectable.getType() + "] with normal scope [" + dependentScopeResolver.getAnnotation() + "]; this requires the use of a provider or proxy", (Throwable)e);
            }
        }
    }

    private void ensureNoCyclicDependencies(final Collection<Injectable<?>> injectables) throws CyclicDependencyException {
        class CycleDetector {
            Set<Injectable<?>> input;
            Set<Injectable<?>> visited;
            List<Injectable<?>> visiting;

            CycleDetector() {
                this.input = new HashSet(injectables);
                this.visited = new HashSet();
                this.visiting = new ArrayList();
            }

            List<Injectable<?>> hasCycle() {
                for (Injectable injectable : injectables) {
                    if (this.visited.contains(injectable) || !this.hasCycle(injectable)) continue;
                    return this.visiting;
                }
                return this.visiting;
            }

            boolean hasCycle(Injectable<?> injectable) {
                this.visiting.add(injectable);
                for (Binding binding : injectable.getBindings()) {
                    if (binding.getTypeTraits().contains(TypeTrait.LAZY)) continue;
                    for (Injectable<?> boundInjectable : InjectableStore.this.qualifiedTypeStore.resolve(binding.getElementKey())) {
                        if (this.visiting.contains(boundInjectable)) {
                            return true;
                        }
                        if (this.visited.contains(boundInjectable) || !this.input.contains(boundInjectable) || !this.hasCycle(boundInjectable)) continue;
                        return true;
                    }
                }
                this.visiting.remove(injectable);
                this.visited.add(injectable);
                return false;
            }
        }
        List<Injectable<?>> cycle = new CycleDetector().hasCycle();
        if (!cycle.isEmpty()) {
            throw new CyclicDependencyException(InjectableStore.format(cycle));
        }
    }

    private static String format(List<? extends Injectable<?>> cycle) {
        StringBuilder b = new StringBuilder();
        b.append("     -----\n");
        b.append("    |     |\n");
        for (Injectable<?> i : cycle) {
            b.append("    |     V\n");
            b.append("    | " + i + "\n");
            b.append("    |     |\n");
        }
        b.append("     -----\n");
        return b.toString();
    }

    void checkInvariants() {
        for (Map<Key, Node> map : this.nodes.values()) {
            for (Node node : map.values()) {
                if (!node.isInvalid()) continue;
                throw new IllegalStateException(node.toString());
            }
        }
    }

    private RegistrationViolation addSources(Collection<Injectable<?>> sources) {
        RegistrationViolation violation = null;
        for (Injectable<?> source : sources) {
            Type type = source.getType();
            Set<Annotation> qualifiers = source.getQualifiers();
            for (Class cls : Types.getSuperTypes((Class)Types.raw((Type)type))) {
                Map<Key, Node> nodesByKeys = this.nodes.get(cls);
                if (nodesByKeys == null) continue;
                for (Key key : nodesByKeys.keySet()) {
                    if (!Types.isAssignable((Type)type, (Type)key.getType()) || !qualifiers.containsAll(key.getQualifiers())) continue;
                    Node node = nodesByKeys.get(key);
                    node.increaseSources(source);
                    if (violation != null || !node.isInvalid()) continue;
                    violation = new RegistrationViolation(source, key);
                }
            }
        }
        return violation;
    }

    private RemoveViolation removeSources(Collection<Injectable<?>> sources) {
        RemoveViolation violation = null;
        for (Injectable<?> source : sources) {
            Type type = source.getType();
            Set<Annotation> qualifiers = source.getQualifiers();
            for (Class cls : Types.getSuperTypes((Class)Types.raw((Type)type))) {
                Map<Key, Node> nodesByKeys = this.nodes.get(cls);
                if (nodesByKeys == null) continue;
                for (Key key : nodesByKeys.keySet()) {
                    if (!Types.isAssignable((Type)type, (Type)key.getType()) || !qualifiers.containsAll(key.getQualifiers())) continue;
                    Node node = nodesByKeys.get(key);
                    node.decreaseSources(source);
                    if (violation != null || !node.isInvalid()) continue;
                    violation = new RemoveViolation(source);
                }
            }
        }
        return violation;
    }

    private void addTarget(Key key, boolean minimumOne, boolean maximumOne, Collection<Injectable<?>> sources) {
        Class cls = Types.raw((Type)key.getType());
        this.nodes.computeIfAbsent(cls, k -> new HashMap()).computeIfAbsent(key, k -> {
            Set<Injectable<?>> candidates = this.qualifiedTypeStore.resolve(key);
            Node node = new Node(candidates);
            for (Injectable source : sources) {
                if (!candidates.contains(source)) continue;
                node.decreaseSources(source);
            }
            return node;
        }).increaseTargets(minimumOne, maximumOne);
    }

    private void removeTarget(Key key, boolean minimumOne, boolean maximumOne) {
        Class cls = Types.raw((Type)key.getType());
        this.nodes.computeIfPresent(cls, (c, m) -> m.computeIfPresent(key, (k, n) -> n.decreaseTargets(minimumOne, maximumOne) ? null : n) == null ? null : m);
    }

    private Set<Binding> findBindings(Type type, Set<Annotation> qualifiers) {
        return this.qualifiedTypeStore.toSet(s -> s.flatMap(i -> i.getBindings().stream()).filter(b -> Types.isAssignable((Type)type, (Type)b.getType()) && qualifiers.containsAll(b.getQualifiers())).collect(Collectors.toSet()));
    }

    private static class Node {
        int minimumOneReferences;
        int maximumOneReferences;
        int references;
        final Set<Injectable<?>> sources;

        Node(Set<Injectable<?>> sources) {
            this.sources = new HashSet(sources);
        }

        boolean increaseTargets(boolean minimumOne, boolean maximumOne) {
            this.minimumOneReferences += minimumOne ? 1 : 0;
            this.maximumOneReferences += maximumOne ? 1 : 0;
            ++this.references;
            return this.references == 0;
        }

        boolean decreaseTargets(boolean minimumOne, boolean maximumOne) {
            this.minimumOneReferences -= minimumOne ? 1 : 0;
            this.maximumOneReferences -= maximumOne ? 1 : 0;
            --this.references;
            return this.references == 0;
        }

        void increaseSources(Injectable<?> source) {
            if (!this.sources.add(source)) {
                throw new AssertionError((Object)("Node already contained source: " + source));
            }
        }

        void decreaseSources(Injectable<?> source) {
            if (!this.sources.remove(source)) {
                throw new AssertionError((Object)("Node did not contain source: " + source + "; available: " + this.sources));
            }
        }

        boolean isInvalid() {
            return this.minimumOneReferences > 0 && this.sources.size() < 1 || this.maximumOneReferences > 0 && this.sources.size() > 1 || this.references == 0;
        }

        public String toString() {
            return "Node[>0 = " + this.minimumOneReferences + "; <2 = " + this.maximumOneReferences + "; references = " + this.references + "; sources = " + this.sources + "]";
        }
    }

    private class RemoveViolation {
        final Injectable<?> source;

        RemoveViolation(Injectable<?> source) {
            this.source = source;
        }

        void doThrow() throws UnsatisfiedRequiredDependencyException {
            Set<Binding> bindings = InjectableStore.this.findBindings(this.source.getType(), this.source.getQualifiers());
            throw new UnsatisfiedRequiredDependencyException("Removing [" + this.source + "] would make existing required bindings unsatisfiable: " + bindings);
        }
    }

    private class RegistrationViolation {
        final Injectable<?> source;
        final Key key;

        RegistrationViolation(Injectable<?> source, Key key) {
            this.source = source;
            this.key = key;
        }

        void doThrow() throws AmbiguousRequiredDependencyException {
            Set<Binding> bindings = InjectableStore.this.findBindings(this.source.getType(), this.source.getQualifiers());
            String satisfiedBy = InjectableStore.this.qualifiedTypeStore.resolve(this.key).stream().filter(i -> !i.equals(this.source)).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
            throw new AmbiguousRequiredDependencyException("Registering [" + this.source + "] would make existing required bindings ambiguous: " + bindings + "; already satisfied by " + satisfiedBy);
        }
    }
}

