/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.core.store;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.int4.dirk.api.definition.DuplicateDependencyException;
import org.int4.dirk.api.definition.MissingDependencyException;
import org.int4.dirk.core.definition.Key;
import org.int4.dirk.core.store.Resolver;
import org.int4.dirk.util.Types;

public class QualifiedTypeStore<T>
implements Resolver<T> {
    private final Comparator<Set<T>> comparatorConst = Comparator.comparingInt(Set::size);
    private final Map<Class<?>, Map<Annotation, Set<T>>> qualifiedTypesByQualifierByType = new HashMap();
    private final Function<T, Key> keyExtractor;
    private final Function<T, Set<Type>> typesExtractor;

    public QualifiedTypeStore(Function<T, Key> keyExtractor, Function<T, Set<Type>> typesExtractor) {
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor cannot be null");
        this.typesExtractor = Objects.requireNonNull(typesExtractor, "typesExtractor cannot be null");
    }

    @Override
    public synchronized Set<T> resolve(Key key) {
        Set<Type> upperBounds;
        Collection<Set<T>> sets;
        Type type = key.getType();
        if (type instanceof WildcardType) {
            sets = new PriorityQueue<Set<T>>(this.comparatorConst);
            upperBounds = Set.of(Types.getUpperBounds((WildcardType)((WildcardType)type)));
            for (Type upperBound : upperBounds) {
                if (!this.addUpperBound(key, sets, Types.raw((Type)upperBound))) continue;
                return Collections.emptySet();
            }
        } else {
            Map<Annotation, Set<T>> qualifiedTypesByQualifier = this.qualifiedTypesByQualifierByType.get(Types.raw((Type)type));
            if (qualifiedTypesByQualifier == null) {
                return Collections.emptySet();
            }
            if (key.getQualifiers().isEmpty()) {
                sets = Set.of(qualifiedTypesByQualifier.get(null));
            } else {
                sets = new PriorityQueue<Set<T>>(this.comparatorConst);
                if (this.addQualifierBounds(key, sets, qualifiedTypesByQualifier)) {
                    return Collections.emptySet();
                }
            }
            upperBounds = Set.of(type);
        }
        HashSet<T> matches = null;
        for (Set<T> set : sets) {
            if (matches == null) {
                matches = new HashSet<T>(set);
            } else {
                matches.retainAll(set);
            }
            if (!matches.isEmpty()) continue;
            return Collections.emptySet();
        }
        for (Type upperBound : upperBounds) {
            this.filterByGenericType(upperBound, matches);
        }
        return matches;
    }

    private boolean addUpperBound(Key key, Collection<Set<T>> sets, Class<?> upperBound) {
        Map<Annotation, Set<T>> qualifiedTypesByQualifier = this.qualifiedTypesByQualifierByType.get(upperBound);
        if (qualifiedTypesByQualifier == null) {
            return true;
        }
        if (!key.getQualifiers().isEmpty()) {
            return this.addQualifierBounds(key, sets, qualifiedTypesByQualifier);
        }
        sets.add(qualifiedTypesByQualifier.get(null));
        return false;
    }

    private boolean addQualifierBounds(Key key, Collection<Set<T>> sets, Map<Annotation, Set<T>> qualifiedTypesByQualifier) {
        for (Annotation annotation : key.getQualifiers()) {
            Set<T> set = qualifiedTypesByQualifier.get(annotation);
            if (set == null) {
                return true;
            }
            sets.add(set);
        }
        return false;
    }

    public synchronized boolean contains(Key key) {
        return !this.resolve(key).isEmpty();
    }

    public synchronized void put(T qualifiedType) throws DuplicateDependencyException {
        this.putAll(List.of(qualifiedType));
    }

    public synchronized void remove(T qualifiedType) throws MissingDependencyException {
        this.removeAll(List.of(qualifiedType));
    }

    public synchronized void putAll(Collection<T> qualifiedTypes) throws DuplicateDependencyException {
        for (Object qualifiedType : qualifiedTypes) {
            this.ensureQualifiedTypeIsValid(qualifiedType);
        }
        ArrayList addedQualifiedTypes = new ArrayList();
        try {
            for (Object qualifiedType : qualifiedTypes) {
                this.ensureNotDuplicate(qualifiedType);
                this.putInternal(qualifiedType);
                addedQualifiedTypes.add(qualifiedType);
            }
        }
        catch (Exception e) {
            try {
                for (Object qualifiedType : addedQualifiedTypes) {
                    this.removeInternal(qualifiedType);
                }
            }
            catch (Exception e2) {
                AssertionError error = new AssertionError("Fatal error (store might be inconsistent) while adding: " + qualifiedTypes, e2);
                ((Throwable)((Object)error)).addSuppressed(e);
                throw error;
            }
            throw e;
        }
    }

    public synchronized void removeAll(Collection<T> qualifiedTypes) throws MissingDependencyException {
        for (T qualifiedType : qualifiedTypes) {
            this.ensureQualifiedTypeIsValid(qualifiedType);
            Key key = this.keyExtractor.apply(qualifiedType);
            Map<Annotation, Set<T>> existingQualifiedTypes = this.qualifiedTypesByQualifierByType.get(Types.raw((Type)key.getType()));
            if (existingQualifiedTypes != null && existingQualifiedTypes.get(null).contains(qualifiedType)) continue;
            throw new MissingDependencyException("[" + key + "] not present");
        }
        for (T qualifiedType : qualifiedTypes) {
            this.removeInternal(qualifiedType);
        }
    }

    public synchronized Set<T> toSet() {
        return this.qualifiedTypesByQualifierByType.entrySet().stream().filter(e -> ((Class)e.getKey()).getSuperclass() == null).map(Map.Entry::getValue).map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public synchronized <U> U toSet(Function<Stream<T>, U> function) {
        return function.apply(this.qualifiedTypesByQualifierByType.entrySet().stream().filter(e -> ((Class)e.getKey()).getSuperclass() == null).map(Map.Entry::getValue).map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream));
    }

    private void putInternal(T qualifiedType) {
        Key key = this.keyExtractor.apply(qualifiedType);
        try {
            for (Type type : this.typesExtractor.apply(qualifiedType)) {
                Class cls = Types.raw((Type)type);
                this.register(cls, null, qualifiedType);
                for (Annotation qualifier : key.getQualifiers()) {
                    this.register(cls, qualifier, qualifiedType);
                }
            }
        }
        catch (Exception e) {
            throw new AssertionError("Fatal exception (store might be inconsistent) while adding: " + qualifiedType, e);
        }
    }

    private void removeInternal(T qualifiedType) {
        Key key = this.keyExtractor.apply(qualifiedType);
        try {
            for (Type type : this.typesExtractor.apply(qualifiedType)) {
                Class cls = Types.raw((Type)type);
                this.unregister(cls, null, qualifiedType);
                for (Annotation qualifier : key.getQualifiers()) {
                    this.unregister(cls, qualifier, qualifiedType);
                }
            }
        }
        catch (Exception e) {
            throw new AssertionError("Fatal exception (store might be inconsistent) while removing: " + qualifiedType, e);
        }
    }

    private void ensureQualifiedTypeIsValid(T qualifiedType) {
        if (qualifiedType == null) {
            throw new IllegalArgumentException("qualifiedType cannot be null");
        }
    }

    private void ensureNotDuplicate(T qualifiedType) throws DuplicateDependencyException {
        Map<Annotation, Set<T>> qualifiedTypesByQualifier = this.qualifiedTypesByQualifierByType.get(Object.class);
        if (qualifiedTypesByQualifier != null && qualifiedTypesByQualifier.get(null).contains(qualifiedType)) {
            throw new DuplicateDependencyException("[" + this.keyExtractor.apply(qualifiedType) + "] already exists");
        }
    }

    private void register(Class<?> type, Annotation qualifier, T qualifiedType) {
        if (!this.qualifiedTypesByQualifierByType.computeIfAbsent(type, k -> new HashMap()).computeIfAbsent(qualifier, k -> new HashSet()).add(qualifiedType)) {
            throw new AssertionError((Object)("Store should not contain duplicates: " + qualifiedType));
        }
    }

    private void unregister(Class<?> type, Annotation qualifier, T qualifiedType) {
        Map<Annotation, Set<T>> qualifiedTypesByQualifier = this.qualifiedTypesByQualifierByType.get(type);
        if (qualifiedTypesByQualifier == null) {
            throw new AssertionError((Object)("Store must contain: " + qualifiedType + " for class: " + type));
        }
        Set<T> qualifiedTypes = qualifiedTypesByQualifier.get(qualifier);
        if (qualifiedTypes == null || !qualifiedTypes.remove(qualifiedType)) {
            throw new AssertionError((Object)("Store must contain: " + qualifiedType + " for class: " + type + " -> " + qualifier + " qualified types: " + qualifiedTypes));
        }
        if (qualifiedTypes.isEmpty()) {
            qualifiedTypesByQualifier.remove(qualifier);
            if (qualifiedTypesByQualifier.isEmpty()) {
                this.qualifiedTypesByQualifierByType.remove(type);
            }
        }
    }

    private void filterByGenericType(Type type, Set<T> matches) {
        if (type instanceof ParameterizedType) {
            Iterator<T> iterator = matches.iterator();
            while (iterator.hasNext()) {
                T qualifiedType = iterator.next();
                if (Types.isAssignable((Type)this.keyExtractor.apply(qualifiedType).getType(), (Type)type)) continue;
                iterator.remove();
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + this.qualifiedTypesByQualifierByType + "]";
    }
}

