/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.di;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.annotations.Any;
import org.int4.dirk.annotations.Opt;
import org.int4.dirk.annotations.Produces;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.definition.AmbiguousRequiredDependencyException;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DuplicateDependencyException;
import org.int4.dirk.api.definition.UnsatisfiedDependencyException;
import org.int4.dirk.api.definition.UnsatisfiedRequiredDependencyException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.di.Injectors;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class InjectorProviderTest {
    private Injector injector = Injectors.manual((ScopeResolver[])new ScopeResolver[0]);

    @Test
    public void optionalProvidersShouldBreakCircularDependenciesAndAllowDelayedRegistration() throws Exception {
        this.injector.register(BeanWithOptionalProvider.class);
        BeanWithOptionalProvider instance = (BeanWithOptionalProvider)this.injector.getInstance(BeanWithOptionalProvider.class, new Object[0]);
        Assertions.assertThat((Object)instance.getSimpleBean()).isNull();
        this.injector.register(SimpleBean.class);
        org.junit.jupiter.api.Assertions.assertEquals(SimpleBean.class, instance.getSimpleBean().getClass());
    }

    @Test
    public void providersShouldBreakCircularDependenciesOnly() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(BeanWithProvider.class)).isExactlyInstanceOf(UnsatisfiedDependencyException.class)).hasMessage("Missing dependency [@org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$SimpleBean] required for Field [@org.int4.dirk.annotations.Default() private jakarta.inject.Provider<org.int4.dirk.di.InjectorProviderTest$SimpleBean> org.int4.dirk.di.InjectorProviderTest$BeanWithProvider.simpleBeanProvider]").hasNoCause();
        this.injector.register(SimpleBean.class);
        this.injector.register(BeanWithProvider.class);
        BeanWithProvider instance = (BeanWithProvider)this.injector.getInstance(BeanWithProvider.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals(SimpleBean.class, instance.getSimpleBean().getClass());
    }

    @Test
    public void getInstanceShouldReturnInjectedProviderClass() throws Exception {
        Provider<Connection> anonymousProvider = new Provider<Connection>(){

            public Connection get() {
                return null;
            }
        };
        this.injector.registerInstance((Object)anonymousProvider, new Annotation[0]);
        this.injector.registerInstance((Object)true, new Annotation[]{Annotations.of(Named.class, Map.of("value", "db.readonly"))});
        for (int i = 0; i < 2; ++i) {
            this.injector.register(DatabaseProvider.class);
            org.junit.jupiter.api.Assertions.assertEquals(DatabaseProvider.class, ((DatabaseProvider)this.injector.getInstance(DatabaseProvider.class, new Object[0])).getClass());
            org.junit.jupiter.api.Assertions.assertEquals(Database.class, ((Database)this.injector.getInstance(Database.class, new Object[0])).getClass());
            Assertions.assertThat((List)this.injector.getInstances(Provider.class, new Object[0])).isEmpty();
            this.injector.remove(DatabaseProvider.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(DatabaseProvider.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasNoCause();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(Database.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasNoCause();
        }
    }

    @Test
    public void getInstanceShouldReturnInjectableFromProviderInstance() throws Exception {
        this.injector.registerInstance((Object)new SimpleDatabaseProvider(), new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertEquals(Database.class, ((Database)this.injector.getInstance(Database.class, new Object[0])).getClass());
    }

    @Test
    public void classRegistrationShouldFailWhenImplicitProviderWouldViolatesDependencies() throws Exception {
        for (int i = 0; i < 2; ++i) {
            SimpleDatabaseProvider provider = new SimpleDatabaseProvider();
            this.injector.registerInstance((Object)provider, new Annotation[0]);
            this.injector.register(BeanWithDatabase.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SimpleDatabaseProvider.class)).isExactlyInstanceOf(DuplicateDependencyException.class)).hasMessage("[@org.int4.dirk.annotations.Any() @org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database] already exists").hasNoCause();
            org.junit.jupiter.api.Assertions.assertEquals(BeanWithDatabase.class, ((BeanWithDatabase)this.injector.getInstance(BeanWithDatabase.class, new Object[0])).getClass());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.removeInstance((Object)provider, new Annotation[0])).isExactlyInstanceOf(UnsatisfiedRequiredDependencyException.class)).hasMessage("Removing [Producer [@org.int4.dirk.annotations.Any(), @org.int4.dirk.annotations.Default() public org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$SimpleDatabaseProvider.get()]] would make existing required bindings unsatisfiable: [Field [@org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$BeanWithDatabase.database]]").hasNoCause();
            this.injector.remove(BeanWithDatabase.class);
            this.injector.removeInstance((Object)provider, new Annotation[0]);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(BeanWithDatabase.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasMessage("No such instance: [org.int4.dirk.di.InjectorProviderTest$BeanWithDatabase]").hasNoCause();
        }
    }

    @Test
    public void classRemovalShouldFailWhenImplicitProviderRemovalWouldViolatesDependencies() throws Exception {
        for (int i = 0; i < 2; ++i) {
            this.injector.register(SimpleDatabaseProvider.class);
            this.injector.register(BeanWithDatabase.class);
            org.junit.jupiter.api.Assertions.assertEquals(BeanWithDatabase.class, ((BeanWithDatabase)this.injector.getInstance(BeanWithDatabase.class, new Object[0])).getClass());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.remove(SimpleDatabaseProvider.class)).isExactlyInstanceOf(UnsatisfiedRequiredDependencyException.class)).hasMessage("Removing [Producer [@org.int4.dirk.annotations.Any(), @org.int4.dirk.annotations.Default() public org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$SimpleDatabaseProvider.get()]] would make existing required bindings unsatisfiable: [Field [@org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$BeanWithDatabase.database]]").hasNoCause();
            org.junit.jupiter.api.Assertions.assertEquals(BeanWithDatabase.class, ((BeanWithDatabase)this.injector.getInstance(BeanWithDatabase.class, new Object[0])).getClass());
            this.injector.remove(BeanWithDatabase.class);
            this.injector.remove(SimpleDatabaseProvider.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(BeanWithDatabase.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasMessage("No such instance: [org.int4.dirk.di.InjectorProviderTest$BeanWithDatabase]").hasNoCause();
        }
    }

    @Test
    public void getInstanceShouldReturnInstanceInjectedWithProviderOfList() throws Exception {
        this.injector.register(BeanWithProvidedListOfString.class);
        this.injector.registerInstance((Object)"a", new Annotation[0]);
        this.injector.registerInstance((Object)"b", new Annotation[0]);
        BeanWithProvidedListOfString bean = (BeanWithProvidedListOfString)this.injector.getInstance(BeanWithProvidedListOfString.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)bean.getTexts().size());
        this.injector.registerInstance((Object)"c", new Annotation[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)bean.getTexts().size());
    }

    @Test
    public void nestedProvidersShouldNotBeAllowed() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new NestedDatabaseProvider(), new Annotation[0])).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [public jakarta.inject.Provider org.int4.dirk.di.InjectorProviderTest$NestedDatabaseProvider.get()] cannot be registered as it conflicts with an InjectionTargetExtension for type: interface jakarta.inject.Provider").hasNoCause();
    }

    @Test
    public void producerFieldProducingProviderShouldNotBeAllowed() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(ProviderFieldProducer.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Field [private static jakarta.inject.Provider org.int4.dirk.di.InjectorProviderTest$ProviderFieldProducer.product] cannot be registered as it conflicts with an InjectionTargetExtension for type: interface jakarta.inject.Provider").hasNoCause();
    }

    @Test
    public void producerMethodProducingProviderShouldNotBeAllowed() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(ProviderMethodProducer.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [private static jakarta.inject.Provider org.int4.dirk.di.InjectorProviderTest$ProviderMethodProducer.product()] cannot be registered as it conflicts with an InjectionTargetExtension for type: interface jakarta.inject.Provider").hasNoCause();
    }

    @Test
    public void registerShouldThrowExceptionWhenDatabaseIsCreatedAndProvided() throws Exception {
        this.injector.registerInstance((Object)new Database("jdbc:localhost"), new Annotation[0]);
        this.injector.register(BeanWithDatabase.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.register(SimpleDatabaseProvider.class)).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasMessageStartingWith("Registering [Producer [@org.int4.dirk.annotations.Any(), @org.int4.dirk.annotations.Default() public org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$SimpleDatabaseProvider.get()]] would make existing required bindings ambiguous: [Field [@org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$BeanWithDatabase.database]]; already satisfied by [Instance of [@org.int4.dirk.annotations.Any() @org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database -> org.int4.dirk.di.InjectorProviderTest$Database@").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(SimpleDatabaseProvider.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasMessage("No such instance: [org.int4.dirk.di.InjectorProviderTest$SimpleDatabaseProvider]").hasNoCause();
    }

    @Test
    public void registerShouldThrowExceptionWhenDatabaseIsCreatedAndProvided2() throws Exception {
        this.injector.register(SimpleDatabaseProvider.class);
        this.injector.register(BeanWithDatabase.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new Database("jdbc:localhost"), new Annotation[0])).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasMessageStartingWith("Registering [Instance of [@org.int4.dirk.annotations.Any() @org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database -> org.int4.dirk.di.InjectorProviderTest$Database@").hasMessageEndingWith("]] would make existing required bindings ambiguous: [Field [@org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$BeanWithDatabase.database]]; already satisfied by [Producer [@org.int4.dirk.annotations.Any(), @org.int4.dirk.annotations.Default() public org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$SimpleDatabaseProvider.get()]]").hasNoCause();
    }

    @Test
    public void registerShouldThrowExceptionWhenDatabaseIsInstancedAndProvided() throws Exception {
        this.injector.registerInstance((Object)new Database("jdbc:localhost"), new Annotation[0]);
        this.injector.register(BeanWithDatabase.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new SimpleDatabaseProvider(), new Annotation[0])).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasMessageStartingWith("Registering [Producer [@org.int4.dirk.annotations.Any(), @org.int4.dirk.annotations.Default() public org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$SimpleDatabaseProvider.get()]] would make existing required bindings ambiguous: [Field [@org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$BeanWithDatabase.database]]; already satisfied by [Instance of [@org.int4.dirk.annotations.Any() @org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database -> org.int4.dirk.di.InjectorProviderTest$Database@").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(SimpleDatabaseProvider.class, new Object[0])).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasMessage("No such instance: [org.int4.dirk.di.InjectorProviderTest$SimpleDatabaseProvider]").hasNoCause();
    }

    @Test
    public void registerShouldThrowExceptionWhenDatabaseIsInstancedAndProvided2() throws Exception {
        this.injector.registerInstance((Object)new SimpleDatabaseProvider(), new Annotation[0]);
        this.injector.register(BeanWithDatabase.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.registerInstance((Object)new Database("jdbc:localhost"), new Annotation[0])).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class)).hasMessageStartingWith("Registering [Instance of [@org.int4.dirk.annotations.Any() @org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database -> org.int4.dirk.di.InjectorProviderTest$Database@").hasMessageEndingWith("]] would make existing required bindings ambiguous: [Field [@org.int4.dirk.annotations.Default() org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$BeanWithDatabase.database]]; already satisfied by [Producer [@org.int4.dirk.annotations.Any(), @org.int4.dirk.annotations.Default() public org.int4.dirk.di.InjectorProviderTest$Database org.int4.dirk.di.InjectorProviderTest$SimpleDatabaseProvider.get()]]").hasNoCause();
    }

    @Test
    public void registrationAndUnregistrationOfInterfaceProviderShouldWork() throws Exception {
        for (int i = 0; i < 2; ++i) {
            this.injector.register(AppendableProvider.class);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(AppendableProvider.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(AppendableProvider.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(Appendable.class, new Object[0]));
            this.injector.remove(AppendableProvider.class);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.injector.contains(AppendableProvider.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedResolutionException.class, () -> this.injector.getInstance(AppendableProvider.class, new Object[0]));
            org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedResolutionException.class, () -> this.injector.getInstance(Appendable.class, new Object[0]));
        }
    }

    @Test
    public void providersShouldRespectQualifiers() throws Exception {
        this.injector.register(A.class);
        this.injector.register(B.class);
        this.injector.register(C.class);
        Assertions.assertThat((List)this.injector.getInstances(Z.class, new Object[0])).hasSize(3);
        Assertions.assertThat((Object)((Z)this.injector.getInstance(Z.class, new Object[]{Red.class}))).isExactlyInstanceOf(Z.class);
        Assertions.assertThat((Object)((Z)this.injector.getInstance(Z.class, new Object[]{Green.class}))).isExactlyInstanceOf(Z.class);
        Assertions.assertThat((Object)((Z)this.injector.getInstance(Z.class, new Object[]{Big.class}))).isExactlyInstanceOf(Z.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.injector.getInstance(Z.class, new Object[]{Small.class})).isExactlyInstanceOf(UnsatisfiedResolutionException.class)).hasNoCause();
        this.injector.register(X.class);
        X x = (X)this.injector.getInstance(X.class, new Object[0]);
        Assertions.assertThat(x.red).isNotNull();
        Assertions.assertThat(x.green).isNotNull();
        Assertions.assertThat((String)((Z)x.red.get()).name).isEqualTo("red");
        Assertions.assertThat((String)((Z)x.green.get()).name).isEqualTo("green");
    }

    @Test
    public void multipleProvidersOfSameTypeShouldReturnMultipleInstances() throws Exception {
        this.injector.register(B.class);
        this.injector.register(E.class);
        Assertions.assertThat((List)this.injector.getInstances(Z.class, new Object[0])).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        this.injector.register(W.class);
        W w = (W)this.injector.getInstance(W.class, new Object[0]);
        Assertions.assertThat(w.zs).extracting(z -> z.name).isEmpty();
        Assertions.assertThat((List)((List)w.zList.get())).extracting(z -> z.name).isEmpty();
        Assertions.assertThat(w.anyZs).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.anyZList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat(w.reds).isEmpty();
        Assertions.assertThat(w.zReds).isEmpty();
        Assertions.assertThat((List)((List)w.redList.get())).isEmpty();
        Assertions.assertThat((List)((List)w.zRedList.get())).isEmpty();
        Assertions.assertThat(w.greens).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat(w.zGreens).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.greenList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.zGreenList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
    }

    @Test
    public void multipleProducersOfSameTypeShouldReturnMultipleInstances() throws Exception {
        this.injector.register(V.class);
        Assertions.assertThat((List)this.injector.getInstances(Z.class, new Object[0])).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        this.injector.register(W.class);
        W w = (W)this.injector.getInstance(W.class, new Object[0]);
        Assertions.assertThat(w.zs).extracting(z -> z.name).isEmpty();
        Assertions.assertThat((List)((List)w.zList.get())).extracting(z -> z.name).isEmpty();
        Assertions.assertThat(w.anyZs).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.anyZList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat(w.reds).isEmpty();
        Assertions.assertThat(w.zReds).isEmpty();
        Assertions.assertThat((List)((List)w.redList.get())).isEmpty();
        Assertions.assertThat((List)((List)w.zRedList.get())).isEmpty();
        Assertions.assertThat(w.greens).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat(w.zGreens).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.greenList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
        Assertions.assertThat((List)((List)w.zGreenList.get())).extracting(z -> z.name).containsExactlyInAnyOrder((Object[])new String[]{"green", "light green"});
    }

    @Test
    public void providerShouldRespectScope() throws Exception {
        this.injector.register(B.class);
        this.injector.register(C.class);
        this.injector.register(D.class);
        this.injector.register(P.class);
        this.injector.register(Q.class);
        this.injector.register(R.class);
        P p1 = (P)this.injector.getInstance(P.class, new Object[0]);
        Q q1 = (Q)this.injector.getInstance(Q.class, new Object[0]);
        R r1 = (R)this.injector.getInstance(R.class, new Object[0]);
        P p2 = (P)this.injector.getInstance(P.class, new Object[0]);
        Q q2 = (Q)this.injector.getInstance(Q.class, new Object[0]);
        R r2 = (R)this.injector.getInstance(R.class, new Object[0]);
        Assertions.assertThat((Object)p1.y).isNotEqualTo((Object)q1.y);
        Assertions.assertThat((Object)p1.y).isNotEqualTo((Object)r1.y);
        Assertions.assertThat((Object)q1.y).isNotEqualTo((Object)r1.y);
        Assertions.assertThat((Object)p1.y).isNotEqualTo((Object)p2.y);
        Assertions.assertThat((Object)q1.y).isNotEqualTo((Object)q2.y);
        Assertions.assertThat((Object)r1.y).isNotEqualTo((Object)r2.y);
        Assertions.assertThat((Object)p1.z).isEqualTo((Object)q1.z);
        Assertions.assertThat((Object)p1.z).isNotEqualTo((Object)r1.z);
        Assertions.assertThat((Object)q1.z).isNotEqualTo((Object)r1.z);
        Assertions.assertThat((Object)p1.z).isEqualTo((Object)p2.z);
        Assertions.assertThat((Object)q1.z).isEqualTo((Object)q2.z);
        Assertions.assertThat((Object)r1.z).isNotEqualTo((Object)r2.z);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Small {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Big {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Green {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Red {
    }

    public static class BeanWithProvider {
        @Inject
        private Provider<SimpleBean> simpleBeanProvider;

        public SimpleBean getSimpleBean() {
            return (SimpleBean)this.simpleBeanProvider.get();
        }
    }

    @Singleton
    public static class SimpleBean {
    }

    public static class BeanWithOptionalProvider {
        @Inject
        @Opt
        private Provider<SimpleBean> simpleBeanProvider;

        public SimpleBean getSimpleBean() {
            return (SimpleBean)this.simpleBeanProvider.get();
        }
    }

    static class PrimitivesA {
        @Inject
        Provider<Integer> i;
        @Inject
        Provider<Double> d;
        private Provider<Byte> b;
        private Provider<Boolean> flag;

        @Inject
        PrimitivesA(Provider<Byte> b, Provider<Boolean> flag) {
            this.b = b;
            this.flag = flag;
        }

        double calculate() {
            return (Double)this.d.get() * (double)((Integer)this.i.get()).intValue() + (double)((Byte)this.b.get()).byteValue() / ((Boolean)this.flag.get() != false ? 2.0 : 1.5);
        }
    }

    @Nested
    class WhenInjectorContainsPrimitiveValues {
        WhenInjectorContainsPrimitiveValues() {
            try {
                InjectorProviderTest.this.injector.registerInstance((Object)7, new Annotation[0]);
                InjectorProviderTest.this.injector.registerInstance((Object)2.5, new Annotation[0]);
                InjectorProviderTest.this.injector.registerInstance((Object)true, new Annotation[0]);
                InjectorProviderTest.this.injector.registerInstance((Object)11, new Annotation[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Test
        void shouldInjectProvidersWithCorrespondingPrimitives() throws Exception {
            InjectorProviderTest.this.injector.register(PrimitivesA.class);
            Assertions.assertThat((double)((PrimitivesA)InjectorProviderTest.this.injector.getInstance(PrimitivesA.class, new Object[0])).calculate()).isEqualTo(23.0);
        }
    }

    public static class Z {
        public final String name;

        public Z(String name) {
            this.name = name;
        }
    }

    public static class Y {
    }

    public static class X {
        @Inject
        @Red
        Provider<Z> red;
        @Inject
        @Green
        Provider<Z> green;
    }

    public static class W {
        @Inject
        List<Z> zs;
        @Inject
        Provider<List<Z>> zList;
        @Inject
        @Any
        List<Z> anyZs;
        @Inject
        @Any
        Provider<List<Z>> anyZList;
        @Inject
        @Green
        List<?> greens;
        @Inject
        @Green
        List<Z> zGreens;
        @Inject
        @Green
        Provider<List<?>> greenList;
        @Inject
        @Green
        Provider<List<Z>> zGreenList;
        @Inject
        @Red
        List<?> reds;
        @Inject
        @Red
        List<Z> zReds;
        @Inject
        @Red
        Provider<List<?>> redList;
        @Inject
        @Red
        Provider<List<Z>> zRedList;
    }

    public static class V {
        @Produces
        @Green
        Z z1 = new Z("green");
        @Produces
        @Green
        Z z2 = new Z("light green");
    }

    public static class R {
        @Inject
        Y y;
        @Inject
        @Green
        Z z;
    }

    public static class Q {
        @Inject
        Y y;
        @Inject
        @Big
        Z z;
    }

    public static class P {
        @Inject
        Y y;
        @Inject
        @Big
        Z z;
    }

    public static class E
    implements Provider<Z> {
        @Green
        public Z get() {
            return new Z("light green");
        }
    }

    public static class D
    implements Provider<Y> {
        public Y get() {
            return new Y();
        }
    }

    @Singleton
    public static class C
    implements Provider<Z> {
        @Big
        @Singleton
        public Z get() {
            return new Z("big");
        }
    }

    public static class B
    implements Provider<Z> {
        @Green
        public Z get() {
            return new Z("green");
        }
    }

    public static class A
    implements Provider<Z> {
        @Red
        public Z get() {
            return new Z("red");
        }
    }

    public static class AppendableProvider
    implements Provider<Appendable> {
        public Appendable get() {
            return new Appendable(){

                @Override
                public Appendable append(CharSequence csq) {
                    return null;
                }

                @Override
                public Appendable append(CharSequence csq, int start, int end) {
                    return null;
                }

                @Override
                public Appendable append(char c) {
                    return null;
                }
            };
        }
    }

    public static class ProviderMethodProducer {
        @Produces
        private static Provider<Database> product() {
            return null;
        }
    }

    public static class ProviderFieldProducer {
        @Produces
        private static Provider<Database> product;
    }

    public static class DatabaseProvider
    implements Provider<Database> {
        @Inject
        public DatabaseProvider(Provider<Connection> cls, @Named(value="db.readonly") boolean readOnly) {
        }

        public Database get() {
            return new Database("jdbc:localhost");
        }
    }

    public static class SimpleDatabaseProvider
    implements Provider<Database> {
        public Database get() {
            return new Database("jdbc:localhost");
        }
    }

    public static class NestedDatabaseProvider
    implements Provider<Provider<Provider<Database>>> {
        public Provider<Provider<Database>> get() {
            return new Provider<Provider<Database>>(){

                public Provider<Database> get() {
                    return new SimpleDatabaseProvider();
                }
            };
        }
    }

    public static class Database {
        public Database(String url) {
        }
    }

    public static class BeanWithProvidedDatabase {
        @Inject
        Provider<Database> database;
    }

    public static class BeanWithDatabase {
        @Inject
        Database database;
    }

    public static class BeanWithProvidedListOfString {
        @Inject
        private Provider<List<String>> texts;

        List<String> getTexts() {
            return (List)this.texts.get();
        }
    }
}

