/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.di;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.int4.dirk.annotations.Any;
import org.int4.dirk.annotations.Default;
import org.int4.dirk.annotations.Dependent;
import org.int4.dirk.annotations.NormalScope;
import org.int4.dirk.annotations.Opt;
import org.int4.dirk.annotations.Produces;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.core.StandardInjector;
import org.int4.dirk.di.AssistedTypeRegistrationExtensionSupport;
import org.int4.dirk.di.ByteBuddyProxyStrategySupport;
import org.int4.dirk.library.AnnotationBasedLifeCycleCallbacksFactory;
import org.int4.dirk.library.ConfigurableAnnotationStrategy;
import org.int4.dirk.library.DefaultInjectorStrategy;
import org.int4.dirk.library.ListInjectionTargetExtension;
import org.int4.dirk.library.NoProxyStrategy;
import org.int4.dirk.library.ProducesTypeRegistrationExtension;
import org.int4.dirk.library.ProviderInjectionTargetExtension;
import org.int4.dirk.library.ProviderTypeRegistrationExtension;
import org.int4.dirk.library.SetInjectionTargetExtension;
import org.int4.dirk.library.SingletonScopeResolver;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.spi.config.InjectorStrategy;
import org.int4.dirk.spi.config.LifeCycleCallbacksFactory;
import org.int4.dirk.spi.config.ProxyStrategy;
import org.int4.dirk.spi.config.ScopeStrategy;
import org.int4.dirk.spi.discovery.TypeRegistrationExtension;
import org.int4.dirk.spi.instantiation.InjectionTargetExtension;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.int4.dirk.util.Classes;

public class Injectors {
    private static final Logger LOGGER = Logger.getLogger(Injectors.class.getName());
    private static final Default DEFAULT = (Default)Annotations.of(Default.class);
    private static final Any ANY = (Any)Annotations.of(Any.class);
    private static final Scope SCOPE = (Scope)Annotations.of(Scope.class);
    private static final Singleton SINGLETON = (Singleton)Annotations.of(Singleton.class);
    private static final Dependent DEPENDENT = (Dependent)Annotations.of(Dependent.class);
    private static final AnnotationStrategy ANNOTATION_STRATEGY = new DirkAnnotationStrategy(Inject.class, Qualifier.class, Opt.class);
    private static final Method PROVIDER_METHOD;

    public static Injector autoDiscovering(ScopeResolver ... scopeResolvers) {
        return Injectors.createInjector(true, scopeResolvers);
    }

    public static Injector manual(ScopeResolver ... scopeResolvers) {
        return Injectors.createInjector(false, scopeResolvers);
    }

    private static Injector createInjector(boolean autoDiscovering, ScopeResolver ... scopeResolvers) {
        AnnotationBasedLifeCycleCallbacksFactory lifeCycleCallbacksFactory = new AnnotationBasedLifeCycleCallbacksFactory(PostConstruct.class, PreDestroy.class);
        List<ScopeResolver> finalScopeResolvers = Arrays.stream(scopeResolvers).anyMatch(sr -> sr.getAnnotation().equals(SINGLETON)) ? Arrays.asList(scopeResolvers) : Stream.concat(Arrays.stream(scopeResolvers), Stream.of(new SingletonScopeResolver((Annotation)SINGLETON))).collect(Collectors.toList());
        NoProxyStrategy proxyStrategy = new NoProxyStrategy();
        if (Classes.isAvailable((String)"org.int4.dirk.extensions.proxy.ByteBuddyProxyStrategy")) {
            LOGGER.info("Using ByteBuddyProxyStrategy found on classpath");
            proxyStrategy = ByteBuddyProxyStrategySupport.create();
        }
        return new StandardInjector(Injectors.createInjectionTargetExtensions(), Injectors.createDiscoveryExtensions((LifeCycleCallbacksFactory)lifeCycleCallbacksFactory), finalScopeResolvers, (InjectorStrategy)new DefaultInjectorStrategy(ANNOTATION_STRATEGY, (ScopeStrategy)new DirkScopeStrategy(Scope.class, NormalScope.class, (Annotation)SINGLETON, (Annotation)DEPENDENT), (ProxyStrategy)proxyStrategy, (LifeCycleCallbacksFactory)lifeCycleCallbacksFactory), autoDiscovering);
    }

    private static List<InjectionTargetExtension<?, ?>> createInjectionTargetExtensions() {
        return List.of(new ListInjectionTargetExtension(), new SetInjectionTargetExtension(), new ProviderInjectionTargetExtension(Provider.class, s -> ((Supplier)s)::get));
    }

    private static List<TypeRegistrationExtension> createDiscoveryExtensions(LifeCycleCallbacksFactory lifeCycleCallbacksFactory) {
        ArrayList<TypeRegistrationExtension> extensions = new ArrayList<TypeRegistrationExtension>();
        extensions.add((TypeRegistrationExtension)new ProviderTypeRegistrationExtension(PROVIDER_METHOD));
        extensions.add((TypeRegistrationExtension)new ProducesTypeRegistrationExtension(Produces.class));
        if (Classes.isAvailable((String)"org.int4.dirk.extensions.assisted.AssistedTypeRegistrationExtension")) {
            LOGGER.info("Using AssistedTypeRegistrationExtension found on classpath");
            extensions.add(AssistedTypeRegistrationExtensionSupport.create(ANNOTATION_STRATEGY, lifeCycleCallbacksFactory));
        }
        return extensions;
    }

    static {
        try {
            PROVIDER_METHOD = Provider.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    static class DirkScopeStrategy
    implements ScopeStrategy {
        private final Class<? extends Annotation> scopeAnnotationClass;
        private final Class<? extends Annotation> normalScopeAnnotationClass;
        private final Annotation singletonAnnotation;
        private final Annotation dependentAnnotation;

        DirkScopeStrategy(Class<? extends Annotation> scopeAnnotationClass, Class<? extends Annotation> normalScopeAnnotationClass, Annotation singletonAnnotation, Annotation dependentAnnotation) {
            this.scopeAnnotationClass = Objects.requireNonNull(scopeAnnotationClass, "scopeAnnotationClass");
            this.normalScopeAnnotationClass = Objects.requireNonNull(normalScopeAnnotationClass, "normalScopeAnnotationClass");
            this.singletonAnnotation = Objects.requireNonNull(singletonAnnotation, "singletonAnnotation");
            this.dependentAnnotation = Objects.requireNonNull(dependentAnnotation, "dependentAnnotation");
        }

        public boolean isPseudoScope(Annotation annotation) {
            return Annotations.isMetaAnnotated(annotation.annotationType(), (Annotation)SCOPE);
        }

        public Annotation getDefaultAnnotation() {
            return this.dependentAnnotation;
        }

        public Annotation getDependentAnnotation() {
            return this.dependentAnnotation;
        }

        public Annotation getSingletonAnnotation() {
            return this.singletonAnnotation;
        }

        public Annotation getScope(AnnotatedElement element) throws DefinitionException {
            Set scopes = Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)element, this.scopeAnnotationClass);
            scopes.addAll(Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)element, this.normalScopeAnnotationClass));
            if (scopes.size() > 1) {
                throw new DefinitionException(element, "cannot have multiple scope annotations, but found: " + scopes.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()));
            }
            if (scopes.isEmpty()) {
                return null;
            }
            return (Annotation)scopes.iterator().next();
        }
    }

    static class DirkAnnotationStrategy
    extends ConfigurableAnnotationStrategy {
        public DirkAnnotationStrategy(Class<? extends Annotation> inject, Class<? extends Annotation> qualifier, Class<? extends Annotation> optional) {
            super(inject, qualifier, optional);
        }

        public Set<Annotation> getQualifiers(AnnotatedElement element) {
            boolean isTarget;
            Set qualifiers = super.getQualifiers(element);
            boolean bl = isTarget = element.isAnnotationPresent(Inject.class) || element instanceof Parameter && ((Parameter)element).getDeclaringExecutable().isAnnotationPresent(Inject.class);
            if (isTarget) {
                if (qualifiers.isEmpty()) {
                    qualifiers.add(DEFAULT);
                }
            } else {
                if (qualifiers.stream().noneMatch(q -> q.annotationType() != Named.class && !q.equals(ANY))) {
                    qualifiers.add(DEFAULT);
                }
                qualifiers.add(ANY);
            }
            return qualifiers;
        }
    }
}

