/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.di;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import org.int4.dirk.api.Injector;
import org.int4.dirk.di.Injectors;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.junit.jupiter.api.Test;

public class ProviderInjectionTargetExtensionInjectorTest {
    private Injector injector = Injectors.manual((ScopeResolver[])new ScopeResolver[0]);

    @Test
    public void shouldRegisterSingletonBeanDependentOnXWhenXIsProvidedAsSingleton() throws Exception {
        this.injector.registerInstance((Object)new X(), new Annotation[0]);
        this.injector.register(SingletonBeanDependentOnX.class);
    }

    @Test
    public void shouldRegisterPrototypeBeanDependentOnXWhenXIsProvidedAsPrototype() throws Exception {
        this.injector.registerInstance((Object)new XProvider(), new Annotation[0]);
        this.injector.register(PrototypeBeanDependantOnX.class);
    }

    @Test
    public void shouldRegisterPrototypeBeanDependentOnXWhenXIsProvidedAsSingleton() throws Exception {
        this.injector.registerInstance((Object)new X(), new Annotation[0]);
        this.injector.register(PrototypeBeanDependantOnX.class);
    }

    @Test
    public void shouldThrowExceptionWhenRegisteringSingletonBeanDependentOnXWhenXIsProvidedAsPrototype() throws Exception {
        this.injector.registerInstance((Object)new XProvider(), new Annotation[0]);
        this.injector.register(SingletonBeanDependentOnX.class);
    }

    @Test
    public void shouldRegisterSingletonBeanDependentOnXProviderWhenXIsProvidedAsSingleton() throws Exception {
        this.injector.registerInstance((Object)new X(), new Annotation[0]);
        this.injector.register(SingletonBeanDependentOnXProvider.class);
    }

    @Test
    public void shouldRegisterPrototypeBeanDependentOnXProviderWhenXIsProvidedAsPrototype() throws Exception {
        this.injector.registerInstance((Object)new XProvider(), new Annotation[0]);
        this.injector.register(PrototypeBeanDependantOnXProvider.class);
    }

    @Test
    public void shouldRegisterPrototypeBeanDependentOnXProviderWhenXIsProvidedAsSingleton() throws Exception {
        this.injector.registerInstance((Object)new X(), new Annotation[0]);
        this.injector.register(PrototypeBeanDependantOnXProvider.class);
    }

    @Test
    public void shouldRegisterSingletonBeanDependentOnXProviderWhenXIsProvidedAsPrototype() throws Exception {
        this.injector.registerInstance((Object)new XProvider(), new Annotation[0]);
        this.injector.register(SingletonBeanDependentOnXProvider.class);
    }

    public static class XProvider
    implements Provider<X> {
        public X get() {
            return null;
        }
    }

    @Singleton
    public static class SingletonBeanDependentOnXProvider {
        @Inject
        Provider<X> xProvider;
    }

    public static class PrototypeBeanDependantOnXProvider {
        @Inject
        Provider<X> xProvider;
    }

    @Singleton
    public static class SingletonBeanDependentOnX {
        @Inject
        X x;
    }

    public static class PrototypeBeanDependantOnX {
        @Inject
        X x;
    }

    public static class X {
    }
}

