/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.library;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.library.AnnotationBasedLifeCycleCallbacksFactory;
import org.int4.dirk.spi.config.LifeCycleCallbacks;
import org.junit.jupiter.api.Test;

public class AnnotationBasedLifeCycleCallbacksFactoryTest {
    private AnnotationBasedLifeCycleCallbacksFactory factory = new AnnotationBasedLifeCycleCallbacksFactory(PostConstruct.class, PreDestroy.class);

    @Test
    void shouldCallLifecycleMethods() throws InvocationTargetException {
        LifeCycleCallbacks callbacks = this.factory.create(A.class);
        A a = new A();
        callbacks.postConstruct((Object)a);
        Assertions.assertThat((int)a.postConstructsA).isEqualTo(1);
        Assertions.assertThat((int)a.postConstructsB).isEqualTo(1);
        Assertions.assertThat((int)a.postConstructsC).isEqualTo(1);
        Assertions.assertThat((int)a.preDestroysA).isEqualTo(0);
        Assertions.assertThat((int)a.preDestroysB).isEqualTo(0);
        Assertions.assertThat((int)a.preDestroysC).isEqualTo(0);
        callbacks.preDestroy((Object)a);
        Assertions.assertThat((int)a.postConstructsA).isEqualTo(1);
        Assertions.assertThat((int)a.postConstructsB).isEqualTo(1);
        Assertions.assertThat((int)a.postConstructsC).isEqualTo(1);
        Assertions.assertThat((int)a.preDestroysA).isEqualTo(1);
        Assertions.assertThat((int)a.preDestroysB).isEqualTo(1);
        Assertions.assertThat((int)a.preDestroysC).isEqualTo(1);
    }

    @Test
    void shouldRejectLifecycleMethodsWithParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.create(BadA.class)).isExactlyInstanceOf(DefinitionException.class)).hasMessage("Method [void org.int4.dirk.library.AnnotationBasedLifeCycleCallbacksFactoryTest$BadA.bad(java.lang.String)] cannot have parameters when annotated as a lifecycle method (post construct or pre destroy)").hasNoSuppressedExceptions().hasNoCause();
    }

    @Test
    void shouldForwardExceptionsDuringPostConstruct() {
        LifeCycleCallbacks callbacks = this.factory.create(BadB.class);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> callbacks.postConstruct((Object)new BadB())).isExactlyInstanceOf(InvocationTargetException.class)).extracting(Throwable::getCause, InstanceOfAssertFactories.THROWABLE)).isExactlyInstanceOf(NoSuchElementException.class)).hasNoCause();
    }

    @Test
    void shouldSkipExceptionsDuringPreDestroy() {
        LifeCycleCallbacks callbacks = this.factory.create(BadB.class);
        Assertions.assertThatCode(() -> callbacks.preDestroy((Object)new BadB())).doesNotThrowAnyException();
    }

    static class BadB {
        BadB() {
        }

        @PostConstruct
        void postConstruct() {
            throw new NoSuchElementException("oops");
        }

        @PreDestroy
        void preDestroy() {
            throw new NoSuchElementException("oops");
        }
    }

    static class BadA {
        BadA() {
        }

        @PostConstruct
        void bad(String a) {
            System.out.println(a);
        }
    }

    static class C {
        int postConstructsC = 0;
        int preDestroysC = 0;

        C() {
        }

        @PostConstruct
        void postConstructC() {
            ++this.postConstructsC;
        }

        @PreDestroy
        void preDestroyC() {
            ++this.preDestroysC;
        }
    }

    static class B
    extends C {
        int postConstructsB = 0;
        int preDestroysB = 0;

        B() {
        }

        @PostConstruct
        void postConstructB() {
            ++this.postConstructsB;
        }

        @PreDestroy
        void preDestroyB() {
            ++this.preDestroysB;
        }
    }

    static class A
    extends B {
        int postConstructsA = 0;
        int preDestroysA = 0;

        A() {
        }

        @PostConstruct
        void postConstructA() {
            ++this.postConstructsA;
        }

        @PreDestroy
        void preDestroyA() {
            ++this.preDestroysA;
        }
    }
}

