/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.library;

import jakarta.inject.Provider;
import java.lang.reflect.Type;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.library.ProviderTypeRegistrationExtension;
import org.int4.dirk.spi.definition.TypeRegistrationExtension;
import org.int4.dirk.util.Types;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ProviderTypeRegistrationExtensionTest {
    private TypeRegistrationExtension.Registry registry = (TypeRegistrationExtension.Registry)Mockito.mock(TypeRegistrationExtension.Registry.class);
    private ProviderTypeRegistrationExtension extension;

    @BeforeEach
    void beforeEach() throws NoSuchMethodException, SecurityException {
        this.extension = new ProviderTypeRegistrationExtension(Provider.class.getMethod("get", new Class[0]));
    }

    @Test
    void shouldFindProvider() throws DefinitionException, NoSuchMethodException, SecurityException {
        this.extension.deriveTypes(this.registry, A.class);
        ((TypeRegistrationExtension.Registry)Mockito.verify((Object)this.registry)).add(A.class.getDeclaredMethod("get", new Class[0]), A.class);
    }

    @Test
    void shouldNotFindProviderWhenNotImplemented() throws Exception {
        this.extension.deriveTypes(this.registry, Bad_A.class);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.registry});
    }

    @Test
    void shouldNotFindProviderWhenProviderInterfaceExtended() throws Exception {
        this.extension.deriveTypes(this.registry, Bad_B.class);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.registry});
    }

    @Test
    void shouldNotFindProviderForWildcardType() throws Exception {
        this.extension.deriveTypes(this.registry, (Type)Types.wildcardExtends((Type[])new Type[]{String.class}));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.registry});
    }

    public static interface Bad_B<T>
    extends Provider<T> {
    }

    public static class Bad_A {
    }

    public static class B {
    }

    public static class A
    implements Provider<B> {
        public B get() {
            return new B();
        }
    }
}

