/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.library;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.int4.dirk.spi.instantiation.InjectionTargetExtension;
import org.int4.dirk.spi.instantiation.InstantiationContext;
import org.int4.dirk.spi.instantiation.TypeTrait;
import org.int4.dirk.util.Types;

public class ProviderInjectionTargetExtension<P, E>
implements InjectionTargetExtension<P, E> {
    private static final Set<TypeTrait> LAZY = Collections.unmodifiableSet(EnumSet.of(TypeTrait.LAZY));
    private final Class<P> providerClass;
    private final Function<Supplier<E>, P> providerFactory;
    private final TypeVariable<?> typeVariable;

    public ProviderInjectionTargetExtension(Class<P> providerClass, Function<Supplier<E>, P> providerFactory) {
        this.providerClass = Objects.requireNonNull(providerClass, "providerClass cannot be null");
        this.providerFactory = Objects.requireNonNull(providerFactory, "providerFactory cannot be null");
        this.typeVariable = providerClass.getTypeParameters()[0];
    }

    public Class<?> getTargetClass() {
        return this.providerClass;
    }

    public Type getElementType(Type type) {
        return Types.getTypeParameter((Type)type, this.providerClass, this.typeVariable);
    }

    public Set<TypeTrait> getTypeTraits() {
        return LAZY;
    }

    public P getInstance(InstantiationContext<E> context) {
        return this.providerFactory.apply(() -> context.create());
    }
}

