/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.library;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.spi.config.ScopeStrategy;
import org.int4.dirk.util.Annotations;

public class SimpleScopeStrategy
implements ScopeStrategy {
    private final Class<? extends Annotation> scopeAnnotationClass;
    private final Annotation defaultAnnotation;
    private final Annotation singletonAnnotation;
    private final Annotation dependentAnnotation;

    public SimpleScopeStrategy(Class<? extends Annotation> scopeAnnotationClass, Annotation defaultAnnotation, Annotation singletonAnnotation, Annotation dependentAnnotation) {
        this.scopeAnnotationClass = Objects.requireNonNull(scopeAnnotationClass, "scopeAnnotationClass");
        this.defaultAnnotation = Objects.requireNonNull(defaultAnnotation, "defaultAnnotation");
        this.singletonAnnotation = Objects.requireNonNull(singletonAnnotation, "singletonAnnotation");
        this.dependentAnnotation = Objects.requireNonNull(dependentAnnotation, "dependentAnnotation");
    }

    public boolean isPseudoScope(Annotation annotation) {
        return annotation.equals(this.singletonAnnotation) || annotation.equals(this.dependentAnnotation);
    }

    public Annotation getDefaultAnnotation() {
        return this.defaultAnnotation;
    }

    public Annotation getDependentAnnotation() {
        return this.dependentAnnotation;
    }

    public Annotation getSingletonAnnotation() {
        return this.singletonAnnotation;
    }

    public Annotation getScope(AnnotatedElement element) throws DefinitionException {
        Set scopes = Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)element, this.scopeAnnotationClass);
        if (scopes.size() > 1) {
            throw new DefinitionException(element, "cannot have multiple scope annotations, but found: " + scopes.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()));
        }
        if (scopes.isEmpty()) {
            return null;
        }
        return (Annotation)scopes.iterator().next();
    }
}

