/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.library;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.Set;
import org.int4.dirk.spi.config.AnnotationStrategy;
import org.int4.dirk.util.Annotations;

public class ConfigurableAnnotationStrategy
implements AnnotationStrategy {
    private final Class<? extends Annotation> injectClass;
    private final Class<? extends Annotation> qualifierClass;
    private final Class<? extends Annotation> optionalClass;
    private final Annotation qualifierAnnotation;

    public ConfigurableAnnotationStrategy(Class<? extends Annotation> inject, Class<? extends Annotation> qualifier, Class<? extends Annotation> optional) {
        this.injectClass = Objects.requireNonNull(inject, "inject");
        this.qualifierClass = Objects.requireNonNull(qualifier, "qualifier");
        this.optionalClass = optional;
        this.qualifierAnnotation = Annotations.of(this.qualifierClass);
    }

    public boolean isOptional(AnnotatedElement element) {
        if (element != null) {
            for (Annotation annotation : element.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                String simpleName = annotationType.getName();
                if (!simpleName.endsWith(".Nullable") && this.optionalClass != annotationType) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Annotation> getInjectAnnotations(AnnotatedElement element) {
        return Annotations.findAnnotations((AnnotatedElement)element, this.injectClass);
    }

    public Set<Annotation> getQualifiers(AnnotatedElement element) {
        return Annotations.findDirectlyMetaAnnotatedAnnotations((AnnotatedElement)element, this.qualifierClass);
    }

    public boolean isQualifier(Annotation annotation) {
        return Annotations.isMetaAnnotated(annotation.annotationType(), (Annotation)this.qualifierAnnotation);
    }
}

