/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.plugins;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.definition.AmbiguousDependencyException;
import org.int4.dirk.api.definition.AmbiguousRequiredDependencyException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.jsr330.Injectors;
import org.int4.dirk.plugins.BeanWithDatabase;
import org.int4.dirk.plugins.BeanWithTextProviders;
import org.int4.dirk.plugins.ComponentScannerFactory;
import org.int4.dirk.plugins.DatabaseBean;
import org.int4.dirk.plugins.DefaultComponentScannerFactory;
import org.int4.dirk.plugins.Plugin;
import org.int4.dirk.plugins.PluginManager;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.test.plugin.Database;
import org.int4.dirk.test.plugin.TextProvider;
import org.int4.dirk.test.plugin.TextStyler;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PluginManagerTest {
    private static final URL PLUGIN_URL;
    private Injector injector;
    private PluginManager pluginManager;

    @BeforeEach
    public void beforeEach() throws Exception {
        this.injector = Injectors.autoDiscovering((ScopeResolver[])new ScopeResolver[0]);
        this.pluginManager = new PluginManager((ComponentScannerFactory)new DefaultComponentScannerFactory(), this.injector.getCandidateRegistry());
        this.injector.register(BeanWithTextProviders.class);
    }

    @AfterAll
    public static void afterAll() {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void shouldLoadThenUnloadPlugin() throws Exception {
        BeanWithTextProviders bean1 = (BeanWithTextProviders)this.injector.getInstance(BeanWithTextProviders.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bean1);
        Assertions.assertThat(bean1.getTextProviders()).isEmpty();
        this.injector.register(TextStyler.class);
        Plugin plugin = this.pluginManager.loadPluginAndScan(new URL[]{PLUGIN_URL});
        BeanWithTextProviders bean2 = (BeanWithTextProviders)this.injector.getInstance(BeanWithTextProviders.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bean2);
        Assertions.assertThat(bean2.getTextProviders()).hasSize(3);
        List<String> texts = PluginManagerTest.extractTextsFromBeanWithTextProviders(bean2);
        Assertions.assertThat(texts).containsExactlyInAnyOrder((Object[])new String[]{"Fancy Text", "NORMAL TEXT", ">>Styled Text<<"});
        this.pluginManager.unload(plugin);
        BeanWithTextProviders bean3 = (BeanWithTextProviders)this.injector.getInstance(BeanWithTextProviders.class, new Object[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bean3);
        Assertions.assertThat(bean3.getTextProviders()).isEmpty();
        PluginManagerTest.gc();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)plugin.isUnloaded());
        bean2 = null;
        PluginManagerTest.waitForPluginUnload(plugin);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)plugin.isUnloaded());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(TextStyler.class, new Object[0]));
    }

    @Test
    public void shouldLoadPluginAgainAfterUnload() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedResolutionException.class, () -> this.injector.getInstance(Database.class, new Object[0]));
        this.injector.register(TextStyler.class);
        Plugin plugin = this.pluginManager.loadPluginAndScan(new URL[]{PLUGIN_URL});
        Database db1 = (Database)this.injector.getInstance(Database.class, new Object[0]);
        this.pluginManager.unload(plugin);
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedResolutionException.class, () -> this.injector.getInstance(Database.class, new Object[0]));
        plugin = this.pluginManager.loadPlugin(new URL[]{PLUGIN_URL});
        Database db2 = (Database)this.injector.getInstance(Database.class, new Object[0]);
        this.pluginManager.unload(plugin);
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedResolutionException.class, () -> this.injector.getInstance(Database.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)db1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)db2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)db1.getClass().equals(db2.getClass()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)db1.getClass().getClassLoader().equals(db2.getClass().getClassLoader()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)db1.getClass().getName().equals(db2.getClass().getName()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.injector.contains(TextStyler.class, new Object[0]));
    }

    @Test
    public void shouldNotLoadPluginWhenLoadingWouldViolateSingularDependencies() throws Exception {
        this.injector.register(DatabaseBean.class);
        this.injector.register(BeanWithDatabase.class);
        org.junit.jupiter.api.Assertions.assertThrows(AmbiguousRequiredDependencyException.class, () -> this.pluginManager.loadPlugin(new URL[]{PLUGIN_URL}));
    }

    @Test
    public void shouldLoadPluginAfterFixingSingularDependencyViolations() throws Exception {
        this.injector.register(DatabaseBean.class);
        this.injector.register(BeanWithDatabase.class);
        Assertions.assertThatThrownBy(() -> this.pluginManager.loadPlugin(new URL[]{PLUGIN_URL})).isExactlyInstanceOf(AmbiguousRequiredDependencyException.class);
        this.injector.remove(BeanWithDatabase.class);
        this.pluginManager.loadPlugin(new URL[]{PLUGIN_URL});
        Assertions.assertThatThrownBy(() -> this.injector.register(BeanWithDatabase.class)).isExactlyInstanceOf(AmbiguousDependencyException.class);
        this.injector.remove(DatabaseBean.class);
        this.injector.register(BeanWithDatabase.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.injector.getInstance(BeanWithDatabase.class, new Object[0]));
    }

    private static List<String> extractTextsFromBeanWithTextProviders(BeanWithTextProviders bean) {
        ArrayList<String> texts = new ArrayList<String>();
        for (TextProvider textProvider : bean.getTextProviders()) {
            texts.add(textProvider.provideText());
        }
        return texts;
    }

    private static void waitForPluginUnload(Plugin plugin) {
        for (int i = 0; i < 20; ++i) {
            System.gc();
            if (plugin.isUnloaded()) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void gc() {
        for (int i = 0; i < 10; ++i) {
            System.gc();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        try {
            PLUGIN_URL = PluginManagerTest.class.getResource("/plugins/dirk-test-plugin-1.0.0-SNAPSHOT.jar").toURI().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

