/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.plugins;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.jsr330.Injectors;
import org.int4.dirk.plugins.ComponentScannerFactory;
import org.int4.dirk.plugins.DefaultComponentScannerFactory;
import org.int4.dirk.plugins.Plugin;
import org.int4.dirk.plugins.PluginManager;
import org.int4.dirk.plugins.PluginManagerTest;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.test.plugin.Database;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PluginSingletonTest {
    private static final URL PLUGIN_URL;

    @Test
    public void shouldLoadAndUnloadPluginWithPluginSingleton() throws Exception {
        Injector injector = Injectors.autoDiscovering((ScopeResolver[])new ScopeResolver[0]);
        PluginManager pluginManager = new PluginManager((ComponentScannerFactory)new DefaultComponentScannerFactory(), injector.getCandidateRegistry());
        for (int i = 0; i < 5; ++i) {
            Plugin plugin = pluginManager.loadPluginAndScan(new URL[]{PLUGIN_URL});
            Assertions.assertNotNull((Object)injector.getInstance(Database.class, new Object[0]));
            pluginManager.unload(plugin);
            Assertions.assertThrows(UnsatisfiedResolutionException.class, () -> injector.getInstance(Database.class, new Object[0]));
            PluginSingletonTest.waitForPluginUnload(plugin);
            Assertions.assertTrue((boolean)plugin.isUnloaded());
        }
    }

    private static void waitForPluginUnload(Plugin plugin) {
        for (int i = 0; i < 20; ++i) {
            System.gc();
            if (plugin.isUnloaded()) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        try {
            PLUGIN_URL = PluginManagerTest.class.getResource("/plugins/dirk-test-plugin-singleton-1.0.0-SNAPSHOT.jar").toURI().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

