/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.plugins;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.int4.dirk.plugins.Plugin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PluginTest {
    @Test
    void constructorShouldRejectInvalidParameters() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Plugin(null, null, this.getClass().getClassLoader()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Plugin(null, List.of(), null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Plugin(null, Arrays.asList(new Type[]{null}), this.getClass().getClassLoader()));
    }

    @Test
    void constructorShouldAcceptValidParameters() {
        Plugin plugin = new Plugin("name", List.of(String.class), this.getClass().getClassLoader());
        Assertions.assertEquals((Object)this.getClass().getClassLoader(), (Object)plugin.getClassLoader());
        Assertions.assertEquals(List.of(String.class), (Object)plugin.getTypes());
        Assertions.assertEquals((Object)"Plugin[name -> [class java.lang.String]]", (Object)plugin.toString());
        Assertions.assertEquals((Object)false, (Object)plugin.isUnloaded());
    }
}

