/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.plugins;

import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.int4.dirk.api.CandidateRegistry;
import org.int4.dirk.api.definition.AutoDiscoveryException;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DependencyException;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.util.QueryFunction;
import org.reflections.util.ReflectionUtilsPredicates;

public class ComponentScanner {
    private static final Logger LOGGER = Logger.getLogger(ComponentScanner.class.getName());
    private final Reflections reflections;
    private final QueryFunction<Store, String> scanDefinition;
    private final Predicate<Class<?>> filter;

    ComponentScanner(Reflections reflections, QueryFunction<Store, String> scanDefinition, Predicate<Class<?>> filter) {
        this.reflections = reflections;
        this.scanDefinition = scanDefinition;
        this.filter = filter;
    }

    public void scan(CandidateRegistry registry) throws AutoDiscoveryException, DefinitionException, DependencyException {
        List<Type> types = this.findComponentTypes(ComponentScanner.class.getClassLoader());
        LOGGER.fine("Registering types: " + types);
        registry.register(types);
    }

    List<Type> findComponentTypes(ClassLoader classLoader) {
        return this.reflections.get(this.scanDefinition.asClass(new ClassLoader[]{classLoader}).filter(ReflectionUtilsPredicates.withClassModifier((int)1024).negate())).stream().filter(this.filter).sorted(Comparator.comparing(Type::getTypeName)).collect(Collectors.toList());
    }
}

