/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.plugins;

import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.int4.dirk.plugins.ComponentScanner;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.QueryFunction;

public class ComponentScannerFactory {
    private static final Scanner[] SCANNERS = new Scanner[]{Scanners.TypesAnnotated, Scanners.FieldsAnnotated, Scanners.MethodsAnnotated, Scanners.ConstructorsAnnotated};
    private final AnnotatedElement[] typeAnnotations;
    private final AnnotatedElement[] fieldAnnotations;
    private final AnnotatedElement[] methodAnnotations;
    private final AnnotatedElement[] constructorAnnotations;
    private final Predicate<Class<?>> filter;

    public ComponentScannerFactory(AnnotatedElement[] typeAnnotations, AnnotatedElement[] fieldAnnotations, AnnotatedElement[] methodAnnotations, AnnotatedElement[] constructorAnnotations, Predicate<Class<?>> filter) {
        this.typeAnnotations = (AnnotatedElement[])typeAnnotations.clone();
        this.fieldAnnotations = (AnnotatedElement[])fieldAnnotations.clone();
        this.methodAnnotations = (AnnotatedElement[])methodAnnotations.clone();
        this.constructorAnnotations = (AnnotatedElement[])constructorAnnotations.clone();
        this.filter = filter == null ? x -> true : filter;
    }

    public ComponentScannerFactory(AnnotatedElement[] typeAnnotations, AnnotatedElement[] fieldAnnotations, AnnotatedElement[] methodAnnotations, AnnotatedElement[] constructorAnnotations) {
        this(typeAnnotations, fieldAnnotations, methodAnnotations, constructorAnnotations, null);
    }

    public ComponentScanner create(String ... packageNamePrefixes) {
        Pattern filterPattern = Pattern.compile(Arrays.stream(packageNamePrefixes).map(pnp -> pnp.replace(".", "/")).collect(Collectors.joining("|", "(", ").*?")));
        ConfigurationBuilder configuration = new ConfigurationBuilder().forPackages(packageNamePrefixes).filterInputsBy(s -> filterPattern.matcher((CharSequence)s).matches()).setScanners(SCANNERS);
        return new ComponentScanner(new Reflections((Configuration)configuration), this.getScanDefinition(), this.filter);
    }

    public ComponentScanner create(URL ... urls) {
        ConfigurationBuilder configuration = new ConfigurationBuilder().addUrls(urls).setScanners(SCANNERS);
        return new ComponentScanner(new Reflections((Configuration)configuration), this.getScanDefinition(), this.filter);
    }

    private QueryFunction<Store, String> getScanDefinition() {
        return Scanners.TypesAnnotated.with(this.typeAnnotations).add(Scanners.FieldsAnnotated.with(this.fieldAnnotations).add(Scanners.MethodsAnnotated.with(this.methodAnnotations)).add(Scanners.ConstructorsAnnotated.with(this.constructorAnnotations)).map(ComponentScannerFactory::reduceToClassName));
    }

    private static String reduceToClassName(String name) {
        int methodParametersStart = name.lastIndexOf(40);
        int memberNameStart = name.lastIndexOf(46, methodParametersStart == -1 ? name.length() : methodParametersStart);
        return name.substring(0, memberNameStart);
    }
}

