/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.plugins;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.int4.dirk.plugins.PluginManager;

public class Plugin {
    private final AtomicBoolean unloaded;
    private final String name;
    private List<Type> types;
    private ClassLoader classLoader;

    public Plugin(String name, List<Type> types, ClassLoader classLoader) {
        if (types == null) {
            throw new IllegalArgumentException("types cannot be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader cannot be null");
        }
        this.name = name;
        this.classLoader = classLoader;
        this.types = Collections.unmodifiableList(new ArrayList<Type>(types));
        if (this.types.contains(null)) {
            throw new IllegalArgumentException("types cannot contain null");
        }
        this.unloaded = classLoader instanceof PluginManager.UnloadTrackingClassLoader ? ((PluginManager.UnloadTrackingClassLoader)classLoader).getUnloadedAtomicBoolean() : null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public String toString() {
        return "Plugin[" + this.name + " -> " + this.types + "]";
    }

    void destroy() {
        try {
            if (this.classLoader instanceof URLClassLoader) {
                ((URLClassLoader)this.classLoader).close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.types = null;
            this.classLoader = null;
        }
    }

    public boolean isUnloaded() {
        return this.unloaded == null ? false : this.unloaded.get();
    }
}

