/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.plugins;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Named;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.Injector;
import org.int4.dirk.api.definition.UnsatisfiedDependencyException;
import org.int4.dirk.jsr330.Injectors;
import org.int4.dirk.plugins.ComponentScanner;
import org.int4.dirk.plugins.DefaultComponentScannerFactory;
import org.int4.dirk.plugins.test.project.TestAutoDiscoverableDependency;
import org.int4.dirk.plugins.test.project.TestAutoDiscoverableInjectAnnotatedDependency;
import org.int4.dirk.plugins.test.project.TestClassWithSetterInjection;
import org.int4.dirk.plugins.test.project.TestDatabase;
import org.int4.dirk.plugins.test.project.TestStatement;
import org.int4.dirk.spi.scope.ScopeResolver;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.Test;

public class PluginManagerRegistrationTest {
    private static final Annotation CONFIGURATION = Annotations.of(Named.class, Map.of("value", "configuration"));
    private static final Annotation VERSION = Annotations.of(Named.class, Map.of("value", "version"));

    @Test
    public void shouldLoadWithAutoDiscovery() throws Exception {
        Injector injector = Injectors.autoDiscovering((ScopeResolver[])new ScopeResolver[0]);
        injector.registerInstance((Object)"{jsonconfig}", new Annotation[]{CONFIGURATION});
        ComponentScanner scanner = new DefaultComponentScannerFactory().create(new String[]{"org.int4.dirk.plugins.test.project"});
        scanner.scan(injector.getCandidateRegistry());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(TestDatabase.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(TestStatement.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(TestAutoDiscoverableInjectAnnotatedDependency.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10.0.2", (Object)injector.getInstance(String.class, new Object[]{VERSION}));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(TestClassWithSetterInjection.class, new Object[0]));
    }

    @Test
    public void shouldLoadWithoutAutoDiscovery() throws Exception {
        Injector injector = Injectors.manual((ScopeResolver[])new ScopeResolver[0]);
        injector.registerInstance((Object)"{jsonconfig}", new Annotation[]{CONFIGURATION});
        ComponentScanner scanner = new DefaultComponentScannerFactory().create(new String[]{"org.int4.dirk.plugins.test.project"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> scanner.scan(injector.getCandidateRegistry())).isExactlyInstanceOf(UnsatisfiedDependencyException.class)).hasNoCause();
        injector.register(TestAutoDiscoverableDependency.class);
        scanner.scan(injector.getCandidateRegistry());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(TestDatabase.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(TestStatement.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(TestAutoDiscoverableInjectAnnotatedDependency.class, new Object[0]));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10.0.2", (Object)injector.getInstance(String.class, new Object[]{VERSION}));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)injector.getInstance(TestClassWithSetterInjection.class, new Object[0]));
    }
}

