/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.plugins;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.int4.dirk.api.CandidateRegistry;
import org.int4.dirk.api.definition.AutoDiscoveryException;
import org.int4.dirk.api.definition.DefinitionException;
import org.int4.dirk.api.definition.DependencyException;
import org.int4.dirk.plugins.ComponentScanner;
import org.int4.dirk.plugins.ComponentScannerFactory;
import org.int4.dirk.plugins.Module;
import org.int4.dirk.plugins.Plugin;

public class PluginManager {
    private static final Logger LOGGER = Logger.getLogger(PluginManager.class.getName());
    private final ComponentScannerFactory componentScannerFactory;
    private final CandidateRegistry baseRegistry;

    public PluginManager(ComponentScannerFactory componentScannerFactory, CandidateRegistry registry) {
        this.componentScannerFactory = Objects.requireNonNull(componentScannerFactory, "componentScannerFactory cannot be null");
        this.baseRegistry = Objects.requireNonNull(registry, "registry cannot be null");
    }

    public Plugin loadPluginAndScan(String ... packageNamePrefixes) throws AutoDiscoveryException, DefinitionException, DependencyException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        LOGGER.fine("Scanning packages: " + Arrays.toString(packageNamePrefixes));
        return new PluginLoader(this.componentScannerFactory.create(packageNamePrefixes), classLoader).loadPlugin(Arrays.toString(packageNamePrefixes));
    }

    public Plugin loadPluginAndScan(URL ... urls) throws AutoDiscoveryException, DefinitionException, DependencyException {
        UnloadTrackingClassLoader classLoader = new UnloadTrackingClassLoader(urls);
        LOGGER.fine("Scanning Plugin at: " + Arrays.toString(urls));
        return new PluginLoader(this.componentScannerFactory.create(urls), classLoader).loadPlugin(Arrays.toString(urls));
    }

    public void unload(Plugin plugin) throws AutoDiscoveryException, DefinitionException, DependencyException {
        this.baseRegistry.remove(plugin.getTypes());
        plugin.destroy();
    }

    public Plugin loadPlugin(URL ... urls) throws AutoDiscoveryException, DefinitionException, DependencyException {
        UnloadTrackingClassLoader classLoader = new UnloadTrackingClassLoader(urls);
        try {
            Class<?> moduleClass = classLoader.loadClass("PluginModule");
            Constructor<?> constructor = moduleClass.getConstructor(new Class[0]);
            Module module = (Module)constructor.newInstance(new Object[0]);
            return this.createPlugin(Arrays.toString(urls), module.getTypes(), classLoader);
        }
        catch (ReflectiveOperationException e) {
            try {
                classLoader.close();
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            try {
                classLoader.close();
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    private Plugin createPlugin(String name, List<Type> types, ClassLoader classLoader) throws AutoDiscoveryException, DefinitionException, DependencyException {
        Plugin plugin = new Plugin(name, types, classLoader);
        this.baseRegistry.register(plugin.getTypes());
        return plugin;
    }

    private class PluginLoader {
        private final ComponentScanner componentScanner;
        private final ClassLoader classLoader;

        PluginLoader(ComponentScanner componentScanner, ClassLoader classLoader) {
            this.componentScanner = componentScanner;
            this.classLoader = classLoader;
        }

        Plugin loadPlugin(String pluginName) throws AutoDiscoveryException, DefinitionException, DependencyException {
            List<Type> types = this.componentScanner.findComponentTypes(this.classLoader);
            LOGGER.fine("Registering types: " + types);
            return PluginManager.this.createPlugin(pluginName, types, this.classLoader);
        }
    }

    static class UnloadTrackingClassLoader
    extends URLClassLoader {
        private final AtomicBoolean unloaded = new AtomicBoolean();

        public UnloadTrackingClassLoader(URL[] urls) {
            super(urls);
        }

        public UnloadTrackingClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.unloaded.set(true);
        }

        public AtomicBoolean getUnloadedAtomicBoolean() {
            return this.unloaded;
        }
    }
}

