/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.spi.scope;

import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.spi.scope.AbstractScopeResolver;
import org.int4.dirk.spi.scope.CreationalContext;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class AbstractScopeResolverTest {
    private String currentScope = null;
    private AbstractScopeResolver<String> scopeResolver = new AbstractScopeResolver<String>(){

        public Annotation getAnnotation() {
            return Annotations.of(Singleton.class);
        }

        protected String getCurrentScope() {
            return AbstractScopeResolverTest.this.currentScope;
        }
    };
    private int releaseCalls;
    private CreationalContext<I> creationalContext = new CreationalContext<I>(){

        public CreationalContext.Reference<I> create() throws CreationException, AmbiguousResolutionException, UnsatisfiedResolutionException {
            return new CreationalContext.Reference<I>(){
                private final I i = new I();

                public I get() {
                    return this.i;
                }

                public void release() {
                    ++AbstractScopeResolverTest.this.releaseCalls;
                }
            };
        }
    };

    static class I {
        I() {
        }
    }

    @Nested
    class WhenNew {
        WhenNew() {
        }

        @Test
        void shouldBeInactive() {
            Assertions.assertThat((boolean)AbstractScopeResolverTest.this.scopeResolver.isActive()).isFalse();
        }

        @Test
        void getShouldThrowScopeNotActiveExceptionWhenInactive() {
            Assertions.assertThatThrownBy(() -> AbstractScopeResolverTest.this.scopeResolver.get((Object)"key", AbstractScopeResolverTest.this.creationalContext)).isExactlyInstanceOf(ScopeNotActiveException.class);
        }

        @Test
        void removeShouldIgnoreMissingEntries() {
            Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.remove((Object)"key")).doesNotThrowAnyException();
        }

        @Test
        void destroyScopeShouldAllowDestroyingNonExistingScope() {
            Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.destroyScope((Object)"A")).doesNotThrowAnyException();
        }

        @Nested
        class AndAScopeBecomesActive {
            AndAScopeBecomesActive() {
                AbstractScopeResolverTest.this.currentScope = "A";
            }

            @Test
            void shouldBeActive() {
                Assertions.assertThat((boolean)AbstractScopeResolverTest.this.scopeResolver.isActive()).isTrue();
            }

            @Test
            void getShouldCreateNewInstance() throws Exception {
                I instance = (I)AbstractScopeResolverTest.this.scopeResolver.get((Object)"key", AbstractScopeResolverTest.this.creationalContext);
                Assertions.assertThat((Object)instance).isInstanceOf(I.class);
            }

            @Test
            void removeShouldIgnoreMissingEntries() {
                Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.remove((Object)"key")).doesNotThrowAnyException();
            }

            @Test
            void destroyScopeShouldAllowDestroyingExistingScope() {
                Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.destroyScope((Object)"A")).doesNotThrowAnyException();
            }

            @Nested
            class AndAnObjectWasCreated {
                private I i;

                AndAnObjectWasCreated() {
                }

                @BeforeEach
                void beforeEach() throws Exception {
                    this.i = (I)AbstractScopeResolverTest.this.scopeResolver.get((Object)"key", AbstractScopeResolverTest.this.creationalContext);
                }

                @Test
                void shouldBeActive() {
                    Assertions.assertThat((boolean)AbstractScopeResolverTest.this.scopeResolver.isActive()).isTrue();
                }

                @Test
                void getShouldGetCachedInstance() throws Exception {
                    I cachedInstance = (I)AbstractScopeResolverTest.this.scopeResolver.get((Object)"key", AbstractScopeResolverTest.this.creationalContext);
                    Assertions.assertThat((Object)cachedInstance).isInstanceOf(I.class);
                    Assertions.assertThat((Object)cachedInstance).isEqualTo((Object)this.i);
                }

                @Test
                void removeShouldIngoreNonExistingKeys() {
                    Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.remove((Object)"missing-key")).doesNotThrowAnyException();
                }

                @Test
                void removeShouldTriggerCreationContextRelease() {
                    Assertions.assertThat((int)AbstractScopeResolverTest.this.releaseCalls).isEqualTo(0);
                    AbstractScopeResolverTest.this.scopeResolver.remove((Object)"key");
                    Assertions.assertThat((int)AbstractScopeResolverTest.this.releaseCalls).isEqualTo(1);
                }

                @Test
                void destroyScopeShouldTriggerCreationContextRelease() {
                    Assertions.assertThat((int)AbstractScopeResolverTest.this.releaseCalls).isEqualTo(0);
                    AbstractScopeResolverTest.this.scopeResolver.destroyScope((Object)"A");
                    Assertions.assertThat((int)AbstractScopeResolverTest.this.releaseCalls).isEqualTo(1);
                }
            }
        }
    }
}

