/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.spi.scope;

import java.util.HashMap;
import java.util.Map;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.spi.scope.CreationalContext;
import org.int4.dirk.spi.scope.ScopeResolver;

public abstract class AbstractScopeResolver<S>
implements ScopeResolver {
    private final Map<S, Map<Object, CreationalContext.Reference<?>>> instancesByScope = new HashMap();

    @Override
    public final boolean isActive() {
        return this.getCurrentScope() != null;
    }

    @Override
    public final <T> T get(Object key, CreationalContext<T> creationalContext) throws Exception {
        S currentScope = this.getCurrentScope();
        if (currentScope == null) {
            throw new ScopeNotActiveException("Scope not active: " + this.getAnnotation() + " for: " + key);
        }
        Map instances = this.instancesByScope.computeIfAbsent(currentScope, k -> new HashMap());
        CreationalContext.Reference<T> reference = (CreationalContext.Reference<T>)instances.get(key);
        if (reference == null) {
            reference = creationalContext.create();
            instances.put(key, reference);
        }
        return reference.get();
    }

    @Override
    public final void remove(Object key) {
        for (Map<Object, CreationalContext.Reference<?>> map : this.instancesByScope.values()) {
            CreationalContext.Reference<?> reference = map.remove(key);
            if (reference == null) continue;
            reference.release();
        }
    }

    protected abstract S getCurrentScope();

    protected final void destroyScope(S scope) {
        Map<Object, CreationalContext.Reference<?>> instances = this.instancesByScope.remove(scope);
        if (instances != null) {
            for (CreationalContext.Reference<?> reference : instances.values()) {
                reference.release();
            }
        }
    }
}

