/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.spi;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.junit.AnalyzeClasses;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.library.DependencyRules;
import com.tngtech.archunit.library.dependencies.SlicesRuleDefinition;
import java.lang.reflect.Modifier;

@AnalyzeClasses(packages={"org.int4.dirk.spi"})
public class ArchitectureTest {
    static final String BASE_PACKAGE_NAME = "org.int4.dirk.spi";
    @ArchTest
    private final ArchRule packagesShouldBeFreeOfCycles = SlicesRuleDefinition.slices().matching("(**)").should().beFreeOfCycles();
    @ArchTest
    public static final ArchRule noClassesShouldPubliclyImplementInterfaceInSamePackage = ArchRuleDefinition.noClasses().should(ArchitectureTest.publiclyImplementInterfacesInSamePackage());
    @ArchTest
    private final ArchRule noClassesShouldDependOnUpperPackages = DependencyRules.NO_CLASSES_SHOULD_DEPEND_UPPER_PACKAGES;

    public static ArchCondition<JavaClass> publiclyImplementInterfacesInSamePackage() {
        return new ArchCondition<JavaClass>("publicly implement interfaces that reside in same package", new Object[0]){

            public void check(JavaClass cls, ConditionEvents events) {
                for (JavaClass iface : cls.getAllRawInterfaces()) {
                    boolean isSamePackageAndPublic = iface.getPackage().equals(cls.getPackage()) && Modifier.isPublic(cls.reflect().getModifiers()) && !Modifier.isAbstract(cls.reflect().getModifiers());
                    events.add((ConditionEvent)new SimpleConditionEvent((Object)iface, isSamePackageAndPublic, cls.getDescription() + " is public and not abstract and implements <" + iface.getFullName() + "> in same package"));
                }
            }
        };
    }
}

