/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.spi.scope;

import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import org.assertj.core.api.Assertions;
import org.int4.dirk.api.instantiation.AmbiguousResolutionException;
import org.int4.dirk.api.instantiation.CreationException;
import org.int4.dirk.api.instantiation.UnsatisfiedResolutionException;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.spi.scope.AbstractScopeResolver;
import org.int4.dirk.spi.scope.CreationalContext;
import org.int4.dirk.util.Annotations;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class AbstractScopeResolverTest {
    private String currentScope = null;
    private AbstractScopeResolver<String> scopeResolver = new AbstractScopeResolver<String>(){

        public Annotation getAnnotation() {
            return Annotations.of(Singleton.class);
        }

        protected String getCurrentScope() {
            return AbstractScopeResolverTest.this.currentScope;
        }
    };
    private int releaseCalls;
    private CreationalContext<I> creationalContext = new CreationalContext<I>(){

        public I get() throws CreationException, AmbiguousResolutionException, UnsatisfiedResolutionException {
            throw new IllegalStateException("Should not get called");
        }

        public void release() {
            ++AbstractScopeResolverTest.this.releaseCalls;
        }
    };

    static class I {
        I() {
        }
    }

    @Nested
    class WhenNew {
        WhenNew() {
        }

        @Test
        void shouldBeInactive() {
            Assertions.assertThat((boolean)AbstractScopeResolverTest.this.scopeResolver.isActive()).isFalse();
        }

        @Test
        void findShouldThrowScopeNotActiveExceptionWhenInactive() {
            Assertions.assertThatThrownBy(() -> AbstractScopeResolverTest.this.scopeResolver.find((Object)"key")).isExactlyInstanceOf(ScopeNotActiveException.class);
        }

        @Test
        void putShouldThrowScopeNotActiveExceptionWhenInactive() {
            Assertions.assertThatThrownBy(() -> AbstractScopeResolverTest.this.scopeResolver.put((Object)"key", AbstractScopeResolverTest.this.creationalContext)).isExactlyInstanceOf(ScopeNotActiveException.class);
        }

        @Test
        void removeShouldThrowScopeNotActiveExceptionWhenInactive() {
            Assertions.assertThatThrownBy(() -> AbstractScopeResolverTest.this.scopeResolver.remove((Object)"key")).isExactlyInstanceOf(ScopeNotActiveException.class);
        }

        @Test
        void destroyScopeShouldAllowDestroyingNonExistingScope() {
            Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.destroyScope((Object)"A")).doesNotThrowAnyException();
        }

        @Nested
        class AndAScopeBecomesActive {
            AndAScopeBecomesActive() {
                AbstractScopeResolverTest.this.currentScope = "A";
            }

            @Test
            void shouldBeActive() {
                Assertions.assertThat((boolean)AbstractScopeResolverTest.this.scopeResolver.isActive()).isTrue();
            }

            @Test
            void findShouldReturnNoResult() {
                Assertions.assertThat((Object)AbstractScopeResolverTest.this.scopeResolver.find((Object)"key")).isNull();
            }

            @Test
            void putShouldAddNewContext() {
                AbstractScopeResolverTest.this.scopeResolver.put((Object)"key", AbstractScopeResolverTest.this.creationalContext);
                Assertions.assertThat((Object)AbstractScopeResolverTest.this.scopeResolver.find((Object)"key")).isEqualTo(AbstractScopeResolverTest.this.creationalContext);
            }

            @Test
            void removeShouldIgnoreMissingEntries() {
                Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.remove((Object)"key")).doesNotThrowAnyException();
            }

            @Test
            void destroyScopeShouldAllowDestroyingExistingScope() {
                Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.destroyScope((Object)"A")).doesNotThrowAnyException();
            }

            @Nested
            class AndAnObjectWasCreated {
                AndAnObjectWasCreated() {
                }

                @BeforeEach
                void beforeEach() {
                    AbstractScopeResolverTest.this.scopeResolver.put((Object)"key", AbstractScopeResolverTest.this.creationalContext);
                }

                @Test
                void shouldBeActive() {
                    Assertions.assertThat((boolean)AbstractScopeResolverTest.this.scopeResolver.isActive()).isTrue();
                }

                @Test
                void findShouldGetCachedInstance() {
                    CreationalContext cachedContext = AbstractScopeResolverTest.this.scopeResolver.find((Object)"key");
                    Assertions.assertThat((Object)cachedContext).isEqualTo(AbstractScopeResolverTest.this.creationalContext);
                }

                @Test
                void removeShouldIngoreNonExistingKeys() {
                    Assertions.assertThatCode(() -> AbstractScopeResolverTest.this.scopeResolver.remove((Object)"missing-key")).doesNotThrowAnyException();
                }

                @Test
                void removeShouldTriggerCreationContextRelease() {
                    Assertions.assertThat((int)AbstractScopeResolverTest.this.releaseCalls).isEqualTo(0);
                    AbstractScopeResolverTest.this.scopeResolver.remove((Object)"key");
                    Assertions.assertThat((int)AbstractScopeResolverTest.this.releaseCalls).isEqualTo(1);
                }

                @Test
                void destroyScopeShouldTriggerCreationContextRelease() {
                    Assertions.assertThat((int)AbstractScopeResolverTest.this.releaseCalls).isEqualTo(0);
                    AbstractScopeResolverTest.this.scopeResolver.destroyScope((Object)"A");
                    Assertions.assertThat((int)AbstractScopeResolverTest.this.releaseCalls).isEqualTo(1);
                }
            }
        }
    }
}

