/*
 * Decompiled with CFR 0.152.
 */
package org.int4.dirk.spi.scope;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.int4.dirk.api.scope.ScopeNotActiveException;
import org.int4.dirk.spi.scope.CreationalContext;
import org.int4.dirk.spi.scope.ScopeResolver;

public abstract class AbstractScopeResolver<S>
implements ScopeResolver {
    private final Map<S, Map<Object, CreationalContext<?>>> instancesByScope = new ConcurrentHashMap();

    @Override
    public final boolean isActive() {
        return this.getCurrentScope() != null;
    }

    @Override
    public final CreationalContext<?> find(Object key) {
        S currentScope = this.getCurrentScope();
        if (currentScope == null) {
            throw new ScopeNotActiveException("Scope not active: " + this.getAnnotation() + " for: " + key);
        }
        Map<Object, CreationalContext<?>> map = this.instancesByScope.get(currentScope);
        return map == null ? null : map.get(key);
    }

    @Override
    public final void put(Object key, CreationalContext<?> creationalContext) {
        S currentScope = this.getCurrentScope();
        if (currentScope == null) {
            throw new ScopeNotActiveException("Scope not active: " + this.getAnnotation() + " for: " + key);
        }
        this.instancesByScope.computeIfAbsent(currentScope, k -> new ConcurrentHashMap()).put(key, creationalContext);
    }

    @Override
    public final void remove(Object key) {
        CreationalContext<?> existingContext;
        S currentScope = this.getCurrentScope();
        if (currentScope == null) {
            throw new ScopeNotActiveException("Scope not active: " + this.getAnnotation() + " for: " + key);
        }
        Map<Object, CreationalContext<?>> map = this.instancesByScope.get(currentScope);
        if (map != null && (existingContext = map.remove(key)) != null) {
            existingContext.release();
        }
    }

    protected abstract S getCurrentScope();

    protected final void destroyScope(S scope) {
        Map<Object, CreationalContext<?>> instances = this.instancesByScope.remove(scope);
        if (instances != null) {
            for (CreationalContext<?> existingContext : instances.values()) {
                existingContext.release();
            }
        }
    }
}

