/*
 * Decompiled with CFR 0.152.
 */
package org.intelligentsia.keystone.boot;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.intelligentsia.keystone.boot.Arguments;
import org.intelligentsia.keystone.boot.Console;
import org.intelligentsia.keystone.boot.ExtractionManager;
import org.intelligentsia.keystone.boot.JniLoader;
import org.intelligentsia.keystone.boot.KeystoneException;
import org.intelligentsia.keystone.boot.Restarter;
import org.intelligentsia.keystone.boot.VersionChecker;

public final class BootStrap {
    private static final String HOME_VAR = "#[home]";

    public static void main(String[] args) throws IOException {
        String mainClassName;
        File home;
        Map<String, String> arguments = Arguments.loadArguments(args, "keystone.properties");
        Boolean consoleLocationNeedHome = BootStrap.initializeConsoleLevel(arguments);
        if (!consoleLocationNeedHome.booleanValue()) {
            BootStrap.initializeConsoleLogLocation(arguments, null);
        }
        Console.VERBOSE("Arguments " + arguments);
        ExtractionManager.initialize(arguments);
        String minimalJvmVersion = Arguments.getStringArgument(arguments, "BootStrap.minimalJvmVersion", null);
        if (minimalJvmVersion != null && !VersionChecker.isCompatible(minimalJvmVersion)) {
            Console.WARNING("JVM Specification Version " + VersionChecker.getCurrentJavaVirtualMachineSpecificationVersion() + " is not compatible with specified requirement : '" + minimalJvmVersion + "'");
            return;
        }
        String location = BootStrap.getCodeSourceLocation();
        if (location == null || "".equals(location)) {
            Console.WARNING("Cannot Find Code Source location");
            return;
        }
        try {
            home = BootStrap.getHomeDirectory(arguments, location);
        }
        catch (IllegalStateException e) {
            Console.WARNING(e.getMessage(), e);
            return;
        }
        Console.INFO("Home Directory=" + home.getPath());
        if (consoleLocationNeedHome.booleanValue()) {
            BootStrap.initializeConsoleLogLocation(arguments, home);
        }
        if ((mainClassName = Arguments.getStringArgument(arguments, Attributes.Name.MAIN_CLASS.toString(), null)) == null) {
            Console.WARNING("No Main-Class Found");
            return;
        }
        Console.INFO("Main-Class=" + mainClassName);
        if (!ExtractionManager.explode(location, home)) {
            return;
        }
        if (Arguments.getBooleanArgument(arguments, "BootStrap.cleanUpBeforeShutdown", Boolean.FALSE).booleanValue()) {
            ExtractionManager.cleanUpHook(home);
        }
        List<URL> urls = null;
        try {
            urls = BootStrap.computeClassPath(home, arguments);
        }
        catch (IllegalStateException ise) {
            return;
        }
        URLClassLoader classloader = new URLClassLoader(urls.toArray(new URL[urls.size()]), Arguments.getBooleanArgument(arguments, "BootStrap.includeSystemClassLoader", Boolean.FALSE) != false ? ClassLoader.getSystemClassLoader() : ClassLoader.getSystemClassLoader().getParent()){

            @Override
            protected String findLibrary(String libname) {
                String libPath = JniLoader.findLibrary(new File(home, "lib"), libname);
                if (libPath == null && (libPath = JniLoader.findLibraryInClassPath(libname, new File(home, "lib-natives"))) == null) {
                    return super.findLibrary(libname);
                }
                return libPath;
            }
        };
        System.getProperties().put("BootStrap.location", location);
        System.getProperties().put("BootStrap.home", home.getPath());
        System.getProperties().put("BootStrap.keystone.version", Arguments.getStringArgument(arguments, "BootStrap.keystone.version", "unknown"));
        System.getProperties().put("BootStrap.project.version", Arguments.getStringArgument(arguments, "BootStrap.project.version", "unknown"));
        BootStrap.invokeMain(classloader, mainClassName, args, home);
        Console.INFO("Exit");
    }

    private static Boolean initializeConsoleLevel(Map<String, String> arguments) {
        Boolean needHome = Boolean.FALSE;
        String logfileName = Arguments.getStringArgument(arguments, "BootStrap.logFile", null);
        if (logfileName != null) {
            needHome = logfileName.indexOf(HOME_VAR) >= 0;
        }
        Console.setInfo(Arguments.getBooleanArgument(arguments, "BootStrap.info", Boolean.TRUE));
        Console.setVerbose(Arguments.getBooleanArgument(arguments, "BootStrap.verbose", Boolean.FALSE));
        return needHome;
    }

    private static void initializeConsoleLogLocation(Map<String, String> arguments, File home) {
        String logfileName = Arguments.getStringArgument(arguments, "BootStrap.logFile", null);
        if (logfileName != null) {
            File log = null;
            int index = logfileName.indexOf(HOME_VAR);
            log = index >= 0 ? new File(home, logfileName.substring(HOME_VAR.length())) : new File(logfileName);
            Console.setLogFile(log);
        }
    }

    private static List<URL> computeClassPath(File home, Map<String, String> arguments) throws IllegalStateException {
        Boolean includeJavaHomeLib = Arguments.getBooleanArgument(arguments, "BootStrap.includeJavaHomeLib", Boolean.TRUE);
        String javaHome = System.getProperty("java.home", null);
        ArrayList<URL> urls = new ArrayList<URL>();
        if (includeJavaHomeLib.booleanValue()) {
            Console.VERBOSE("Including Java Home Libraries");
            try {
                if (javaHome != null) {
                    urls.addAll(BootStrap.computeFromDirectory(new File(javaHome, "lib")));
                } else {
                    Console.WARNING("Java Home property is not set");
                }
            }
            catch (MalformedURLException ex) {
                Console.WARNING("error when including JavaHomeLib :" + ex.getMessage());
                throw new IllegalStateException("error when including JavaHomeLib", ex);
            }
        }
        try {
            urls.addAll(BootStrap.computeFromDirectory(new File(home, "lib")));
        }
        catch (MalformedURLException ex) {
            Console.WARNING("error when including './lib' :" + ex.getMessage());
            throw new IllegalStateException("error when including './lib'", ex);
        }
        String extraLibrariesFolderPath = Arguments.getStringArgument(arguments, "BootStrap.extraLibrariesFolderPath", null);
        if (extraLibrariesFolderPath != null) {
            try {
                File extra = new File(extraLibrariesFolderPath);
                if (!extra.exists()) {
                    extra = new File(home, extraLibrariesFolderPath);
                }
                urls.addAll(BootStrap.computeFromDirectory(extra));
            }
            catch (MalformedURLException e) {
                Console.WARNING("error when including '" + extraLibrariesFolderPath + "' :" + e.getMessage());
                throw new IllegalStateException("error when including '" + extraLibrariesFolderPath + "'", e);
            }
        }
        Console.VERBOSE("ClassPath: " + ((Object)urls).toString());
        return urls;
    }

    private static void invokeMain(ClassLoader classloader, String mainClassName, String[] arguments, File home) throws SecurityException {
        Class<?> mainClass = null;
        try {
            Thread.currentThread().setContextClassLoader(classloader);
            mainClass = classloader.loadClass(mainClassName);
        }
        catch (ClassNotFoundException ex) {
            Console.WARNING("class '" + mainClassName + "' not found: " + ex.getMessage());
        }
        if (mainClass != null) {
            Method main = null;
            try {
                main = mainClass.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException ex) {
                Console.WARNING("class '" + mainClassName + "' did not have a method 'main': " + ex.getMessage());
            }
            catch (SecurityException ex) {
                Console.WARNING("class '" + mainClassName + "', can not access to 'main' method  : " + ex.getMessage());
            }
            if (main != null) {
                main.setAccessible(true);
                Console.VERBOSE("Entering main");
                try {
                    main.invoke(null, new Object[]{arguments});
                    Console.VERBOSE("Exiting main");
                }
                catch (Throwable throwable) {
                    BootStrap.processKeystoneException(home, throwable);
                }
            } else {
                Console.WARNING("The main() method in class '" + mainClassName + "' not found.");
            }
        }
    }

    public static void processKeystoneException(final File home, Throwable exception) {
        Throwable throwable = BootStrap.findRootCause(exception);
        if (KeystoneException.class.isAssignableFrom(throwable.getClass())) {
            KeystoneException keystoneException = (KeystoneException)throwable;
            switch (keystoneException.getOperation()) {
                case CLEAN: {
                    Console.VERBOSE("Cleanning before shutdown");
                    ExtractionManager.cleanUp(home);
                    break;
                }
                case RESTART: {
                    Console.VERBOSE("Restarting");
                    BootStrap.restart(new Runnable(){

                        @Override
                        public void run() {
                            ExtractionManager.cleanUpHook(home);
                        }
                    });
                    break;
                }
                case NONE: {
                    Console.WARNING("KeystoneException without operation: " + keystoneException.getMessage(), keystoneException);
                    break;
                }
                default: {
                    Console.WARNING("KeystoneException operation not supported '" + (Object)((Object)keystoneException.getOperation()) + "': " + keystoneException.getMessage(), keystoneException);
                    break;
                }
            }
        } else {
            Console.WARNING("Exception occur : " + exception.getMessage(), exception);
        }
    }

    public static Throwable findRootCause(Throwable throwable) {
        Throwable rootCause = null;
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    private static List<URL> computeFromDirectory(File directory) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            for (File child : directory.listFiles()) {
                if (child.isDirectory()) {
                    urls.addAll(BootStrap.computeFromDirectory(new File(child.getPath())));
                    continue;
                }
                if (!child.getName().endsWith(".jar")) continue;
                urls.add(child.toURI().toURL());
            }
        }
        return urls;
    }

    private static String getCodeSourceLocation() {
        String root = null;
        ProtectionDomain protectionDomain = BootStrap.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL rootUrl = codeSource.getLocation();
        try {
            root = URLDecoder.decode(rootUrl.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Console.WARNING("Unable to decode '" + rootUrl.getFile() + "' " + ex.getMessage(), ex);
        }
        return root;
    }

    private static File getHomeDirectory(Map<String, String> arguments, String location) throws IllegalStateException {
        String path = Arguments.getStringArgument(arguments, "BootStrap.explodeDirectory", location != null ? new File(location).getParentFile().getAbsolutePath() : null);
        try {
            File home;
            File file = home = path != null ? new File(path) : ExtractionManager.createTempDir();
            if (!home.canWrite()) {
                Console.WARNING("Home Directory is not Writable, using a temp directory.");
                try {
                    home = ExtractionManager.createTempDir();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to create home temp directory.", e);
                }
            }
            if (!home.isDirectory()) {
                throw new IllegalStateException(home.getPath() + " is not a directory");
            }
            return home;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create home temp directory.", e);
        }
    }

    public static void restart(Runnable runnable) {
        Console.VERBOSE("(Restart with '" + System.getProperty("BootStrap.location") + "'");
        Restarter.restartWith(runnable, "-jar ", System.getProperty("BootStrap.location"), "--BootStrap.restarted");
    }
}

