/*
 * Decompiled with CFR 0.152.
 */
package org.intelligentsia.keystone.boot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Console {
    private static Boolean info = Boolean.TRUE;
    private static Boolean verbose = Boolean.FALSE;

    public static void setInfo(Boolean info) {
        Console.info = info;
    }

    public static void setVerbose(Boolean verbose) {
        Console.verbose = verbose;
    }

    public static void setLogFile(File logFile) {
        if (logFile != null) {
            if (!logFile.getParentFile().exists() && !logFile.getParentFile().mkdirs()) {
                Console.WARNING("Unable to create path for log file " + logFile.getPath());
                return;
            }
            BufferedOutputStream log = null;
            try {
                log = new BufferedOutputStream(new FileOutputStream(logFile, true));
                System.setOut(new PrintStream(log, true));
                System.setErr(new PrintStream(log, true));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void VERBOSE(String message) {
        Console.VERBOSE(message, null);
    }

    public static void VERBOSE(String message, Throwable throwable) {
        if (verbose.booleanValue()) {
            System.out.println(Console.getGmtDate(new Date()) + ", BootStrap: " + message);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    public static void WARNING(String message, Throwable throwable) {
        System.err.println(Console.getGmtDate(new Date()) + ", BootStrap Warning: " + message);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    public static void WARNING(String message) {
        Console.WARNING(message, null);
    }

    public static void INFO(String message) {
        if (info.booleanValue()) {
            System.out.println(Console.getGmtDate(new Date()) + ", BootStrap Info: " + message);
        }
    }

    private static String getGmtDate(Date when) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss S", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(when) + " GMT";
    }
}

