/*
 * Decompiled with CFR 0.152.
 */
package org.intelligentsia.keystone.boot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.intelligentsia.keystone.boot.Console;
import org.intelligentsia.keystone.boot.ExtractionManager;

public class JniLoader {
    public static String findLibrary(File directory, String libname) {
        String systemLibName = System.mapLibraryName(libname);
        File lib = new File(directory, systemLibName);
        if (!lib.exists()) {
            return null;
        }
        Console.VERBOSE("Library '" + libname + "' found ('" + lib.getAbsolutePath() + "')");
        return lib.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findLibraryInClassPath(String libname, File destination) {
        String buf2;
        FileOutputStream outputStream;
        InputStream inputStream;
        String systemLibName;
        block7: {
            systemLibName = System.mapLibraryName(libname);
            File lib = new File(destination, systemLibName);
            if (lib.exists()) {
                return lib.getAbsolutePath();
            }
            lib.getParentFile().mkdirs();
            inputStream = null;
            outputStream = null;
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(systemLibName);
            if (inputStream == null) break block7;
            outputStream = new FileOutputStream(lib);
            byte[] buf2 = new byte[16384];
            int len = 0;
            while ((len = inputStream.read(buf2)) > 0) {
                ((OutputStream)outputStream).write(buf2, 0, len);
            }
            Console.VERBOSE("Library '" + libname + "' found in classpath resource");
            String string = lib.getAbsolutePath();
            ExtractionManager.close(inputStream);
            ExtractionManager.close(outputStream);
            return string;
        }
        try {
            buf2 = null;
        }
        catch (IOException e) {
            String string;
            try {
                Console.VERBOSE("Error when copy native library : " + systemLibName, e);
                string = null;
            }
            catch (Throwable throwable) {
                ExtractionManager.close(inputStream);
                ExtractionManager.close(outputStream);
                throw throwable;
            }
            ExtractionManager.close(inputStream);
            ExtractionManager.close(outputStream);
            return string;
        }
        ExtractionManager.close(inputStream);
        ExtractionManager.close(outputStream);
        return buf2;
    }

    public static Boolean loadLibraries(File directory, String libnames) {
        StringTokenizer tokenizer = new StringTokenizer(libnames, ",");
        Boolean result = Boolean.TRUE;
        while (tokenizer.hasMoreTokens() && result.booleanValue()) {
            result = JniLoader.loadLibrary(directory, tokenizer.nextToken());
        }
        return result;
    }

    public static Boolean loadLibrary(File directory, String libname) {
        String libPath = JniLoader.findLibrary(directory, libname);
        if (libPath == null) {
            Console.WARNING("Library '" + libname + "' has not be found ('" + libPath + "')");
            return Boolean.FALSE;
        }
        try {
            Runtime.getRuntime().load(libPath);
        }
        catch (UnsatisfiedLinkError e) {
            Console.WARNING("Library '" + libname + "' not found ('" + libPath + "') or her dependencies not ever loaded", e);
            return Boolean.FALSE;
        }
        catch (Throwable e) {
            Console.WARNING("Loading Library '" + libname + "'", e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

