/*
 * Decompiled with CFR 0.152.
 */
package org.intelligentsia.keystone.boot;

import org.intelligentsia.keystone.boot.Console;
import org.intelligentsia.keystone.boot.SimpleVersion;

public final class VersionChecker {
    public static boolean isCompatible(String minimalJvmVersion) {
        SimpleVersion current = null;
        SimpleVersion minimal = null;
        try {
            current = SimpleVersion.parse(VersionChecker.getCurrentJavaVirtualMachineSpecificationVersion());
        }
        catch (NumberFormatException e) {
            Console.WARNING("Unable to parse JVM Version ('" + VersionChecker.getCurrentJavaVirtualMachineSpecificationVersion() + "')");
            Console.WARNING("Continue without check your requirement");
            return Boolean.TRUE;
        }
        try {
            minimal = SimpleVersion.parse(minimalJvmVersion);
        }
        catch (NumberFormatException e) {
            Console.WARNING("Minimal JVM Version parameter is not valid ('" + minimalJvmVersion + "')");
            Console.WARNING("Assuming that current JVM follows your requirement");
            return Boolean.TRUE;
        }
        return current.isBackwardCompatible(minimal);
    }

    public static String getCurrentJavaVirtualMachineSpecificationVersion() {
        return System.getProperty("java.vm.specification.version", "1.4");
    }
}

