/*
 * Decompiled with CFR 0.152.
 */
package org.intelligentsia.keystone.boot;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.intelligentsia.keystone.boot.Arguments;
import org.intelligentsia.keystone.boot.Console;

public class ExtractionManager {
    private static Boolean cleanUpLib = Boolean.TRUE;
    private static Boolean hookAdded = Boolean.FALSE;

    public static void initialize(Map<String, String> arguments) {
        cleanUpLib = Arguments.getBooleanArgument(arguments, "BootStrap.cleanUpLib", Boolean.TRUE);
    }

    public static boolean explode(String location, File home) {
        ExtractionManager.cleanUp(home);
        try {
            if (location != null) {
                ExtractionManager.explode(new File(home, "lib"), "META-INF/lib/", location, Boolean.FALSE);
                ExtractionManager.explode(new File(home, "lib"), "lib/", location, Boolean.FALSE);
            } else {
                Console.WARNING("Error when exploding : Location is null");
            }
        }
        catch (Throwable t) {
            Console.WARNING("Error when exploding : " + t.getMessage(), t);
            return false;
        }
        return true;
    }

    public static void cleanUp(File home) {
        ExtractionManager.cleanUp(home, Boolean.FALSE);
    }

    public static void cleanUp(File home, Boolean force) {
        if (cleanUpLib.booleanValue() || force.booleanValue()) {
            Console.VERBOSE("Clean up lib");
            File lib = new File(home, "lib");
            if (lib.exists() && !ExtractionManager.delete(lib)) {
                Console.WARNING("Unable to Clean up lib folder");
            }
        }
    }

    public static void cleanUpHook(final File home) {
        if (!hookAdded.booleanValue()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    File lib = new File(home, "lib");
                    if (lib.exists()) {
                        ExtractionManager.delete(lib);
                    }
                }
            }));
            hookAdded = Boolean.TRUE;
        }
    }

    public static File createTempDir() throws IOException {
        String dirName;
        File newTempDir;
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
        } while ((newTempDir = new File(sysTempDir, dirName = UUID.randomUUID().toString())).exists());
        if (newTempDir.mkdirs()) {
            return newTempDir;
        }
        throw new IOException("Failed to create temp dir named " + newTempDir.getAbsolutePath());
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException exception) {
                Console.VERBOSE("Closing Error", exception);
            }
        }
    }

    public static boolean delete(File from) {
        if (from != null && from.exists()) {
            if (from.isDirectory()) {
                for (File child : from.listFiles()) {
                    ExtractionManager.delete(child);
                }
            }
            return from.delete();
        }
        return false;
    }

    private static void explode(File home, String fromPath, String jarPath, Boolean override) throws IOException, ZipException {
        File check = new File(jarPath);
        if (check.exists() && !check.isDirectory()) {
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            for (JarEntry entry : Collections.list(jar.entries())) {
                String name = entry.getName();
                if (!name.startsWith(fromPath)) continue;
                Console.VERBOSE("Exploding: " + name);
                String targetName = name.substring(fromPath.length()).trim();
                if ("".equals(targetName)) continue;
                File localFile = new File(home, targetName);
                if (override.booleanValue() && localFile.exists()) {
                    localFile.delete();
                }
                if (localFile.exists()) continue;
                ExtractionManager.explodeEntry(targetName, localFile, jar, name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void explodeEntry(String targetName, File localFile, JarFile jar, String name) throws IOException {
        if (targetName.endsWith("/")) {
            if (!localFile.mkdirs()) {
                throw new IOException("Unable to create directory '" + localFile.getPath() + "'");
            }
        } else if (!localFile.exists()) {
            File parent = localFile.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("Parent File Of '" + localFile.getPath() + "' could not be created");
            }
            if (!localFile.createNewFile()) {
                throw new IOException("Unable to create file " + localFile.getPath());
            }
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = jar.getInputStream(jar.getEntry(name));
                if (inputStream == null) {
                    throw new IOException("Unable to access resource '" + name + "'");
                }
                outputStream = new FileOutputStream(localFile);
                byte[] buf = new byte[16384];
                int len = 0;
                while ((len = inputStream.read(buf)) > 0) {
                    ((OutputStream)outputStream).write(buf, 0, len);
                }
            }
            catch (IOException exception) {
                try {
                    Console.VERBOSE("Error when exploding Entry: " + name, exception);
                    ExtractionManager.delete(localFile);
                }
                catch (Throwable throwable) {
                    ExtractionManager.close(inputStream);
                    ExtractionManager.close(outputStream);
                    throw throwable;
                }
                ExtractionManager.close(inputStream);
                ExtractionManager.close(outputStream);
            }
            ExtractionManager.close(inputStream);
            ExtractionManager.close(outputStream);
        }
    }
}

