/*
 * Decompiled with CFR 0.152.
 */
package org.intelligentsia.keystone.boot;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.intelligentsia.keystone.boot.OSDetector;

public class Restarter {
    private static final String SUN_JAVA_COMMAND = "sun.java.command";

    public static void autoRestart(Runnable runBeforeRestart) throws IllegalStateException {
        if (System.getProperty(SUN_JAVA_COMMAND) != null) {
            ArrayList<String> parameters = new ArrayList<String>();
            String[] mainCommand = System.getProperty(SUN_JAVA_COMMAND).split(" ");
            if (mainCommand[0].endsWith(".jar")) {
                parameters.add("-jar " + new File(mainCommand[0]).getPath());
            } else {
                parameters.add(mainCommand[0]);
            }
            for (int i = 1; i < mainCommand.length; ++i) {
                parameters.add(mainCommand[i]);
            }
            Restarter.restartWith(runBeforeRestart, parameters.toArray(new String[0]));
            return;
        }
        throw new IllegalStateException("Unable to Autorestart");
    }

    public static void restartWith(Runnable runBeforeRestart, String ... parameters) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(Restarter.getJavaCommand());
        commands.addAll(Restarter.getJVMArgument());
        commands.addAll(Arrays.asList(parameters));
        StringBuilder builder = new StringBuilder();
        for (String command : commands) {
            builder.append(command).append(' ');
        }
        final String cmd = builder.toString();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        if (runBeforeRestart != null) {
            runBeforeRestart.run();
        }
        System.exit(0);
    }

    private static String getJavaCommand() {
        if (OSDetector.isMac()) {
            return "open";
        }
        String path = System.getProperty("sun.boot.library.path");
        if (path == null || "".endsWith(path)) {
            path = System.getProperty("java.home") + File.separator + "bin";
        }
        File root = new File(path);
        for (String name : Arrays.asList(OSDetector.isLinux() ? "javaw" : "javaw.exe", OSDetector.isLinux() ? "java" : "java.exe")) {
            File java = new File(root, name);
            if (!java.exists()) continue;
            return java.getAbsolutePath();
        }
        return "java";
    }

    private static List<String> getJVMArgument() {
        String cp;
        List<String> lst = ManagementFactory.getRuntimeMXBean().getInputArguments();
        ArrayList<String> jvmArguments = new ArrayList<String>();
        boolean xmxset = false;
        boolean xmsset = false;
        boolean maxPermSize = false;
        boolean useconc = false;
        boolean minheap = false;
        boolean maxheap = false;
        boolean classpath = false;
        for (String h : lst) {
            if (h.contains("-agentlib")) continue;
            if (h.contains("Xmx")) {
                xmxset = true;
                if (Runtime.getRuntime().maxMemory() < 533000000L) {
                    jvmArguments.add("-Xmx512m");
                    continue;
                }
            } else if (h.contains("Xms")) {
                xmsset = true;
            } else if (h.contains("XX:+useconc")) {
                useconc = true;
            } else if (h.contains("minheapfree")) {
                minheap = true;
            } else if (h.contains("maxheapfree")) {
                maxheap = true;
            } else if (h.contains("-XX:MaxPermSize")) {
                maxPermSize = true;
            }
            jvmArguments.add(h);
        }
        if (!xmsset) {
            jvmArguments.add("-Xms64m");
        }
        if (!xmxset) {
            jvmArguments.add("-Xmx512m");
        }
        if (!maxPermSize) {
            jvmArguments.add("-XX:MaxPermSize=128M");
        }
        if (!useconc) {
            jvmArguments.add("-XX:+UseConcMarkSweepGC");
        }
        if (!minheap) {
            jvmArguments.add("-XX:MinHeapFreeRatio=0");
        }
        if (!maxheap) {
            jvmArguments.add("-XX:MaxHeapFreeRatio=0");
        }
        if ((cp = System.getProperty("java.class.path")) != null && !"".equals(cp)) {
            jvmArguments.add("-cp \"" + System.getProperty("java.class.path") + "\"");
        }
        return jvmArguments;
    }
}

