/*
 * Decompiled with CFR 0.152.
 */
package org.intelligentsia.keystone.boot;

import java.io.Serializable;
import java.util.StringTokenizer;

public final class SimpleVersion
implements Comparable<SimpleVersion>,
Serializable {
    private static final long serialVersionUID = -2059600592653555167L;
    private final Integer major;
    private final Integer medium;

    public SimpleVersion(Integer major, Integer medium) throws NullPointerException {
        if (major == null) {
            throw new NullPointerException("major");
        }
        this.major = major;
        this.medium = medium != null ? Integer.valueOf(Math.abs(medium)) : null;
    }

    public static final SimpleVersion parse(String version) throws IllegalArgumentException, NumberFormatException {
        StringTokenizer tokenizer = new StringTokenizer(version, "-");
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException(version + " is not a valid Version");
        }
        String numbers = tokenizer.nextToken();
        tokenizer = new StringTokenizer(numbers, ".");
        Integer major = Integer.parseInt(tokenizer.nextToken());
        Integer medium = null;
        if (tokenizer.hasMoreTokens()) {
            medium = Integer.parseInt(tokenizer.nextToken());
        }
        return new SimpleVersion(major, medium);
    }

    @Override
    public int compareTo(SimpleVersion version) {
        int result = this.major.compareTo(version.major);
        if (result == 0 && this.medium != null) {
            result = version.medium == null ? 1 : this.medium.compareTo(version.medium);
        }
        return result;
    }

    public boolean isBackwardCompatible(SimpleVersion version) {
        return this.major.equals(version.major) && this.compareTo(version) >= 0;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMedium() {
        return this.medium;
    }

    public String toString() {
        return this.major + "." + this.medium;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.major == null ? 0 : this.major.hashCode());
        result = 31 * result + (this.medium == null ? 0 : this.medium.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleVersion other = (SimpleVersion)obj;
        if (this.major == null ? other.major != null : !this.major.equals(other.major)) {
            return false;
        }
        return !(this.medium == null ? other.medium != null : !this.medium.equals(other.medium));
    }
}

