/*
 * Decompiled with CFR 0.152.
 */
package org.intelligentsia.keystone.boot;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.intelligentsia.keystone.boot.BootStrap;
import org.intelligentsia.keystone.boot.Console;

public class Arguments {
    public static Map<String, String> loadArguments(String[] argv) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (argv != null) {
            for (int i = 0; i < argv.length; ++i) {
                String option = argv[i];
                if (option.startsWith("--")) {
                    int equalPos = option.indexOf(61);
                    String paramName = option.substring(2, equalPos == -1 ? option.length() : equalPos);
                    if (equalPos != -1) {
                        result.put(paramName, option.substring(equalPos + 1));
                        continue;
                    }
                    result.put(paramName, Boolean.TRUE.toString());
                    continue;
                }
                result.put(option, option);
            }
        }
        return result;
    }

    public static String[] argumentToArray(Map<String, String> arguments) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            if (entry.getKey().equals(entry.getValue())) {
                result.add(entry.getKey());
                continue;
            }
            if (entry.getValue().equals(Boolean.TRUE.toString())) {
                result.add("--" + entry.getKey());
                continue;
            }
            result.add("--" + entry.getKey() + "=" + entry.getValue());
        }
        return result.toArray(new String[0]);
    }

    public static Map<String, String> loadArguments(String[] argv, String name) throws IOException {
        Map<String, String> arguments = Arguments.loadArguments(argv);
        Arguments.loadPropsFrom("file:" + name, arguments);
        Arguments.loadPropsFrom("META-INF/" + name, arguments);
        Arguments.loadPropsFrom("/" + name, arguments);
        Arguments.loadPropsFrom(name, arguments);
        return arguments;
    }

    public static Boolean getBooleanArgument(Map<String, String> args, String name, Boolean defaultTrue) {
        String value = args.get(name);
        if (defaultTrue != null && defaultTrue.booleanValue()) {
            return value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    public static String getStringArgument(Map<String, String> args, String name, String defaultValue) {
        return args.get(name) == null ? defaultValue : args.get(name);
    }

    public static Integer getIntegerArgument(Map<String, String> args, String name, Integer defaultValue) {
        try {
            return Integer.parseInt(Arguments.getStringArgument(args, name, Integer.toString(defaultValue)));
        }
        catch (NumberFormatException exception) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropsFrom(String name, Map<String, String> args) throws IOException {
        InputStream is = null;
        try {
            is = BootStrap.class.getClassLoader().getResourceAsStream(name);
            if (is != null) {
                Properties properties = new Properties();
                properties.load(is);
                Iterator<Object> i = properties.keySet().iterator();
                while (i.hasNext()) {
                    String key = ((String)i.next()).trim();
                    if (args.containsKey(key)) continue;
                    args.put(key, properties.getProperty(key));
                }
                properties.clear();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException exception) {
                    Console.VERBOSE("Closing Error", exception);
                }
            }
        }
    }
}

