/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.postprocess;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.intermine.bio.util.ClobAccessReverseComplement;
import org.intermine.bio.util.PostProcessUtil;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.Sequence;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.PendingClob;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.postprocess.PostProcessor;
import org.intermine.util.DynamicUtil;

public class TransferSequencesProcess
extends PostProcessor {
    private Model model;
    private static final Logger LOG = Logger.getLogger(TransferSequencesProcess.class);

    public TransferSequencesProcess(ObjectStoreWriter osw) {
        super(osw);
    }

    public void postProcess() throws ObjectStoreException {
        this.model = Model.getInstanceByName((String)"genomic");
        try {
            this.transferToLocatedSequenceFeatures();
            this.transferToTranscripts();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to transfer sequences " + e);
        }
    }

    private void storeNewSequence(SequenceFeature feature, ClobAccess sequenceString) throws ObjectStoreException {
        Sequence sequence = (Sequence)DynamicUtil.createObject(Collections.singleton(Sequence.class));
        sequence.setResidues(sequenceString);
        sequence.setLength(sequenceString.length());
        this.osw.store((Object)sequence);
        feature.proxySequence(new ProxyReference(this.osw.getObjectStore(), sequence.getId(), Sequence.class));
        feature.setLength(new Integer(sequenceString.length()));
        this.osw.store((Object)feature);
    }

    protected void transferToLocatedSequenceFeatures() throws Exception {
        long startTime = System.currentTimeMillis();
        ObjectStore os = this.osw.getObjectStore();
        Query q = new Query();
        QueryClass qcChr = new QueryClass(Chromosome.class);
        q.addFrom((FromElement)qcChr);
        q.addToSelect((QuerySelectable)qcChr);
        QueryObjectReference seqRef = new QueryObjectReference(qcChr, "sequence");
        ContainsConstraint cc = new ContainsConstraint((QueryReference)seqRef, ConstraintOp.IS_NOT_NULL);
        q.setConstraint((Constraint)cc);
        SingletonResults res = os.executeSingleton(q);
        Iterator chrIter = res.iterator();
        HashSet<Chromosome> chromosomes = new HashSet<Chromosome>();
        while (chrIter.hasNext()) {
            Chromosome chr = (Chromosome)chrIter.next();
            chromosomes.add(chr);
        }
        LOG.info((Object)("Found " + chromosomes.size() + " chromosomes with sequence, took " + (System.currentTimeMillis() - startTime) + " ms."));
        for (Chromosome chr : chromosomes) {
            String organism = "";
            if (chr.getOrganism() != null) {
                organism = chr.getOrganism().getShortName();
            }
            LOG.info((Object)("Starting transfer for " + organism + " chromosome " + chr.getPrimaryIdentifier()));
            this.transferForChromosome(chr);
            this.transferToCDSs(chr);
        }
    }

    protected void transferForChromosome(Chromosome chr) throws Exception {
        long startTime = System.currentTimeMillis();
        ObjectStore os = this.osw.getObjectStore();
        Query q = new Query();
        q.setDistinct(false);
        QueryClass qcChr = new QueryClass(Chromosome.class);
        QueryField qfChrId = new QueryField(qcChr, "id");
        q.addFrom((FromElement)qcChr);
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        SimpleConstraint sc = new SimpleConstraint((QueryEvaluable)qfChrId, ConstraintOp.EQUALS, (QueryEvaluable)new QueryValue((Object)chr.getId()));
        cs.addConstraint((Constraint)sc);
        QueryClass qcSub = new QueryClass(SequenceFeature.class);
        q.addFrom((FromElement)qcSub);
        q.addToSelect((QuerySelectable)qcSub);
        q.addToOrderBy((QueryOrderable)qcSub);
        QueryClass qcLoc = new QueryClass(Location.class);
        q.addFrom((FromElement)qcLoc);
        q.addToSelect((QuerySelectable)qcLoc);
        QueryObjectReference ref1 = new QueryObjectReference(qcLoc, "locatedOn");
        ContainsConstraint cc1 = new ContainsConstraint((QueryReference)ref1, ConstraintOp.CONTAINS, qcChr);
        cs.addConstraint((Constraint)cc1);
        QueryObjectReference ref2 = new QueryObjectReference(qcLoc, "feature");
        ContainsConstraint cc2 = new ContainsConstraint((QueryReference)ref2, ConstraintOp.CONTAINS, qcSub);
        cs.addConstraint((Constraint)cc2);
        QueryObjectReference lsfSeqRef = new QueryObjectReference(qcSub, "sequence");
        ContainsConstraint lsfSeqRefNull = new ContainsConstraint((QueryReference)lsfSeqRef, ConstraintOp.IS_NULL);
        cs.addConstraint((Constraint)lsfSeqRefNull);
        q.setConstraint((Constraint)cs);
        this.osw.beginTransaction();
        HashSet<QueryClass> indexesToCreate = new HashSet<QueryClass>();
        indexesToCreate.add(qcLoc);
        indexesToCreate.add(qcSub);
        ((ObjectStoreInterMineImpl)os).precompute(q, indexesToCreate, "precompute");
        Results results = os.execute(q, 1000, true, true, true);
        Iterator resIter = results.iterator();
        long start = System.currentTimeMillis();
        int i = 0;
        while (resIter.hasNext()) {
            ResultsRow rr = (ResultsRow)resIter.next();
            SequenceFeature feature = (SequenceFeature)rr.get(0);
            Location locationOnChr = (Location)rr.get(1);
            if (this.model == null) {
                this.model = Model.getInstanceByName((String)"genomic");
            }
            try {
                Gene gene;
                if (PostProcessUtil.isInstance((Model)this.model, (InterMineObject)feature, (String)"ChromosomeBand") || PostProcessUtil.isInstance((Model)this.model, (InterMineObject)feature, (String)"SNP") || PostProcessUtil.isInstance((Model)this.model, (InterMineObject)feature, (String)"Transcript") || PostProcessUtil.isInstance((Model)this.model, (InterMineObject)feature, (String)"CDS") || PostProcessUtil.isInstance((Model)this.model, (InterMineObject)feature, (String)"SequenceAlteration")) continue;
                if (feature instanceof Gene && (gene = (Gene)feature).getLength() != null && gene.getLength() > 2000000) {
                    LOG.warn((Object)("gene too long in transferToSequenceFeatures() ignoring: " + gene));
                    continue;
                }
                ClobAccess featureSeq = TransferSequencesProcess.getSubSequence(chr.getSequence(), locationOnChr);
                if (featureSeq == null) continue;
                Sequence sequence = (Sequence)DynamicUtil.createObject(Collections.singleton(Sequence.class));
                sequence.setResidues(featureSeq);
                sequence.setLength(featureSeq.length());
                this.osw.store((Object)sequence);
                SequenceFeature cloneLsf = (SequenceFeature)PostProcessUtil.cloneInterMineObject((InterMineObject)feature);
                cloneLsf.setSequence(sequence);
                cloneLsf.setLength(new Integer(featureSeq.length()));
                this.osw.store((Object)cloneLsf);
                if (++i % 1000 != 0) continue;
                long now = System.currentTimeMillis();
                LOG.info((Object)("Set sequences for " + i + " features (avg = " + 60000L * (long)i / (now - start) + " per minute)"));
            }
            catch (Exception e) {
                Exception e2 = new Exception("Exception while processing SequenceFeature " + feature);
                e2.initCause(e);
                throw e2;
            }
        }
        this.osw.commitTransaction();
        String organism = "";
        if (chr.getOrganism() != null) {
            organism = chr.getOrganism().getShortName();
        }
        LOG.info((Object)("Finished setting " + i + " feature sequences for " + organism + " chromosome " + chr.getPrimaryIdentifier() + " - took " + (System.currentTimeMillis() - startTime) + " ms."));
    }

    private static ClobAccess getSubSequence(Sequence chromosomeSequence, Location locationOnChr) {
        ClobAccess chromosomeSequenceString;
        int charsToCopy = locationOnChr.getEnd() - locationOnChr.getStart() + 1;
        if (charsToCopy > (chromosomeSequenceString = chromosomeSequence.getResidues()).length()) {
            LOG.warn((Object)("SequenceFeature too long, ignoring - Location: " + locationOnChr.getId() + "  LSF id: " + locationOnChr.getFeature()));
            return null;
        }
        int startPos = locationOnChr.getStart() - 1;
        int endPos = startPos + charsToCopy;
        if (startPos < 0 || endPos < 0) {
            LOG.warn((Object)("SequenceFeature has negative coordinate, ignoring Location: " + locationOnChr.getId() + "  LSF id: " + locationOnChr.getFeature()));
            return null;
        }
        if (endPos > chromosomeSequenceString.length()) {
            LOG.warn((Object)(" has end coordinate greater than chromsome length.ignoring Location: " + locationOnChr.getId() + "  LSF id: " + locationOnChr.getFeature()));
            return null;
        }
        ClobAccess subSeqString = startPos < endPos ? chromosomeSequenceString.subSequence(startPos, endPos) : chromosomeSequenceString.subSequence(endPos, startPos);
        if ("-1".equals(locationOnChr.getStrand())) {
            subSeqString = new ClobAccessReverseComplement(subSeqString);
        }
        return subSeqString;
    }

    protected void transferToTranscripts() throws Exception {
        try {
            String message = "Not performing TransferSequences.transferToTranscripts ";
            PostProcessUtil.checkFieldExists((Model)this.model, (String)"Transcript", (String)"exons", (String)message);
            PostProcessUtil.checkFieldExists((Model)this.model, (String)"Exon", null, (String)message);
        }
        catch (MetaDataException e) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.osw.beginTransaction();
        ObjectStore os = this.osw.getObjectStore();
        Query q = new Query();
        q.setDistinct(false);
        QueryClass qcTranscript = new QueryClass(this.model.getClassDescriptorByName("Transcript").getType());
        q.addFrom((FromElement)qcTranscript);
        q.addToSelect((QuerySelectable)qcTranscript);
        q.addToOrderBy((QueryOrderable)qcTranscript);
        QueryClass qcExon = new QueryClass(this.model.getClassDescriptorByName("Exon").getType());
        q.addFrom((FromElement)qcExon);
        q.addToSelect((QuerySelectable)qcExon);
        QueryClass qcExonSequence = new QueryClass(Sequence.class);
        q.addFrom((FromElement)qcExonSequence);
        q.addToSelect((QuerySelectable)qcExonSequence);
        QueryClass qcExonLocation = new QueryClass(Location.class);
        q.addFrom((FromElement)qcExonLocation);
        q.addToSelect((QuerySelectable)qcExonLocation);
        QueryField qfExonStart = new QueryField(qcExonLocation, "start");
        q.addToSelect((QuerySelectable)qfExonStart);
        q.addToOrderBy((QueryOrderable)qfExonStart);
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        QueryCollectionReference exonsRef = new QueryCollectionReference(qcTranscript, "exons");
        ContainsConstraint cc1 = new ContainsConstraint((QueryReference)exonsRef, ConstraintOp.CONTAINS, qcExon);
        cs.addConstraint((Constraint)cc1);
        QueryObjectReference locRef = new QueryObjectReference(qcExon, "chromosomeLocation");
        ContainsConstraint cc2 = new ContainsConstraint((QueryReference)locRef, ConstraintOp.CONTAINS, qcExonLocation);
        cs.addConstraint((Constraint)cc2);
        QueryObjectReference sequenceRef = new QueryObjectReference(qcExon, "sequence");
        ContainsConstraint cc3 = new ContainsConstraint((QueryReference)sequenceRef, ConstraintOp.CONTAINS, qcExonSequence);
        cs.addConstraint((Constraint)cc3);
        QueryObjectReference transcriptSeqRef = new QueryObjectReference(qcTranscript, "sequence");
        ContainsConstraint lsfSeqRefNull = new ContainsConstraint((QueryReference)transcriptSeqRef, ConstraintOp.IS_NULL);
        cs.addConstraint((Constraint)lsfSeqRefNull);
        q.setConstraint((Constraint)cs);
        ((ObjectStoreInterMineImpl)os).precompute(q, "precompute");
        Results res = os.execute(q, 1000, true, true, true);
        Iterator resIter = res.iterator();
        SequenceFeature currentTranscript = null;
        StringBuffer currentTranscriptBases = new StringBuffer();
        long start = System.currentTimeMillis();
        int i = 0;
        while (resIter.hasNext()) {
            ResultsRow rr = (ResultsRow)resIter.next();
            SequenceFeature transcript = (SequenceFeature)rr.get(0);
            if (currentTranscript == null || !transcript.equals(currentTranscript)) {
                if (currentTranscript != null) {
                    this.storeNewSequence(currentTranscript, (ClobAccess)new PendingClob(currentTranscriptBases.toString()));
                    if (++i % 100 == 0) {
                        long now = System.currentTimeMillis();
                        LOG.info((Object)("Set sequences for " + i + " Transcripts (avg = " + 60000L * (long)i / (now - start) + " per minute)"));
                    }
                }
                currentTranscriptBases = new StringBuffer();
                currentTranscript = transcript;
            }
            Sequence exonSequence = (Sequence)rr.get(2);
            Location location = (Location)rr.get(3);
            if (location.getStrand() != null && "-1".equals(location.getStrand())) {
                currentTranscriptBases.insert(0, exonSequence.getResidues().toString());
                continue;
            }
            currentTranscriptBases.append(exonSequence.getResidues().toString());
        }
        if (currentTranscript == null) {
            LOG.error((Object)"in transferToTranscripts(): no Transcripts found");
        } else {
            this.storeNewSequence(currentTranscript, (ClobAccess)new PendingClob(currentTranscriptBases.toString()));
        }
        LOG.info((Object)("Finished setting " + i + " Trascript sequences - took " + (System.currentTimeMillis() - startTime) + " ms."));
        this.osw.commitTransaction();
    }

    private void transferToCDSs(Chromosome chr) throws Exception {
        long startTime = System.currentTimeMillis();
        this.osw.beginTransaction();
        ObjectStore os = this.osw.getObjectStore();
        Query q = this.getCDSQuery(chr);
        ((ObjectStoreInterMineImpl)os).precompute(q, "precompute");
        Results res = os.execute(q, 1000, true, true, true);
        Iterator resIter = res.iterator();
        SequenceFeature currentCDS = null;
        StringBuffer currentCDSBases = new StringBuffer();
        Sequence chromosomeSequence = chr.getSequence();
        long start = System.currentTimeMillis();
        int i = 0;
        while (resIter.hasNext()) {
            ResultsRow rr = (ResultsRow)resIter.next();
            SequenceFeature cds = (SequenceFeature)rr.get(0);
            if (currentCDS == null || !cds.equals(currentCDS)) {
                if (currentCDS != null) {
                    this.storeNewSequence(currentCDS, (ClobAccess)new PendingClob(currentCDSBases.toString()));
                    if (++i % 100 == 0) {
                        long now = System.currentTimeMillis();
                        LOG.info((Object)("Set sequences for " + i + " CDSs (avg = " + 60000L * (long)i / (now - start) + " per minute)"));
                    }
                }
                currentCDSBases = new StringBuffer();
                currentCDS = cds;
            }
            Location location = (Location)rr.get(1);
            ClobAccess clob = TransferSequencesProcess.getSubSequence(chromosomeSequence, location);
            if (location.getStrand() != null && "-1".equals(location.getStrand())) {
                currentCDSBases.insert(0, clob.toString());
                continue;
            }
            currentCDSBases.append(clob.toString());
        }
        if (currentCDS == null) {
            LOG.error((Object)"in transferToCDSs(): no CDSs found");
        } else {
            this.storeNewSequence(currentCDS, (ClobAccess)new PendingClob(currentCDSBases.toString()));
        }
        LOG.info((Object)("Finished setting " + i + " CDS sequences - took " + (System.currentTimeMillis() - startTime) + " ms."));
        this.osw.commitTransaction();
    }

    private Query getCDSQuery(Chromosome chr) {
        Query q = new Query();
        q.setDistinct(false);
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        QueryClass qcChr = new QueryClass(Chromosome.class);
        QueryField qfChrId = new QueryField(qcChr, "id");
        q.addFrom((FromElement)qcChr);
        SimpleConstraint sc = new SimpleConstraint((QueryEvaluable)qfChrId, ConstraintOp.EQUALS, (QueryEvaluable)new QueryValue((Object)chr.getId()));
        cs.addConstraint((Constraint)sc);
        QueryClass qcCDS = new QueryClass(this.model.getClassDescriptorByName("CDS").getType());
        q.addFrom((FromElement)qcCDS);
        q.addToSelect((QuerySelectable)qcCDS);
        q.addToOrderBy((QueryOrderable)qcCDS);
        QueryClass qcCDSLocation = new QueryClass(Location.class);
        q.addFrom((FromElement)qcCDSLocation);
        q.addToSelect((QuerySelectable)qcCDSLocation);
        QueryField qfCDSStart = new QueryField(qcCDSLocation, "start");
        q.addToSelect((QuerySelectable)qfCDSStart);
        q.addToOrderBy((QueryOrderable)qfCDSStart);
        QueryObjectReference ref1 = new QueryObjectReference(qcCDSLocation, "locatedOn");
        ContainsConstraint cc1 = new ContainsConstraint((QueryReference)ref1, ConstraintOp.CONTAINS, qcChr);
        cs.addConstraint((Constraint)cc1);
        QueryCollectionReference locationsRefs = new QueryCollectionReference(qcCDS, "locations");
        ContainsConstraint cc2 = new ContainsConstraint((QueryReference)locationsRefs, ConstraintOp.CONTAINS, qcCDSLocation);
        cs.addConstraint((Constraint)cc2);
        QueryObjectReference transcriptSeqRef = new QueryObjectReference(qcCDS, "sequence");
        ContainsConstraint lsfSeqRefNull = new ContainsConstraint((QueryReference)transcriptSeqRef, ConstraintOp.IS_NULL);
        cs.addConstraint((Constraint)lsfSeqRefNull);
        q.setConstraint((Constraint)cs);
        return q;
    }
}

