/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.model.bio;

import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.ShadowClass;
import org.intermine.model.StringConstructor;
import org.intermine.model.bio.Sequence;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.util.DynamicUtil;

public class SequenceShadow
implements Sequence,
ShadowClass {
    public static final Class<Sequence> shadowOf = Sequence.class;
    protected String md5checksum;
    protected ClobAccess residues;
    protected int length;
    protected Integer id;

    @Override
    public String getMd5checksum() {
        return this.md5checksum;
    }

    @Override
    public void setMd5checksum(String md5checksum) {
        this.md5checksum = md5checksum;
    }

    @Override
    public ClobAccess getResidues() {
        return this.residues;
    }

    @Override
    public void setResidues(ClobAccess residues) {
        this.residues = residues;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        return o instanceof Sequence && this.id != null ? this.id.equals(((Sequence)o).getId()) : this == o;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public String toString() {
        return "Sequence [id=" + this.id + ", length=" + this.length + ", md5checksum=" + (this.md5checksum == null ? "null" : "\"" + this.md5checksum + "\"") + ", residues=" + (this.residues == null ? "null" : "\"" + this.residues + "\"") + "]";
    }

    public Object getFieldValue(String fieldName) throws IllegalAccessException {
        if ("md5checksum".equals(fieldName)) {
            return this.md5checksum;
        }
        if ("residues".equals(fieldName)) {
            return this.residues;
        }
        if ("length".equals(fieldName)) {
            return this.length;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!Sequence.class.equals(this.getClass())) {
            return TypeUtil.getFieldValue((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public Object getFieldProxy(String fieldName) throws IllegalAccessException {
        if ("md5checksum".equals(fieldName)) {
            return this.md5checksum;
        }
        if ("residues".equals(fieldName)) {
            return this.residues;
        }
        if ("length".equals(fieldName)) {
            return this.length;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!Sequence.class.equals(this.getClass())) {
            return TypeUtil.getFieldProxy((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public void setFieldValue(String fieldName, Object value) {
        if ("md5checksum".equals(fieldName)) {
            this.md5checksum = (String)value;
        } else if ("residues".equals(fieldName)) {
            this.residues = (ClobAccess)value;
        } else if ("length".equals(fieldName)) {
            this.length = (Integer)value;
        } else if ("id".equals(fieldName)) {
            this.id = (Integer)value;
        } else {
            if (!Sequence.class.equals(this.getClass())) {
                DynamicUtil.setFieldValue((Object)this, (String)fieldName, (Object)value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }

    public Class<?> getFieldType(String fieldName) {
        if ("md5checksum".equals(fieldName)) {
            return String.class;
        }
        if ("residues".equals(fieldName)) {
            return ClobAccess.class;
        }
        if ("length".equals(fieldName)) {
            return Integer.TYPE;
        }
        if ("id".equals(fieldName)) {
            return Integer.class;
        }
        if (!Sequence.class.equals(this.getClass())) {
            return TypeUtil.getFieldType(Sequence.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public StringConstructor getoBJECT() {
        if (!SequenceShadow.class.equals(this.getClass())) {
            return NotXmlRenderer.render((Object)this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.Sequence");
        if (this.md5checksum != null) {
            sb.append("$_^amd5checksum$_^");
            String string = this.md5checksum;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.residues != null) {
            sb.append("$_^aresidues$_^" + this.residues.getDbDescription());
        }
        sb.append("$_^alength$_^").append(this.length);
        if (this.id != null) {
            sb.append("$_^aid$_^").append((Object)this.id);
        }
        return sb;
    }

    public void setoBJECT(String notXml, ObjectStore os) {
        this.setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }

    public void setoBJECT(String[] notXml, ObjectStore os) {
        if (!SequenceShadow.class.equals(this.getClass())) {
            throw new IllegalStateException("Class " + this.getClass().getName() + " does not match code (org.intermine.model.bio.Sequence)");
        }
        int i = 2;
        while (i < notXml.length) {
            int startI = i;
            if (i < notXml.length && "amd5checksum".equals(notXml[i])) {
                ++i;
                StringBuilder string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.md5checksum = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "aresidues".equals(notXml[i])) {
                this.residues = ClobAccess.decodeDbDescription((ObjectStore)os, (String)notXml[++i]);
                ++i;
            }
            if (i < notXml.length && "alength".equals(notXml[i])) {
                this.length = Integer.parseInt(notXml[++i]);
                ++i;
            }
            if (i < notXml.length && "aid".equals(notXml[i])) {
                this.id = Integer.valueOf(notXml[++i]);
                ++i;
            }
            if (startI != i) continue;
            throw new IllegalArgumentException("Unknown field " + notXml[i]);
        }
    }

    public void addCollectionElement(String fieldName, InterMineObject element) {
        if (!Sequence.class.equals(this.getClass())) {
            TypeUtil.addCollectionElement((Object)this, (String)fieldName, (Object)element);
            return;
        }
        throw new IllegalArgumentException("Unknown collection " + fieldName);
    }

    public Class<?> getElementType(String fieldName) {
        if (!Sequence.class.equals(this.getClass())) {
            return TypeUtil.getElementType(Sequence.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}

