/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.dataconversion;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.intermine.metadata.StringUtil;
import org.intermine.model.bio.Organism;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreFactory;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.util.SAXParser;
import org.intermine.xml.full.FullRenderer;
import org.intermine.xml.full.Item;
import org.intermine.xml.full.ItemFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class EntrezOrganismRetriever
extends Task {
    protected static final Logger LOG = Logger.getLogger(EntrezOrganismRetriever.class);
    protected static final String ESUMMARY_URL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=taxonomy&retmode=xml&id=";
    protected static final int BATCH_SIZE = 50;
    private String osAlias = null;
    private String outputFile = null;

    public void setOsAlias(String osAlias) {
        this.osAlias = osAlias;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void execute() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (this.osAlias == null) {
            throw new BuildException("osAlias attribute is not set");
        }
        if (this.outputFile == null) {
            throw new BuildException("outputFile attribute is not set");
        }
        LOG.info((Object)"Starting EntrezOrganismRetriever");
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.outputFile);
            ObjectStore os = ObjectStoreFactory.getObjectStore((String)this.osAlias);
            Map<String, Organism> orgMap = this.getOrganisms(os);
            HashSet<String> taxonIds = new HashSet<String>();
            HashSet<Item> toStore = new HashSet<Item>();
            ItemFactory itemFactory = new ItemFactory(os.getModel(), "-1_");
            writer.write(FullRenderer.getHeader() + "\n");
            Iterator<String> i = orgMap.keySet().iterator();
            while (i.hasNext()) {
                String taxonId = i.next();
                taxonIds.add(taxonId);
                if (taxonIds.size() != 50 && i.hasNext()) continue;
                SAXParser.parse((InputSource)new InputSource(this.getReader(taxonIds)), (DefaultHandler)new Handler(toStore, itemFactory), (boolean)false);
                for (Item item : toStore) {
                    writer.write(FullRenderer.render((Item)item));
                }
                taxonIds.clear();
                toStore.clear();
            }
            writer.write(FullRenderer.getFooter() + "\n");
        }
        catch (Exception e) {
            throw new BuildException("exception while retrieving organisms", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Map<String, Organism> getOrganisms(ObjectStore os) {
        Query q = new Query();
        QueryClass qc = new QueryClass(Organism.class);
        q.addFrom((FromElement)qc);
        q.addToSelect((QuerySelectable)qc);
        SingletonResults results = os.executeSingleton(q);
        HashMap<String, Organism> retMap = new HashMap<String, Organism>();
        for (Organism organism : results) {
            retMap.put(organism.getTaxonId(), organism);
        }
        return retMap;
    }

    protected Reader getReader(Set<String> ids) throws Exception {
        URL url = new URL(ESUMMARY_URL + StringUtil.join(ids, (String)","));
        return new BufferedReader(new InputStreamReader(url.openStream()));
    }

    protected static Reader getReader(Integer id) throws Exception {
        URL url = new URL(ESUMMARY_URL + id);
        return new BufferedReader(new InputStreamReader(url.openStream()));
    }

    class Handler
    extends DefaultHandler {
        Set<Item> toStore;
        Item organism;
        String name;
        StringBuffer characters;
        ItemFactory itemFactory;
        boolean isMerged = false;

        public Handler(Set<Item> toStore, ItemFactory itemFactory) {
            this.toStore = toStore;
            this.itemFactory = itemFactory;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            this.name = "ERROR".equals(qName) ? qName : ("Id".equals(qName) ? "Id" : attrs.getValue("Name"));
            this.characters = new StringBuffer();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.characters.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("ERROR".equals(this.name)) {
                LOG.error((Object)("Unable to retrieve taxonomy record: " + this.characters));
            } else if ("Id".equals(this.name)) {
                this.organism = this.itemFactory.makeItemForClass("Organism");
                this.toStore.add(this.organism);
                this.organism.setAttribute("taxonId", this.characters.toString());
            } else if ("Status".equals(this.name)) {
                if ("merged".equals(this.characters.toString())) {
                    this.isMerged = true;
                } else if ("active".equals(this.characters.toString())) {
                    this.isMerged = false;
                }
            } else if ("ScientificName".equals(this.name)) {
                String text = this.characters.toString();
                if (StringUtils.isNotEmpty((String)text)) {
                    this.organism.setAttribute("name", text);
                    int spaceIndex = text.indexOf(" ");
                    if (spaceIndex == -1) {
                        this.organism.setAttribute("genus", text);
                    } else {
                        this.organism.setAttribute("genus", text.substring(0, spaceIndex));
                        this.organism.setAttribute("species", text.substring(spaceIndex + 1));
                        String shortName = text.charAt(0) + ". " + text.substring(spaceIndex + 1);
                        if (text.startsWith("[")) {
                            shortName = text.charAt(1) + ". " + text.substring(spaceIndex + 1);
                        }
                        this.organism.setAttribute("shortName", shortName);
                    }
                }
            } else if ("CommonName".equals(this.name)) {
                String text = this.characters.toString();
                if (StringUtils.isNotEmpty((String)text)) {
                    this.organism.setAttribute("commonName", text);
                }
            } else if ("AkaTaxId".equals(this.name) && !"0".equals(this.characters.toString()) && this.isMerged) {
                try {
                    FileWriter w = new FileWriter("build/organisms_merged.info");
                    ((Writer)w).append("Your taxon id " + this.organism.getAttribute("taxonId").getValue() + " is replaced by " + this.characters.toString() + ", please update.\n");
                    ((Writer)w).flush();
                    ((Writer)w).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.name = null;
        }
    }
}

