/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.model.bio;

import java.util.HashSet;
import java.util.Set;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.ShadowClass;
import org.intermine.model.StringConstructor;
import org.intermine.model.bio.CrossReference;
import org.intermine.model.bio.DataSet;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.Homologue;
import org.intermine.model.bio.OrthologueEvidence;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.util.DynamicUtil;

public class HomologueShadow
implements Homologue,
ShadowClass {
    public static final Class<Homologue> shadowOf = Homologue.class;
    protected String type;
    protected InterMineObject gene;
    protected InterMineObject homologue;
    protected Set<DataSet> dataSets = new HashSet<DataSet>();
    protected Set<OrthologueEvidence> evidence = new HashSet<OrthologueEvidence>();
    protected Set<CrossReference> crossReferences = new HashSet<CrossReference>();
    protected Integer id;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Gene getGene() {
        if (this.gene instanceof ProxyReference) {
            return (Gene)((ProxyReference)this.gene).getObject();
        }
        return (Gene)this.gene;
    }

    @Override
    public void setGene(Gene gene) {
        this.gene = gene;
    }

    @Override
    public void proxyGene(ProxyReference gene) {
        this.gene = gene;
    }

    @Override
    public InterMineObject proxGetGene() {
        return this.gene;
    }

    @Override
    public Gene getHomologue() {
        if (this.homologue instanceof ProxyReference) {
            return (Gene)((ProxyReference)this.homologue).getObject();
        }
        return (Gene)this.homologue;
    }

    @Override
    public void setHomologue(Gene homologue) {
        this.homologue = homologue;
    }

    @Override
    public void proxyHomologue(ProxyReference homologue) {
        this.homologue = homologue;
    }

    @Override
    public InterMineObject proxGetHomologue() {
        return this.homologue;
    }

    @Override
    public Set<DataSet> getDataSets() {
        return this.dataSets;
    }

    @Override
    public void setDataSets(Set<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    @Override
    public void addDataSets(DataSet arg) {
        this.dataSets.add(arg);
    }

    @Override
    public Set<OrthologueEvidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void setEvidence(Set<OrthologueEvidence> evidence) {
        this.evidence = evidence;
    }

    @Override
    public void addEvidence(OrthologueEvidence arg) {
        this.evidence.add(arg);
    }

    @Override
    public Set<CrossReference> getCrossReferences() {
        return this.crossReferences;
    }

    @Override
    public void setCrossReferences(Set<CrossReference> crossReferences) {
        this.crossReferences = crossReferences;
    }

    @Override
    public void addCrossReferences(CrossReference arg) {
        this.crossReferences.add(arg);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        return o instanceof Homologue && this.id != null ? this.id.equals(((Homologue)o).getId()) : this == o;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public String toString() {
        return "Homologue [gene=" + (this.gene == null ? "null" : (this.gene.getId() == null ? "no id" : this.gene.getId().toString())) + ", homologue=" + (this.homologue == null ? "null" : (this.homologue.getId() == null ? "no id" : this.homologue.getId().toString())) + ", id=" + this.id + ", type=" + (this.type == null ? "null" : "\"" + this.type + "\"") + "]";
    }

    public Object getFieldValue(String fieldName) throws IllegalAccessException {
        if ("type".equals(fieldName)) {
            return this.type;
        }
        if ("gene".equals(fieldName)) {
            if (this.gene instanceof ProxyReference) {
                return ((ProxyReference)this.gene).getObject();
            }
            return this.gene;
        }
        if ("homologue".equals(fieldName)) {
            if (this.homologue instanceof ProxyReference) {
                return ((ProxyReference)this.homologue).getObject();
            }
            return this.homologue;
        }
        if ("dataSets".equals(fieldName)) {
            return this.dataSets;
        }
        if ("evidence".equals(fieldName)) {
            return this.evidence;
        }
        if ("crossReferences".equals(fieldName)) {
            return this.crossReferences;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!Homologue.class.equals(this.getClass())) {
            return TypeUtil.getFieldValue((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public Object getFieldProxy(String fieldName) throws IllegalAccessException {
        if ("type".equals(fieldName)) {
            return this.type;
        }
        if ("gene".equals(fieldName)) {
            return this.gene;
        }
        if ("homologue".equals(fieldName)) {
            return this.homologue;
        }
        if ("dataSets".equals(fieldName)) {
            return this.dataSets;
        }
        if ("evidence".equals(fieldName)) {
            return this.evidence;
        }
        if ("crossReferences".equals(fieldName)) {
            return this.crossReferences;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!Homologue.class.equals(this.getClass())) {
            return TypeUtil.getFieldProxy((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public void setFieldValue(String fieldName, Object value) {
        if ("type".equals(fieldName)) {
            this.type = (String)value;
        } else if ("gene".equals(fieldName)) {
            this.gene = (InterMineObject)value;
        } else if ("homologue".equals(fieldName)) {
            this.homologue = (InterMineObject)value;
        } else if ("dataSets".equals(fieldName)) {
            this.dataSets = (Set)value;
        } else if ("evidence".equals(fieldName)) {
            this.evidence = (Set)value;
        } else if ("crossReferences".equals(fieldName)) {
            this.crossReferences = (Set)value;
        } else if ("id".equals(fieldName)) {
            this.id = (Integer)value;
        } else {
            if (!Homologue.class.equals(this.getClass())) {
                DynamicUtil.setFieldValue((Object)this, (String)fieldName, (Object)value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }

    public Class<?> getFieldType(String fieldName) {
        if ("type".equals(fieldName)) {
            return String.class;
        }
        if ("gene".equals(fieldName)) {
            return Gene.class;
        }
        if ("homologue".equals(fieldName)) {
            return Gene.class;
        }
        if ("dataSets".equals(fieldName)) {
            return Set.class;
        }
        if ("evidence".equals(fieldName)) {
            return Set.class;
        }
        if ("crossReferences".equals(fieldName)) {
            return Set.class;
        }
        if ("id".equals(fieldName)) {
            return Integer.class;
        }
        if (!Homologue.class.equals(this.getClass())) {
            return TypeUtil.getFieldType(Homologue.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public StringConstructor getoBJECT() {
        if (!HomologueShadow.class.equals(this.getClass())) {
            return NotXmlRenderer.render((Object)this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.Homologue");
        if (this.type != null) {
            sb.append("$_^atype$_^");
            String string = this.type;
            while (string != null) {
                int delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.gene != null) {
            sb.append("$_^rgene$_^").append((Object)this.gene.getId());
        }
        if (this.homologue != null) {
            sb.append("$_^rhomologue$_^").append((Object)this.homologue.getId());
        }
        if (this.id != null) {
            sb.append("$_^aid$_^").append((Object)this.id);
        }
        return sb;
    }

    public void setoBJECT(String notXml, ObjectStore os) {
        this.setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }

    public void setoBJECT(String[] notXml, ObjectStore os) {
        if (!HomologueShadow.class.equals(this.getClass())) {
            throw new IllegalStateException("Class " + this.getClass().getName() + " does not match code (org.intermine.model.bio.Homologue)");
        }
        int i = 2;
        while (i < notXml.length) {
            int startI = i;
            if (i < notXml.length && "atype".equals(notXml[i])) {
                ++i;
                StringBuilder string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.type = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "rgene".equals(notXml[i])) {
                this.gene = new ProxyReference(os, Integer.valueOf(notXml[++i]), Gene.class);
                ++i;
            }
            if (i < notXml.length && "rhomologue".equals(notXml[i])) {
                this.homologue = new ProxyReference(os, Integer.valueOf(notXml[++i]), Gene.class);
                ++i;
            }
            if (i < notXml.length && "aid".equals(notXml[i])) {
                this.id = Integer.valueOf(notXml[++i]);
                ++i;
            }
            if (startI != i) continue;
            throw new IllegalArgumentException("Unknown field " + notXml[i]);
        }
        this.dataSets = new ProxyCollection(os, (InterMineObject)this, "dataSets", DataSet.class);
        this.evidence = new ProxyCollection(os, (InterMineObject)this, "evidence", OrthologueEvidence.class);
        this.crossReferences = new ProxyCollection(os, (InterMineObject)this, "crossReferences", CrossReference.class);
    }

    public void addCollectionElement(String fieldName, InterMineObject element) {
        if ("dataSets".equals(fieldName)) {
            this.dataSets.add((DataSet)element);
        } else if ("evidence".equals(fieldName)) {
            this.evidence.add((OrthologueEvidence)element);
        } else if ("crossReferences".equals(fieldName)) {
            this.crossReferences.add((CrossReference)element);
        } else {
            if (!Homologue.class.equals(this.getClass())) {
                TypeUtil.addCollectionElement((Object)this, (String)fieldName, (Object)element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }

    public Class<?> getElementType(String fieldName) {
        if ("dataSets".equals(fieldName)) {
            return DataSet.class;
        }
        if ("evidence".equals(fieldName)) {
            return OrthologueEvidence.class;
        }
        if ("crossReferences".equals(fieldName)) {
            return CrossReference.class;
        }
        if (!Homologue.class.equals(this.getClass())) {
            return TypeUtil.getElementType(Homologue.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}

