/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.dataconversion;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.intermine.bio.dataconversion.BioFileConverter;
import org.intermine.bio.dataconversion.IdResolver;
import org.intermine.bio.dataconversion.IdResolverService;
import org.intermine.dataconversion.ItemWriter;
import org.intermine.metadata.Model;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.util.FormattedTextParser;
import org.intermine.xml.full.Item;

public class HomologeneConverter
extends BioFileConverter {
    private static final Logger LOG = Logger.getLogger(HomologeneConverter.class);
    private IdResolver rslv;
    private static final String DATASET_TITLE = "HomoloGene homology predictions";
    private static final String DATA_SOURCE_NAME = "HomoloGene";
    private static final String PROP_FILE = "homologene_config.properties";
    private static final String DEFAULT_IDENTIFIER_TYPE = "primaryIdentifier";
    private Set<String> taxonIds = new HashSet<String>();
    private Set<String> homologues = new HashSet<String>();
    private static final String ORTHOLOGUE = "orthologue";
    private static final String PARALOGUE = "paralogue";
    private static final String EVIDENCE_CODE_ABBR = "AA";
    private static final String EVIDENCE_CODE_NAME = "Amino acid sequence comparison";
    private Properties props = new Properties();
    private Map<String, String> config = new HashMap<String, String>();
    private static String evidenceRefId = null;
    private Map<MultiKey, String> identifiersToGenes = new HashMap<MultiKey, String>();

    public HomologeneConverter(ItemWriter writer, Model model) {
        super(writer, model, DATA_SOURCE_NAME, DATASET_TITLE);
        this.readConfig();
    }

    public void setHomologeneOrganisms(String taxonIds) {
        this.taxonIds = new HashSet<String>(Arrays.asList(StringUtil.split((String)taxonIds, (String)" ")));
        LOG.info((Object)("Setting list of organisms to " + taxonIds));
    }

    public void setHomologeneHomologues(String homologues) {
        this.homologues = new HashSet<String>(Arrays.asList(StringUtil.split((String)homologues, (String)" ")));
        LOG.info((Object)("Setting list of homologues to " + homologues));
    }

    public void process(Reader reader) throws Exception {
        this.setUpResolver();
        String previousGroup = null;
        HashSet<GeneRecord> genes = new HashSet<GeneRecord>();
        if (this.taxonIds.isEmpty()) {
            throw new BuildException("homologene.organisms property not set in project XML file");
        }
        Iterator lineIter = FormattedTextParser.parseTabDelimitedReader((Reader)reader);
        while (lineIter.hasNext()) {
            String symbol;
            String ncbiId;
            String gene;
            String[] bits = (String[])lineIter.next();
            if (bits.length < 6) continue;
            String groupId = bits[0];
            if (previousGroup != null && !groupId.equals(previousGroup)) {
                this.processHomologues(genes);
                genes = new HashSet();
            }
            previousGroup = groupId;
            String taxonId = bits[1];
            if (!this.isValid(taxonId) || (gene = this.getGene(ncbiId = bits[2], symbol = bits[3], taxonId)) == null) continue;
            genes.add(new GeneRecord(gene, taxonId));
        }
    }

    private void setUpResolver() {
        HashSet<String> allTaxonIds = new HashSet<String>();
        allTaxonIds.addAll(this.taxonIds);
        allTaxonIds.addAll(this.homologues);
        if (this.rslv == null) {
            this.rslv = IdResolverService.getIdResolverByOrganism(allTaxonIds);
        }
    }

    private void readConfig() {
        try {
            this.props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROP_FILE));
        }
        catch (IOException e) {
            throw new RuntimeException("Problem loading properties 'homologene_config.properties'", e);
        }
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((String)entry.getValue()).trim();
            String[] attributes = key.split("\\.");
            if (attributes.length == 0) {
                throw new RuntimeException("Problem loading properties 'homologene_config.properties' on line " + key);
            }
            String taxonId = attributes[0];
            this.config.put(taxonId, value);
        }
    }

    private void processHomologues(Set<GeneRecord> genes) throws ObjectStoreException {
        HashSet<GeneRecord> notProcessed = new HashSet<GeneRecord>(genes);
        for (GeneRecord gene : genes) {
            notProcessed.remove(gene);
            for (GeneRecord homologue : notProcessed) {
                this.createHomologue(gene.geneRefId, gene.taxonId, homologue.geneRefId, homologue.taxonId);
                this.createHomologue(homologue.geneRefId, homologue.taxonId, gene.geneRefId, gene.taxonId);
            }
        }
    }

    private void createHomologue(String gene1, String taxonId1, String gene2, String taxonId2) throws ObjectStoreException {
        Item homologue = this.createItem("Homologue");
        homologue.setReference("gene", gene1);
        homologue.setReference("homologue", gene2);
        homologue.addToCollection("evidence", this.getEvidence());
        homologue.setAttribute("type", taxonId1.equals(taxonId2) ? PARALOGUE : ORTHOLOGUE);
        this.store(homologue);
    }

    private boolean isValid(String taxonId) {
        if (this.taxonIds.isEmpty()) {
            return true;
        }
        if (this.taxonIds.contains(taxonId)) {
            return true;
        }
        if (this.homologues.isEmpty()) {
            return false;
        }
        return this.homologues.contains(taxonId);
    }

    private String getGene(String ncbiId, String symbol, String taxonId) throws ObjectStoreException {
        String resolvedIdentifier;
        String identifierType = this.config.get(taxonId);
        if (identifierType == null) {
            identifierType = DEFAULT_IDENTIFIER_TYPE;
        }
        if ((resolvedIdentifier = this.resolveGene(taxonId, ncbiId, symbol)) == null) {
            return null;
        }
        String refId = this.identifiersToGenes.get(new MultiKey((Object)taxonId, (Object)resolvedIdentifier));
        if (refId == null) {
            Item item = this.createItem("Gene");
            if (!StringUtils.isEmpty((String)identifierType)) {
                item.setAttribute(identifierType, resolvedIdentifier);
            }
            item.setReference("organism", this.getOrganism(taxonId));
            refId = item.getIdentifier();
            this.identifiersToGenes.put(new MultiKey((Object)taxonId, (Object)resolvedIdentifier), refId);
            this.store(item);
        }
        return refId;
    }

    private String getEvidence() throws ObjectStoreException {
        if (evidenceRefId == null) {
            Item item = this.createItem("OrthologueEvidenceCode");
            item.setAttribute("abbreviation", EVIDENCE_CODE_ABBR);
            item.setAttribute("name", EVIDENCE_CODE_NAME);
            try {
                this.store(item);
            }
            catch (ObjectStoreException e) {
                throw new ObjectStoreException((Throwable)e);
            }
            String refId = item.getIdentifier();
            item = this.createItem("OrthologueEvidence");
            item.setReference("evidenceCode", refId);
            try {
                this.store(item);
            }
            catch (ObjectStoreException e) {
                throw new ObjectStoreException((Throwable)e);
            }
            evidenceRefId = item.getIdentifier();
        }
        return evidenceRefId;
    }

    private String resolveGene(String taxonId, String ncbi, String identifier) {
        if ("9606".equals(taxonId)) {
            return ncbi;
        }
        if (this.rslv == null || !this.rslv.hasTaxon(taxonId)) {
            return identifier;
        }
        int resCount = this.rslv.countResolutions(taxonId, identifier);
        if (resCount != 1) {
            LOG.info((Object)("RESOLVER: failed to resolve gene to one identifier, ignoring gene: " + identifier + " count: " + resCount + " Resolved: " + this.rslv.resolveId(taxonId, identifier)));
            return null;
        }
        return (String)this.rslv.resolveId(taxonId, identifier).iterator().next();
    }

    protected class GeneRecord {
        protected String geneRefId;
        protected String taxonId;

        public GeneRecord(String geneRefId, String taxonId) {
            this.geneRefId = geneRefId;
            this.taxonId = taxonId;
        }
    }
}

