/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.dataconversion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.bio.dataconversion.BioFileConverter;
import org.intermine.bio.dataconversion.IdResolver;
import org.intermine.bio.dataconversion.IdResolverService;
import org.intermine.dataconversion.ItemWriter;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.xml.full.Item;

public class KeggOrthologuesConverter
extends BioFileConverter {
    protected static final Logger LOG = Logger.getLogger(KeggOrthologuesConverter.class);
    private static final String PROP_FILE = "kegg_config.properties";
    private static final String EVIDENCE_CODE_ABBR = "AA";
    private static final String EVIDENCE_CODE_NAME = "Amino acid sequence comparison";
    private static final String DATASET_TITLE = "KEGG orthologues data set";
    private static final String DATA_SOURCE_NAME = "GenomeNet";
    private static String evidenceRefId = null;
    private static final String REGULAR_EXPRESSION = "\\w\\w\\w[:]\\s.+";
    private static final Pattern HOMOLOGUE_PATTERN = Pattern.compile("\\w\\w\\w[:]\\s.+");
    private Map<String, String[]> config = new HashMap<String, String[]>();
    private Set<String> taxonIds = new HashSet<String>();
    private Map<String, String> identifiersToGenes = new HashMap<String, String>();
    protected IdResolver rslv;

    public KeggOrthologuesConverter(ItemWriter writer, Model model) {
        super(writer, model, DATA_SOURCE_NAME, DATASET_TITLE);
        this.readConfig();
    }

    public void setKeggOrganisms(String taxonIds) {
        this.taxonIds = new HashSet<String>(Arrays.asList(StringUtils.split((String)taxonIds, (String)" ")));
        LOG.info((Object)("Setting list of organisms to " + this.taxonIds));
    }

    private void readConfig() {
        Properties props = new Properties();
        try {
            props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROP_FILE));
        }
        catch (IOException e) {
            throw new RuntimeException("Problem loading properties 'kegg_config.properties'", e);
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String[] bits;
            String key = (String)entry.getKey();
            String value = ((String)entry.getValue()).trim();
            String[] attributes = key.split("\\.");
            if (attributes.length == 0) {
                throw new RuntimeException("Problem loading properties 'kegg_config.properties' on line " + key);
            }
            String organism = attributes[0];
            if (this.config.get(organism) == null) {
                String[] configs = new String[2];
                configs[1] = "primaryIdentifier";
                this.config.put(organism, configs);
            }
            if ("taxonId".equals(attributes[1])) {
                bits = this.config.get(organism);
                bits[0] = value;
                continue;
            }
            if ("identifier".equals(attributes[1])) {
                bits = this.config.get(organism);
                bits[1] = value;
                continue;
            }
            String msg = "Problem processing properties 'kegg_config.properties' on line " + key + ".  This line has not been processed.";
            LOG.error((Object)msg);
        }
    }

    public void process(Reader reader) throws Exception {
        if (this.rslv == null) {
            this.rslv = IdResolverService.getFlyIdResolver();
            this.rslv = IdResolverService.getWormIdResolver();
        }
        HashSet<String> homologues = new HashSet<String>();
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        while ((line = br.readLine()) != null) {
            String choppedLine;
            Matcher matcher;
            if (line.length() > 12 && (matcher = HOMOLOGUE_PATTERN.matcher(choppedLine = line.substring(12))).matches()) {
                this.processLine(choppedLine, homologues);
            }
            if (!line.startsWith("///")) continue;
            for (String identifier : homologues) {
                this.processHomologues(identifier, homologues);
            }
            homologues = new HashSet();
        }
    }

    private void processLine(String line, Set<String> homologues) throws ObjectStoreException {
        String[] bits = line.split(" ");
        if (bits.length < 2) {
            return;
        }
        String organism = bits[0].substring(0, 3);
        String[] organismConfig = this.config.get(organism);
        if (organismConfig == null) {
            return;
        }
        String taxonId = organismConfig[0];
        String identifierType = organismConfig[1];
        if (!this.taxonIds.isEmpty() && !this.taxonIds.contains(taxonId)) {
            return;
        }
        if (identifierType == null) {
            identifierType = "primaryIdentifier";
        }
        for (int i = 1; i < bits.length; ++i) {
            String geneRefId = this.getGene(identifierType, this.formatIdentifier(bits[i]), taxonId);
            if (geneRefId == null) continue;
            homologues.add(geneRefId);
        }
    }

    private void processHomologues(String identifier, Set<String> homologues) throws ObjectStoreException {
        for (String homologue : homologues) {
            if (homologue.equals(identifier)) continue;
            this.processHomologue(identifier, homologue);
        }
    }

    private String formatIdentifier(String s) {
        String identifier = s;
        if (identifier.startsWith("Dmel_")) {
            identifier = identifier.substring(5);
        }
        if (identifier.contains("(")) {
            identifier = identifier.substring(0, identifier.indexOf(40));
        }
        return identifier;
    }

    private void processHomologue(String gene1, String gene2) throws ObjectStoreException {
        Item homologue = this.createItem("Homologue");
        homologue.setReference("gene", gene1);
        homologue.setReference("homologue", gene2);
        homologue.addToCollection("evidence", this.getEvidence());
        homologue.setAttribute("type", "homologue");
        try {
            this.store(homologue);
        }
        catch (ObjectStoreException e) {
            throw new ObjectStoreException((Throwable)e);
        }
    }

    private String getGene(String identifierType, String id, String taxonId) throws ObjectStoreException {
        String identifier = id;
        if (this.rslv != null && this.rslv.hasTaxon(taxonId) && (identifier = this.resolveGene(identifier, taxonId)) == null) {
            return null;
        }
        String refId = this.identifiersToGenes.get(identifier);
        if (refId == null) {
            Item gene = this.createItem("Gene");
            refId = gene.getIdentifier();
            gene.setAttribute(identifierType, identifier);
            gene.setReference("organism", this.getOrganism(taxonId));
            this.identifiersToGenes.put(identifier, refId);
            try {
                this.store(gene);
            }
            catch (ObjectStoreException e) {
                throw new ObjectStoreException((Throwable)e);
            }
        }
        return refId;
    }

    private String getEvidence() throws ObjectStoreException {
        if (evidenceRefId == null) {
            Item item = this.createItem("OrthologueEvidenceCode");
            item.setAttribute("abbreviation", EVIDENCE_CODE_ABBR);
            item.setAttribute("name", EVIDENCE_CODE_NAME);
            try {
                this.store(item);
            }
            catch (ObjectStoreException e) {
                throw new ObjectStoreException((Throwable)e);
            }
            String refId = item.getIdentifier();
            item = this.createItem("OrthologueEvidence");
            item.setReference("evidenceCode", refId);
            try {
                this.store(item);
            }
            catch (ObjectStoreException e) {
                throw new ObjectStoreException((Throwable)e);
            }
            evidenceRefId = item.getIdentifier();
        }
        return evidenceRefId;
    }

    private String resolveGene(String originalId, String taxonId) {
        String primaryIdentifier = null;
        int resCount = this.rslv.countResolutions(taxonId, originalId);
        if (resCount != 1) {
            LOG.info((Object)("RESOLVER: failed to resolve gene to one identifier, ignoring gene: " + originalId + " for organism " + taxonId + " count: " + resCount + " found ids: " + this.rslv.resolveId(taxonId, originalId) + "."));
        } else {
            primaryIdentifier = (String)this.rslv.resolveId(taxonId, originalId).iterator().next();
            LOG.info((Object)("RESOLVER found gene " + primaryIdentifier + " for original id: " + originalId));
        }
        return primaryIdentifier;
    }
}

