/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.model.bio;

import java.util.HashSet;
import java.util.Set;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.ShadowClass;
import org.intermine.model.StringConstructor;
import org.intermine.model.bio.CDS;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.CrossReference;
import org.intermine.model.bio.DataSet;
import org.intermine.model.bio.Exon;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.GeneFlankingRegion;
import org.intermine.model.bio.Homologue;
import org.intermine.model.bio.IntergenicRegion;
import org.intermine.model.bio.Intron;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.OntologyAnnotation;
import org.intermine.model.bio.Organism;
import org.intermine.model.bio.Protein;
import org.intermine.model.bio.Publication;
import org.intermine.model.bio.SOTerm;
import org.intermine.model.bio.Sequence;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.model.bio.Strain;
import org.intermine.model.bio.Synonym;
import org.intermine.model.bio.UTR;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.util.DynamicUtil;

public class GeneShadow
implements Gene,
ShadowClass {
    public static final Class<Gene> shadowOf = Gene.class;
    protected String briefDescription;
    protected String description;
    protected InterMineObject upstreamIntergenicRegion;
    protected InterMineObject downstreamIntergenicRegion;
    protected Set<GeneFlankingRegion> flankingRegions = new HashSet<GeneFlankingRegion>();
    protected Set<Intron> introns = new HashSet<Intron>();
    protected Set<Protein> proteins = new HashSet<Protein>();
    protected Set<CDS> CDSs = new HashSet<CDS>();
    protected Set<Homologue> homologues = new HashSet<Homologue>();
    protected Set<Exon> exons = new HashSet<Exon>();
    protected Set<UTR> UTRs = new HashSet<UTR>();
    protected Double score;
    protected String scoreType;
    protected Integer length;
    protected InterMineObject strain;
    protected InterMineObject sequenceOntologyTerm;
    protected InterMineObject chromosomeLocation;
    protected InterMineObject sequence;
    protected InterMineObject chromosome;
    protected Set<SequenceFeature> overlappingFeatures = new HashSet<SequenceFeature>();
    protected Set<SequenceFeature> childFeatures = new HashSet<SequenceFeature>();
    protected String symbol;
    protected String name;
    protected String secondaryIdentifier;
    protected InterMineObject organism;
    protected Set<Location> locatedFeatures = new HashSet<Location>();
    protected Set<Location> locations = new HashSet<Location>();
    protected Set<Synonym> synonyms = new HashSet<Synonym>();
    protected Set<DataSet> dataSets = new HashSet<DataSet>();
    protected Set<CrossReference> crossReferences = new HashSet<CrossReference>();
    protected String primaryIdentifier;
    protected Set<OntologyAnnotation> ontologyAnnotations = new HashSet<OntologyAnnotation>();
    protected Set<Publication> publications = new HashSet<Publication>();
    protected Integer id;

    @Override
    public String getBriefDescription() {
        return this.briefDescription;
    }

    @Override
    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public IntergenicRegion getUpstreamIntergenicRegion() {
        if (this.upstreamIntergenicRegion instanceof ProxyReference) {
            return (IntergenicRegion)((ProxyReference)this.upstreamIntergenicRegion).getObject();
        }
        return (IntergenicRegion)this.upstreamIntergenicRegion;
    }

    @Override
    public void setUpstreamIntergenicRegion(IntergenicRegion upstreamIntergenicRegion) {
        this.upstreamIntergenicRegion = upstreamIntergenicRegion;
    }

    @Override
    public void proxyUpstreamIntergenicRegion(ProxyReference upstreamIntergenicRegion) {
        this.upstreamIntergenicRegion = upstreamIntergenicRegion;
    }

    @Override
    public InterMineObject proxGetUpstreamIntergenicRegion() {
        return this.upstreamIntergenicRegion;
    }

    @Override
    public IntergenicRegion getDownstreamIntergenicRegion() {
        if (this.downstreamIntergenicRegion instanceof ProxyReference) {
            return (IntergenicRegion)((ProxyReference)this.downstreamIntergenicRegion).getObject();
        }
        return (IntergenicRegion)this.downstreamIntergenicRegion;
    }

    @Override
    public void setDownstreamIntergenicRegion(IntergenicRegion downstreamIntergenicRegion) {
        this.downstreamIntergenicRegion = downstreamIntergenicRegion;
    }

    @Override
    public void proxyDownstreamIntergenicRegion(ProxyReference downstreamIntergenicRegion) {
        this.downstreamIntergenicRegion = downstreamIntergenicRegion;
    }

    @Override
    public InterMineObject proxGetDownstreamIntergenicRegion() {
        return this.downstreamIntergenicRegion;
    }

    @Override
    public Set<GeneFlankingRegion> getFlankingRegions() {
        return this.flankingRegions;
    }

    @Override
    public void setFlankingRegions(Set<GeneFlankingRegion> flankingRegions) {
        this.flankingRegions = flankingRegions;
    }

    @Override
    public void addFlankingRegions(GeneFlankingRegion arg) {
        this.flankingRegions.add(arg);
    }

    @Override
    public Set<Intron> getIntrons() {
        return this.introns;
    }

    @Override
    public void setIntrons(Set<Intron> introns) {
        this.introns = introns;
    }

    @Override
    public void addIntrons(Intron arg) {
        this.introns.add(arg);
    }

    @Override
    public Set<Protein> getProteins() {
        return this.proteins;
    }

    @Override
    public void setProteins(Set<Protein> proteins) {
        this.proteins = proteins;
    }

    @Override
    public void addProteins(Protein arg) {
        this.proteins.add(arg);
    }

    @Override
    public Set<CDS> getcDSs() {
        return this.CDSs;
    }

    @Override
    public void setcDSs(Set<CDS> CDSs) {
        this.CDSs = CDSs;
    }

    @Override
    public void addcDSs(CDS arg) {
        this.CDSs.add(arg);
    }

    @Override
    public Set<Homologue> getHomologues() {
        return this.homologues;
    }

    @Override
    public void setHomologues(Set<Homologue> homologues) {
        this.homologues = homologues;
    }

    @Override
    public void addHomologues(Homologue arg) {
        this.homologues.add(arg);
    }

    @Override
    public Set<Exon> getExons() {
        return this.exons;
    }

    @Override
    public void setExons(Set<Exon> exons) {
        this.exons = exons;
    }

    @Override
    public void addExons(Exon arg) {
        this.exons.add(arg);
    }

    @Override
    public Set<UTR> getuTRs() {
        return this.UTRs;
    }

    @Override
    public void setuTRs(Set<UTR> UTRs) {
        this.UTRs = UTRs;
    }

    @Override
    public void adduTRs(UTR arg) {
        this.UTRs.add(arg);
    }

    @Override
    public Double getScore() {
        return this.score;
    }

    @Override
    public void setScore(Double score) {
        this.score = score;
    }

    @Override
    public String getScoreType() {
        return this.scoreType;
    }

    @Override
    public void setScoreType(String scoreType) {
        this.scoreType = scoreType;
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        this.length = length;
    }

    @Override
    public Strain getStrain() {
        if (this.strain instanceof ProxyReference) {
            return (Strain)((ProxyReference)this.strain).getObject();
        }
        return (Strain)this.strain;
    }

    @Override
    public void setStrain(Strain strain) {
        this.strain = strain;
    }

    @Override
    public void proxyStrain(ProxyReference strain) {
        this.strain = strain;
    }

    @Override
    public InterMineObject proxGetStrain() {
        return this.strain;
    }

    @Override
    public SOTerm getSequenceOntologyTerm() {
        if (this.sequenceOntologyTerm instanceof ProxyReference) {
            return (SOTerm)((ProxyReference)this.sequenceOntologyTerm).getObject();
        }
        return (SOTerm)this.sequenceOntologyTerm;
    }

    @Override
    public void setSequenceOntologyTerm(SOTerm sequenceOntologyTerm) {
        this.sequenceOntologyTerm = sequenceOntologyTerm;
    }

    @Override
    public void proxySequenceOntologyTerm(ProxyReference sequenceOntologyTerm) {
        this.sequenceOntologyTerm = sequenceOntologyTerm;
    }

    @Override
    public InterMineObject proxGetSequenceOntologyTerm() {
        return this.sequenceOntologyTerm;
    }

    @Override
    public Location getChromosomeLocation() {
        if (this.chromosomeLocation instanceof ProxyReference) {
            return (Location)((ProxyReference)this.chromosomeLocation).getObject();
        }
        return (Location)this.chromosomeLocation;
    }

    @Override
    public void setChromosomeLocation(Location chromosomeLocation) {
        this.chromosomeLocation = chromosomeLocation;
    }

    @Override
    public void proxyChromosomeLocation(ProxyReference chromosomeLocation) {
        this.chromosomeLocation = chromosomeLocation;
    }

    @Override
    public InterMineObject proxGetChromosomeLocation() {
        return this.chromosomeLocation;
    }

    @Override
    public Sequence getSequence() {
        if (this.sequence instanceof ProxyReference) {
            return (Sequence)((ProxyReference)this.sequence).getObject();
        }
        return (Sequence)this.sequence;
    }

    @Override
    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public void proxySequence(ProxyReference sequence) {
        this.sequence = sequence;
    }

    @Override
    public InterMineObject proxGetSequence() {
        return this.sequence;
    }

    @Override
    public Chromosome getChromosome() {
        if (this.chromosome instanceof ProxyReference) {
            return (Chromosome)((ProxyReference)this.chromosome).getObject();
        }
        return (Chromosome)this.chromosome;
    }

    @Override
    public void setChromosome(Chromosome chromosome) {
        this.chromosome = chromosome;
    }

    @Override
    public void proxyChromosome(ProxyReference chromosome) {
        this.chromosome = chromosome;
    }

    @Override
    public InterMineObject proxGetChromosome() {
        return this.chromosome;
    }

    @Override
    public Set<SequenceFeature> getOverlappingFeatures() {
        return this.overlappingFeatures;
    }

    @Override
    public void setOverlappingFeatures(Set<SequenceFeature> overlappingFeatures) {
        this.overlappingFeatures = overlappingFeatures;
    }

    @Override
    public void addOverlappingFeatures(SequenceFeature arg) {
        this.overlappingFeatures.add(arg);
    }

    @Override
    public Set<SequenceFeature> getChildFeatures() {
        return this.childFeatures;
    }

    @Override
    public void setChildFeatures(Set<SequenceFeature> childFeatures) {
        this.childFeatures = childFeatures;
    }

    @Override
    public void addChildFeatures(SequenceFeature arg) {
        this.childFeatures.add(arg);
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSecondaryIdentifier() {
        return this.secondaryIdentifier;
    }

    @Override
    public void setSecondaryIdentifier(String secondaryIdentifier) {
        this.secondaryIdentifier = secondaryIdentifier;
    }

    @Override
    public Organism getOrganism() {
        if (this.organism instanceof ProxyReference) {
            return (Organism)((ProxyReference)this.organism).getObject();
        }
        return (Organism)this.organism;
    }

    @Override
    public void setOrganism(Organism organism) {
        this.organism = organism;
    }

    @Override
    public void proxyOrganism(ProxyReference organism) {
        this.organism = organism;
    }

    @Override
    public InterMineObject proxGetOrganism() {
        return this.organism;
    }

    @Override
    public Set<Location> getLocatedFeatures() {
        return this.locatedFeatures;
    }

    @Override
    public void setLocatedFeatures(Set<Location> locatedFeatures) {
        this.locatedFeatures = locatedFeatures;
    }

    @Override
    public void addLocatedFeatures(Location arg) {
        this.locatedFeatures.add(arg);
    }

    @Override
    public Set<Location> getLocations() {
        return this.locations;
    }

    @Override
    public void setLocations(Set<Location> locations) {
        this.locations = locations;
    }

    @Override
    public void addLocations(Location arg) {
        this.locations.add(arg);
    }

    @Override
    public Set<Synonym> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public void setSynonyms(Set<Synonym> synonyms) {
        this.synonyms = synonyms;
    }

    @Override
    public void addSynonyms(Synonym arg) {
        this.synonyms.add(arg);
    }

    @Override
    public Set<DataSet> getDataSets() {
        return this.dataSets;
    }

    @Override
    public void setDataSets(Set<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    @Override
    public void addDataSets(DataSet arg) {
        this.dataSets.add(arg);
    }

    @Override
    public Set<CrossReference> getCrossReferences() {
        return this.crossReferences;
    }

    @Override
    public void setCrossReferences(Set<CrossReference> crossReferences) {
        this.crossReferences = crossReferences;
    }

    @Override
    public void addCrossReferences(CrossReference arg) {
        this.crossReferences.add(arg);
    }

    @Override
    public String getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    @Override
    public void setPrimaryIdentifier(String primaryIdentifier) {
        this.primaryIdentifier = primaryIdentifier;
    }

    @Override
    public Set<OntologyAnnotation> getOntologyAnnotations() {
        return this.ontologyAnnotations;
    }

    @Override
    public void setOntologyAnnotations(Set<OntologyAnnotation> ontologyAnnotations) {
        this.ontologyAnnotations = ontologyAnnotations;
    }

    @Override
    public void addOntologyAnnotations(OntologyAnnotation arg) {
        this.ontologyAnnotations.add(arg);
    }

    @Override
    public Set<Publication> getPublications() {
        return this.publications;
    }

    @Override
    public void setPublications(Set<Publication> publications) {
        this.publications = publications;
    }

    @Override
    public void addPublications(Publication arg) {
        this.publications.add(arg);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        return o instanceof Gene && this.id != null ? this.id.equals(((Gene)o).getId()) : this == o;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public String toString() {
        return "Gene [briefDescription=" + (this.briefDescription == null ? "null" : "\"" + this.briefDescription + "\"") + ", chromosome=" + (this.chromosome == null ? "null" : (this.chromosome.getId() == null ? "no id" : this.chromosome.getId().toString())) + ", chromosomeLocation=" + (this.chromosomeLocation == null ? "null" : (this.chromosomeLocation.getId() == null ? "no id" : this.chromosomeLocation.getId().toString())) + ", description=" + (this.description == null ? "null" : "\"" + this.description + "\"") + ", downstreamIntergenicRegion=" + (this.downstreamIntergenicRegion == null ? "null" : (this.downstreamIntergenicRegion.getId() == null ? "no id" : this.downstreamIntergenicRegion.getId().toString())) + ", id=" + this.id + ", length=" + this.length + ", name=" + (this.name == null ? "null" : "\"" + this.name + "\"") + ", organism=" + (this.organism == null ? "null" : (this.organism.getId() == null ? "no id" : this.organism.getId().toString())) + ", primaryIdentifier=" + (this.primaryIdentifier == null ? "null" : "\"" + this.primaryIdentifier + "\"") + ", score=" + this.score + ", scoreType=" + (this.scoreType == null ? "null" : "\"" + this.scoreType + "\"") + ", secondaryIdentifier=" + (this.secondaryIdentifier == null ? "null" : "\"" + this.secondaryIdentifier + "\"") + ", sequence=" + (this.sequence == null ? "null" : (this.sequence.getId() == null ? "no id" : this.sequence.getId().toString())) + ", sequenceOntologyTerm=" + (this.sequenceOntologyTerm == null ? "null" : (this.sequenceOntologyTerm.getId() == null ? "no id" : this.sequenceOntologyTerm.getId().toString())) + ", strain=" + (this.strain == null ? "null" : (this.strain.getId() == null ? "no id" : this.strain.getId().toString())) + ", symbol=" + (this.symbol == null ? "null" : "\"" + this.symbol + "\"") + ", upstreamIntergenicRegion=" + (this.upstreamIntergenicRegion == null ? "null" : (this.upstreamIntergenicRegion.getId() == null ? "no id" : this.upstreamIntergenicRegion.getId().toString())) + "]";
    }

    public Object getFieldValue(String fieldName) throws IllegalAccessException {
        if ("briefDescription".equals(fieldName)) {
            return this.briefDescription;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("upstreamIntergenicRegion".equals(fieldName)) {
            if (this.upstreamIntergenicRegion instanceof ProxyReference) {
                return ((ProxyReference)this.upstreamIntergenicRegion).getObject();
            }
            return this.upstreamIntergenicRegion;
        }
        if ("downstreamIntergenicRegion".equals(fieldName)) {
            if (this.downstreamIntergenicRegion instanceof ProxyReference) {
                return ((ProxyReference)this.downstreamIntergenicRegion).getObject();
            }
            return this.downstreamIntergenicRegion;
        }
        if ("flankingRegions".equals(fieldName)) {
            return this.flankingRegions;
        }
        if ("introns".equals(fieldName)) {
            return this.introns;
        }
        if ("proteins".equals(fieldName)) {
            return this.proteins;
        }
        if ("CDSs".equals(fieldName)) {
            return this.CDSs;
        }
        if ("homologues".equals(fieldName)) {
            return this.homologues;
        }
        if ("exons".equals(fieldName)) {
            return this.exons;
        }
        if ("UTRs".equals(fieldName)) {
            return this.UTRs;
        }
        if ("score".equals(fieldName)) {
            return this.score;
        }
        if ("scoreType".equals(fieldName)) {
            return this.scoreType;
        }
        if ("length".equals(fieldName)) {
            return this.length;
        }
        if ("strain".equals(fieldName)) {
            if (this.strain instanceof ProxyReference) {
                return ((ProxyReference)this.strain).getObject();
            }
            return this.strain;
        }
        if ("sequenceOntologyTerm".equals(fieldName)) {
            if (this.sequenceOntologyTerm instanceof ProxyReference) {
                return ((ProxyReference)this.sequenceOntologyTerm).getObject();
            }
            return this.sequenceOntologyTerm;
        }
        if ("chromosomeLocation".equals(fieldName)) {
            if (this.chromosomeLocation instanceof ProxyReference) {
                return ((ProxyReference)this.chromosomeLocation).getObject();
            }
            return this.chromosomeLocation;
        }
        if ("sequence".equals(fieldName)) {
            if (this.sequence instanceof ProxyReference) {
                return ((ProxyReference)this.sequence).getObject();
            }
            return this.sequence;
        }
        if ("chromosome".equals(fieldName)) {
            if (this.chromosome instanceof ProxyReference) {
                return ((ProxyReference)this.chromosome).getObject();
            }
            return this.chromosome;
        }
        if ("overlappingFeatures".equals(fieldName)) {
            return this.overlappingFeatures;
        }
        if ("childFeatures".equals(fieldName)) {
            return this.childFeatures;
        }
        if ("symbol".equals(fieldName)) {
            return this.symbol;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return this.secondaryIdentifier;
        }
        if ("organism".equals(fieldName)) {
            if (this.organism instanceof ProxyReference) {
                return ((ProxyReference)this.organism).getObject();
            }
            return this.organism;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return this.locatedFeatures;
        }
        if ("locations".equals(fieldName)) {
            return this.locations;
        }
        if ("synonyms".equals(fieldName)) {
            return this.synonyms;
        }
        if ("dataSets".equals(fieldName)) {
            return this.dataSets;
        }
        if ("crossReferences".equals(fieldName)) {
            return this.crossReferences;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return this.primaryIdentifier;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return this.ontologyAnnotations;
        }
        if ("publications".equals(fieldName)) {
            return this.publications;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!Gene.class.equals(this.getClass())) {
            return TypeUtil.getFieldValue((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public Object getFieldProxy(String fieldName) throws IllegalAccessException {
        if ("briefDescription".equals(fieldName)) {
            return this.briefDescription;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("upstreamIntergenicRegion".equals(fieldName)) {
            return this.upstreamIntergenicRegion;
        }
        if ("downstreamIntergenicRegion".equals(fieldName)) {
            return this.downstreamIntergenicRegion;
        }
        if ("flankingRegions".equals(fieldName)) {
            return this.flankingRegions;
        }
        if ("introns".equals(fieldName)) {
            return this.introns;
        }
        if ("proteins".equals(fieldName)) {
            return this.proteins;
        }
        if ("CDSs".equals(fieldName)) {
            return this.CDSs;
        }
        if ("homologues".equals(fieldName)) {
            return this.homologues;
        }
        if ("exons".equals(fieldName)) {
            return this.exons;
        }
        if ("UTRs".equals(fieldName)) {
            return this.UTRs;
        }
        if ("score".equals(fieldName)) {
            return this.score;
        }
        if ("scoreType".equals(fieldName)) {
            return this.scoreType;
        }
        if ("length".equals(fieldName)) {
            return this.length;
        }
        if ("strain".equals(fieldName)) {
            return this.strain;
        }
        if ("sequenceOntologyTerm".equals(fieldName)) {
            return this.sequenceOntologyTerm;
        }
        if ("chromosomeLocation".equals(fieldName)) {
            return this.chromosomeLocation;
        }
        if ("sequence".equals(fieldName)) {
            return this.sequence;
        }
        if ("chromosome".equals(fieldName)) {
            return this.chromosome;
        }
        if ("overlappingFeatures".equals(fieldName)) {
            return this.overlappingFeatures;
        }
        if ("childFeatures".equals(fieldName)) {
            return this.childFeatures;
        }
        if ("symbol".equals(fieldName)) {
            return this.symbol;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return this.secondaryIdentifier;
        }
        if ("organism".equals(fieldName)) {
            return this.organism;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return this.locatedFeatures;
        }
        if ("locations".equals(fieldName)) {
            return this.locations;
        }
        if ("synonyms".equals(fieldName)) {
            return this.synonyms;
        }
        if ("dataSets".equals(fieldName)) {
            return this.dataSets;
        }
        if ("crossReferences".equals(fieldName)) {
            return this.crossReferences;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return this.primaryIdentifier;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return this.ontologyAnnotations;
        }
        if ("publications".equals(fieldName)) {
            return this.publications;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if (!Gene.class.equals(this.getClass())) {
            return TypeUtil.getFieldProxy((Object)this, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public void setFieldValue(String fieldName, Object value) {
        if ("briefDescription".equals(fieldName)) {
            this.briefDescription = (String)value;
        } else if ("description".equals(fieldName)) {
            this.description = (String)value;
        } else if ("upstreamIntergenicRegion".equals(fieldName)) {
            this.upstreamIntergenicRegion = (InterMineObject)value;
        } else if ("downstreamIntergenicRegion".equals(fieldName)) {
            this.downstreamIntergenicRegion = (InterMineObject)value;
        } else if ("flankingRegions".equals(fieldName)) {
            this.flankingRegions = (Set)value;
        } else if ("introns".equals(fieldName)) {
            this.introns = (Set)value;
        } else if ("proteins".equals(fieldName)) {
            this.proteins = (Set)value;
        } else if ("CDSs".equals(fieldName)) {
            this.CDSs = (Set)value;
        } else if ("homologues".equals(fieldName)) {
            this.homologues = (Set)value;
        } else if ("exons".equals(fieldName)) {
            this.exons = (Set)value;
        } else if ("UTRs".equals(fieldName)) {
            this.UTRs = (Set)value;
        } else if ("score".equals(fieldName)) {
            this.score = (Double)value;
        } else if ("scoreType".equals(fieldName)) {
            this.scoreType = (String)value;
        } else if ("length".equals(fieldName)) {
            this.length = (Integer)value;
        } else if ("strain".equals(fieldName)) {
            this.strain = (InterMineObject)value;
        } else if ("sequenceOntologyTerm".equals(fieldName)) {
            this.sequenceOntologyTerm = (InterMineObject)value;
        } else if ("chromosomeLocation".equals(fieldName)) {
            this.chromosomeLocation = (InterMineObject)value;
        } else if ("sequence".equals(fieldName)) {
            this.sequence = (InterMineObject)value;
        } else if ("chromosome".equals(fieldName)) {
            this.chromosome = (InterMineObject)value;
        } else if ("overlappingFeatures".equals(fieldName)) {
            this.overlappingFeatures = (Set)value;
        } else if ("childFeatures".equals(fieldName)) {
            this.childFeatures = (Set)value;
        } else if ("symbol".equals(fieldName)) {
            this.symbol = (String)value;
        } else if ("name".equals(fieldName)) {
            this.name = (String)value;
        } else if ("secondaryIdentifier".equals(fieldName)) {
            this.secondaryIdentifier = (String)value;
        } else if ("organism".equals(fieldName)) {
            this.organism = (InterMineObject)value;
        } else if ("locatedFeatures".equals(fieldName)) {
            this.locatedFeatures = (Set)value;
        } else if ("locations".equals(fieldName)) {
            this.locations = (Set)value;
        } else if ("synonyms".equals(fieldName)) {
            this.synonyms = (Set)value;
        } else if ("dataSets".equals(fieldName)) {
            this.dataSets = (Set)value;
        } else if ("crossReferences".equals(fieldName)) {
            this.crossReferences = (Set)value;
        } else if ("primaryIdentifier".equals(fieldName)) {
            this.primaryIdentifier = (String)value;
        } else if ("ontologyAnnotations".equals(fieldName)) {
            this.ontologyAnnotations = (Set)value;
        } else if ("publications".equals(fieldName)) {
            this.publications = (Set)value;
        } else if ("id".equals(fieldName)) {
            this.id = (Integer)value;
        } else {
            if (!Gene.class.equals(this.getClass())) {
                DynamicUtil.setFieldValue((Object)this, (String)fieldName, (Object)value);
                return;
            }
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
    }

    public Class<?> getFieldType(String fieldName) {
        if ("briefDescription".equals(fieldName)) {
            return String.class;
        }
        if ("description".equals(fieldName)) {
            return String.class;
        }
        if ("upstreamIntergenicRegion".equals(fieldName)) {
            return IntergenicRegion.class;
        }
        if ("downstreamIntergenicRegion".equals(fieldName)) {
            return IntergenicRegion.class;
        }
        if ("flankingRegions".equals(fieldName)) {
            return Set.class;
        }
        if ("introns".equals(fieldName)) {
            return Set.class;
        }
        if ("proteins".equals(fieldName)) {
            return Set.class;
        }
        if ("CDSs".equals(fieldName)) {
            return Set.class;
        }
        if ("homologues".equals(fieldName)) {
            return Set.class;
        }
        if ("exons".equals(fieldName)) {
            return Set.class;
        }
        if ("UTRs".equals(fieldName)) {
            return Set.class;
        }
        if ("score".equals(fieldName)) {
            return Double.class;
        }
        if ("scoreType".equals(fieldName)) {
            return String.class;
        }
        if ("length".equals(fieldName)) {
            return Integer.class;
        }
        if ("strain".equals(fieldName)) {
            return Strain.class;
        }
        if ("sequenceOntologyTerm".equals(fieldName)) {
            return SOTerm.class;
        }
        if ("chromosomeLocation".equals(fieldName)) {
            return Location.class;
        }
        if ("sequence".equals(fieldName)) {
            return Sequence.class;
        }
        if ("chromosome".equals(fieldName)) {
            return Chromosome.class;
        }
        if ("overlappingFeatures".equals(fieldName)) {
            return Set.class;
        }
        if ("childFeatures".equals(fieldName)) {
            return Set.class;
        }
        if ("symbol".equals(fieldName)) {
            return String.class;
        }
        if ("name".equals(fieldName)) {
            return String.class;
        }
        if ("secondaryIdentifier".equals(fieldName)) {
            return String.class;
        }
        if ("organism".equals(fieldName)) {
            return Organism.class;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return Set.class;
        }
        if ("locations".equals(fieldName)) {
            return Set.class;
        }
        if ("synonyms".equals(fieldName)) {
            return Set.class;
        }
        if ("dataSets".equals(fieldName)) {
            return Set.class;
        }
        if ("crossReferences".equals(fieldName)) {
            return Set.class;
        }
        if ("primaryIdentifier".equals(fieldName)) {
            return String.class;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return Set.class;
        }
        if ("publications".equals(fieldName)) {
            return Set.class;
        }
        if ("id".equals(fieldName)) {
            return Integer.class;
        }
        if (!Gene.class.equals(this.getClass())) {
            return TypeUtil.getFieldType(Gene.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }

    public StringConstructor getoBJECT() {
        int delimPosition;
        String string;
        if (!GeneShadow.class.equals(this.getClass())) {
            return NotXmlRenderer.render((Object)this);
        }
        StringConstructor sb = new StringConstructor();
        sb.append("$_^org.intermine.model.bio.Gene");
        if (this.briefDescription != null) {
            sb.append("$_^abriefDescription$_^");
            string = this.briefDescription;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.description != null) {
            sb.append("$_^adescription$_^");
            string = this.description;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.upstreamIntergenicRegion != null) {
            sb.append("$_^rupstreamIntergenicRegion$_^").append((Object)this.upstreamIntergenicRegion.getId());
        }
        if (this.downstreamIntergenicRegion != null) {
            sb.append("$_^rdownstreamIntergenicRegion$_^").append((Object)this.downstreamIntergenicRegion.getId());
        }
        if (this.score != null) {
            sb.append("$_^ascore$_^").append((Object)this.score);
        }
        if (this.scoreType != null) {
            sb.append("$_^ascoreType$_^");
            string = this.scoreType;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.length != null) {
            sb.append("$_^alength$_^").append((Object)this.length);
        }
        if (this.strain != null) {
            sb.append("$_^rstrain$_^").append((Object)this.strain.getId());
        }
        if (this.sequenceOntologyTerm != null) {
            sb.append("$_^rsequenceOntologyTerm$_^").append((Object)this.sequenceOntologyTerm.getId());
        }
        if (this.chromosomeLocation != null) {
            sb.append("$_^rchromosomeLocation$_^").append((Object)this.chromosomeLocation.getId());
        }
        if (this.sequence != null) {
            sb.append("$_^rsequence$_^").append((Object)this.sequence.getId());
        }
        if (this.chromosome != null) {
            sb.append("$_^rchromosome$_^").append((Object)this.chromosome.getId());
        }
        if (this.symbol != null) {
            sb.append("$_^asymbol$_^");
            string = this.symbol;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.name != null) {
            sb.append("$_^aname$_^");
            string = this.name;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.secondaryIdentifier != null) {
            sb.append("$_^asecondaryIdentifier$_^");
            string = this.secondaryIdentifier;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.organism != null) {
            sb.append("$_^rorganism$_^").append((Object)this.organism.getId());
        }
        if (this.primaryIdentifier != null) {
            sb.append("$_^aprimaryIdentifier$_^");
            string = this.primaryIdentifier;
            while (string != null) {
                delimPosition = string.indexOf("$_^");
                if (delimPosition == -1) {
                    sb.append(string);
                    string = null;
                    continue;
                }
                sb.append(string.substring(0, delimPosition + 3));
                sb.append("d");
                string = string.substring(delimPosition + 3);
            }
        }
        if (this.id != null) {
            sb.append("$_^aid$_^").append((Object)this.id);
        }
        return sb;
    }

    public void setoBJECT(String notXml, ObjectStore os) {
        this.setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);
    }

    public void setoBJECT(String[] notXml, ObjectStore os) {
        if (!GeneShadow.class.equals(this.getClass())) {
            throw new IllegalStateException("Class " + this.getClass().getName() + " does not match code (org.intermine.model.bio.Gene)");
        }
        int i = 2;
        while (i < notXml.length) {
            StringBuilder string;
            int startI = i;
            if (i < notXml.length && "abriefDescription".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.briefDescription = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "adescription".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.description = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "rupstreamIntergenicRegion".equals(notXml[i])) {
                this.upstreamIntergenicRegion = new ProxyReference(os, Integer.valueOf(notXml[++i]), IntergenicRegion.class);
                ++i;
            }
            if (i < notXml.length && "rdownstreamIntergenicRegion".equals(notXml[i])) {
                this.downstreamIntergenicRegion = new ProxyReference(os, Integer.valueOf(notXml[++i]), IntergenicRegion.class);
                ++i;
            }
            if (i < notXml.length && "ascore".equals(notXml[i])) {
                this.score = Double.valueOf(notXml[++i]);
                ++i;
            }
            if (i < notXml.length && "ascoreType".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.scoreType = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "alength".equals(notXml[i])) {
                this.length = Integer.valueOf(notXml[++i]);
                ++i;
            }
            if (i < notXml.length && "rstrain".equals(notXml[i])) {
                this.strain = new ProxyReference(os, Integer.valueOf(notXml[++i]), Strain.class);
                ++i;
            }
            if (i < notXml.length && "rsequenceOntologyTerm".equals(notXml[i])) {
                this.sequenceOntologyTerm = new ProxyReference(os, Integer.valueOf(notXml[++i]), SOTerm.class);
                ++i;
            }
            if (i < notXml.length && "rchromosomeLocation".equals(notXml[i])) {
                this.chromosomeLocation = new ProxyReference(os, Integer.valueOf(notXml[++i]), Location.class);
                ++i;
            }
            if (i < notXml.length && "rsequence".equals(notXml[i])) {
                this.sequence = new ProxyReference(os, Integer.valueOf(notXml[++i]), Sequence.class);
                ++i;
            }
            if (i < notXml.length && "rchromosome".equals(notXml[i])) {
                this.chromosome = new ProxyReference(os, Integer.valueOf(notXml[++i]), Chromosome.class);
                ++i;
            }
            if (i < notXml.length && "asymbol".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.symbol = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "aname".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.name = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "asecondaryIdentifier".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.secondaryIdentifier = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "rorganism".equals(notXml[i])) {
                this.organism = new ProxyReference(os, Integer.valueOf(notXml[++i]), Organism.class);
                ++i;
            }
            if (i < notXml.length && "aprimaryIdentifier".equals(notXml[i])) {
                ++i;
                string = null;
                while (i + 1 < notXml.length && notXml[i + 1].charAt(0) == 'd') {
                    if (string == null) {
                        string = new StringBuilder(notXml[i]);
                    }
                    string.append("$_^").append(notXml[++i].substring(1));
                }
                this.primaryIdentifier = string == null ? notXml[i] : string.toString();
                ++i;
            }
            if (i < notXml.length && "aid".equals(notXml[i])) {
                this.id = Integer.valueOf(notXml[++i]);
                ++i;
            }
            if (startI != i) continue;
            throw new IllegalArgumentException("Unknown field " + notXml[i]);
        }
        this.flankingRegions = new ProxyCollection(os, (InterMineObject)this, "flankingRegions", GeneFlankingRegion.class);
        this.introns = new ProxyCollection(os, (InterMineObject)this, "introns", Intron.class);
        this.proteins = new ProxyCollection(os, (InterMineObject)this, "proteins", Protein.class);
        this.CDSs = new ProxyCollection(os, (InterMineObject)this, "CDSs", CDS.class);
        this.homologues = new ProxyCollection(os, (InterMineObject)this, "homologues", Homologue.class);
        this.exons = new ProxyCollection(os, (InterMineObject)this, "exons", Exon.class);
        this.UTRs = new ProxyCollection(os, (InterMineObject)this, "UTRs", UTR.class);
        this.overlappingFeatures = new ProxyCollection(os, (InterMineObject)this, "overlappingFeatures", SequenceFeature.class);
        this.childFeatures = new ProxyCollection(os, (InterMineObject)this, "childFeatures", SequenceFeature.class);
        this.locatedFeatures = new ProxyCollection(os, (InterMineObject)this, "locatedFeatures", Location.class);
        this.locations = new ProxyCollection(os, (InterMineObject)this, "locations", Location.class);
        this.synonyms = new ProxyCollection(os, (InterMineObject)this, "synonyms", Synonym.class);
        this.dataSets = new ProxyCollection(os, (InterMineObject)this, "dataSets", DataSet.class);
        this.crossReferences = new ProxyCollection(os, (InterMineObject)this, "crossReferences", CrossReference.class);
        this.ontologyAnnotations = new ProxyCollection(os, (InterMineObject)this, "ontologyAnnotations", OntologyAnnotation.class);
        this.publications = new ProxyCollection(os, (InterMineObject)this, "publications", Publication.class);
    }

    public void addCollectionElement(String fieldName, InterMineObject element) {
        if ("flankingRegions".equals(fieldName)) {
            this.flankingRegions.add((GeneFlankingRegion)element);
        } else if ("introns".equals(fieldName)) {
            this.introns.add((Intron)element);
        } else if ("proteins".equals(fieldName)) {
            this.proteins.add((Protein)element);
        } else if ("CDSs".equals(fieldName)) {
            this.CDSs.add((CDS)element);
        } else if ("homologues".equals(fieldName)) {
            this.homologues.add((Homologue)element);
        } else if ("exons".equals(fieldName)) {
            this.exons.add((Exon)element);
        } else if ("UTRs".equals(fieldName)) {
            this.UTRs.add((UTR)element);
        } else if ("overlappingFeatures".equals(fieldName)) {
            this.overlappingFeatures.add((SequenceFeature)element);
        } else if ("childFeatures".equals(fieldName)) {
            this.childFeatures.add((SequenceFeature)element);
        } else if ("locatedFeatures".equals(fieldName)) {
            this.locatedFeatures.add((Location)element);
        } else if ("locations".equals(fieldName)) {
            this.locations.add((Location)element);
        } else if ("synonyms".equals(fieldName)) {
            this.synonyms.add((Synonym)element);
        } else if ("dataSets".equals(fieldName)) {
            this.dataSets.add((DataSet)element);
        } else if ("crossReferences".equals(fieldName)) {
            this.crossReferences.add((CrossReference)element);
        } else if ("ontologyAnnotations".equals(fieldName)) {
            this.ontologyAnnotations.add((OntologyAnnotation)element);
        } else if ("publications".equals(fieldName)) {
            this.publications.add((Publication)element);
        } else {
            if (!Gene.class.equals(this.getClass())) {
                TypeUtil.addCollectionElement((Object)this, (String)fieldName, (Object)element);
                return;
            }
            throw new IllegalArgumentException("Unknown collection " + fieldName);
        }
    }

    public Class<?> getElementType(String fieldName) {
        if ("flankingRegions".equals(fieldName)) {
            return GeneFlankingRegion.class;
        }
        if ("introns".equals(fieldName)) {
            return Intron.class;
        }
        if ("proteins".equals(fieldName)) {
            return Protein.class;
        }
        if ("CDSs".equals(fieldName)) {
            return CDS.class;
        }
        if ("homologues".equals(fieldName)) {
            return Homologue.class;
        }
        if ("exons".equals(fieldName)) {
            return Exon.class;
        }
        if ("UTRs".equals(fieldName)) {
            return UTR.class;
        }
        if ("overlappingFeatures".equals(fieldName)) {
            return SequenceFeature.class;
        }
        if ("childFeatures".equals(fieldName)) {
            return SequenceFeature.class;
        }
        if ("locatedFeatures".equals(fieldName)) {
            return Location.class;
        }
        if ("locations".equals(fieldName)) {
            return Location.class;
        }
        if ("synonyms".equals(fieldName)) {
            return Synonym.class;
        }
        if ("dataSets".equals(fieldName)) {
            return DataSet.class;
        }
        if ("crossReferences".equals(fieldName)) {
            return CrossReference.class;
        }
        if ("ontologyAnnotations".equals(fieldName)) {
            return OntologyAnnotation.class;
        }
        if ("publications".equals(fieldName)) {
            return Publication.class;
        }
        if (!Gene.class.equals(this.getClass())) {
            return TypeUtil.getElementType(Gene.class, (String)fieldName);
        }
        throw new IllegalArgumentException("Unknown field " + fieldName);
    }
}

