/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.dataconversion;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.bio.dataconversion.BioFileConverter;
import org.intermine.bio.dataconversion.GeneInfoRecord;
import org.intermine.bio.dataconversion.NcbiGeneInfoParser;
import org.intermine.dataconversion.ItemWriter;
import org.intermine.metadata.Model;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.xml.full.Item;

public class NcbiGeneConverter
extends BioFileConverter {
    private static final String DATASET_TITLE = "NCBI Entrez Gene identifiers";
    private static final String DATA_SOURCE_NAME = "NCBI";
    private Set<String> taxonIds = null;
    protected static final Logger LOG = Logger.getLogger(NcbiGeneConverter.class);
    private static final String PROP_FILE = "ncbigene_config.properties";
    private Properties props = new Properties();
    private Map<String, String> configXref = new HashMap<String, String>();
    private Map<String, String> configPrefix = new HashMap<String, String>();
    private Set<String> genes = new HashSet<String>();

    public NcbiGeneConverter(ItemWriter writer, Model model) {
        super(writer, model, DATA_SOURCE_NAME, DATASET_TITLE);
        this.readConfig();
    }

    public void setOrganisms(String taxonIds) {
        this.taxonIds = new HashSet<String>(Arrays.asList(StringUtil.split((String)taxonIds, (String)" ")));
    }

    public void process(Reader reader) throws Exception {
        if (this.taxonIds == null) {
            throw new IllegalArgumentException("No organisms passed to NcbiGeneConverter.");
        }
        NcbiGeneInfoParser parser = new NcbiGeneInfoParser(reader, this.taxonIds);
        LOG.info((Object)("DUPLICATE symbols: " + parser.findDuplicateSymbols("9606")));
        Map records = parser.getGeneInfoRecords();
        for (String taxonId : records.keySet()) {
            for (GeneInfoRecord record : (Set)records.get(taxonId)) {
                this.createGeneByTaxonId(taxonId, record, parser);
            }
        }
    }

    private void createGeneByTaxonId(String taxonId, GeneInfoRecord record, NcbiGeneInfoParser parser) throws ObjectStoreException {
        Item gene = this.createItem("Gene");
        if (record.xrefs.get(this.configXref.get(taxonId)) != null) {
            String identifier = (String)((Set)record.xrefs.get(this.configXref.get(taxonId))).iterator().next();
            if (this.genes.contains(identifier)) {
                return;
            }
            this.genes.add(identifier);
            gene.setAttribute("primaryIdentifier", identifier);
        } else {
            gene.setAttribute("primaryIdentifier", record.entrez);
        }
        gene.setReference("organism", this.getOrganism(taxonId));
        this.createCrossReference(gene.getIdentifier(), record.entrez, DATA_SOURCE_NAME, true);
        if (record.officialSymbol != null) {
            gene.setAttribute("symbol", record.officialSymbol);
            if (record.defaultSymbol != null && !record.officialSymbol.equals(record.defaultSymbol)) {
                this.createSynonym(gene, record.defaultSymbol, true);
                LOG.info((Object)("GENE official symbol " + record.officialSymbol + " does not match " + record.defaultSymbol));
            }
        } else if (parser.isUniqueSymbol(taxonId, record.defaultSymbol)) {
            gene.setAttribute("symbol", record.defaultSymbol);
        } else {
            this.createSynonym(gene, record.defaultSymbol, true);
        }
        if (StringUtils.isBlank((String)record.officialSymbol)) {
            LOG.info((Object)("GENE has no official symbol: " + record.entrez + " " + record.defaultSymbol));
        }
        if (record.officialName != null) {
            gene.setAttribute("name", record.officialName);
            if (record.defaultName != null && !record.officialName.equals(record.defaultName)) {
                this.createSynonym(gene, record.defaultName, true);
            }
        } else if (record.defaultName != null) {
            gene.setAttribute("name", record.defaultName);
        }
        for (String key : record.xrefs.keySet()) {
            for (String id : (Set)record.xrefs.get(key)) {
                this.createCrossReference(gene.getIdentifier(), id, key, true);
            }
        }
        for (String ensemblId : record.ensemblIds) {
            gene.setAttribute("secondaryIdentifier", ensemblId);
            this.createCrossReference(gene.getIdentifier(), ensemblId, "Ensembl", true);
        }
        if (record.mapLocation != null) {
            gene.setAttribute("cytoLocation", record.mapLocation);
        }
        this.store(gene);
        for (String synonym : record.synonyms) {
            this.createSynonym(gene, synonym, true);
        }
    }

    private void readConfig() {
        try {
            this.props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROP_FILE));
        }
        catch (IOException e) {
            throw new RuntimeException("I/O Problem loading properties 'ncbigene_config.properties'", e);
        }
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((String)entry.getValue()).trim();
            String[] attributes = key.split("\\.");
            if (attributes.length == 0) {
                throw new RuntimeException("Problem loading properties 'ncbigene_config.properties' on line " + key);
            }
            String taxonId = attributes[0];
            if ("xref".equals(attributes[1])) {
                this.configXref.put(taxonId, value);
                continue;
            }
            if (!"prefix".equals(attributes[1])) continue;
            this.configPrefix.put(taxonId, value);
        }
    }
}

