/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import org.intermine.bio.io.bed.BEDRecord;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.SequenceFeature;

public final class BEDUtil {
    private static final String UCSC_CHR_PREFIX = "chr";

    private BEDUtil() {
    }

    public static BEDRecord makeBEDRecord(SequenceFeature lsf) {
        return BEDUtil.makeBEDRecord(lsf, true);
    }

    public static BEDRecord makeBEDRecord(SequenceFeature lsf, boolean makeUcscCompatible) {
        String chrom = null;
        int chromStart = -1;
        int chromEnd = -1;
        String name = null;
        boolean score = false;
        String strand = ".";
        if (lsf instanceof Chromosome) {
            return null;
        }
        Chromosome chr = lsf.getChromosome();
        if (chr == null) {
            return null;
        }
        name = lsf.getSymbol() == null ? (lsf.getPrimaryIdentifier() == null ? "(Unknown)" : lsf.getPrimaryIdentifier()) : lsf.getSymbol();
        name = name.replaceAll(" ", "_");
        Location chrLocation = lsf.getChromosomeLocation();
        if (chrLocation == null) {
            return null;
        }
        chrom = makeUcscCompatible ? UCSC_CHR_PREFIX + chr.getPrimaryIdentifier() : chr.getPrimaryIdentifier();
        chromStart = chrLocation.getStart() - 1;
        chromEnd = chrLocation.getEnd();
        if (chrLocation.getStrand() != null) {
            if ("1".equals(chrLocation.getStrand())) {
                strand = "+";
            } else if ("-1".equals(chrLocation.getStrand())) {
                strand = "-";
            }
        }
        return new BEDRecord(chrom, chromStart, chromEnd, name, 0, strand);
    }
}

