/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.intermine.bio.io.gff3.GFF3Record;
import org.intermine.metadata.TypeUtil;
import org.intermine.metadata.Util;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.SequenceFeature;

public final class GFF3Util {
    private static final Logger LOG = Logger.getLogger(GFF3Util.class);
    private static final String UCSC_PREFIX = "chr";

    private GFF3Util() {
    }

    public static GFF3Record makeGFF3Record(SequenceFeature lsf, Map<String, String> soClassNameMap, String sourceName, Map<String, List<String>> extraAttributes) {
        return GFF3Util.makeGFF3Record(lsf, soClassNameMap, sourceName, extraAttributes, false);
    }

    public static GFF3Record makeGFF3Record(SequenceFeature lsf, Map<String, String> soClassNameMap, String sourceName, Map<String, List<String>> extraAttributes, boolean makeUcscCompatible) {
        Set classes = Util.decomposeClass(lsf.getClass());
        String type = null;
        String sequenceID = null;
        int start = -1;
        int end = -1;
        String strand = ".";
        if (lsf instanceof Chromosome) {
            return null;
        }
        Chromosome chr = lsf.getChromosome();
        if (chr == null) {
            return null;
        }
        Location chrLocation = lsf.getChromosomeLocation();
        if (chrLocation == null) {
            return null;
        }
        sequenceID = makeUcscCompatible ? UCSC_PREFIX + chr.getPrimaryIdentifier() : chr.getPrimaryIdentifier();
        for (Class c : classes) {
            if (!SequenceFeature.class.isAssignableFrom(c)) continue;
            String className = TypeUtil.unqualifiedName((String)c.getName());
            if (soClassNameMap.containsKey(className)) {
                type = soClassNameMap.get(className);
                break;
            }
            type = className;
            LOG.warn((Object)("in GFF3Util.makeGFF3Record() - cannot find SO term name for: " + className));
        }
        start = chrLocation.getStart();
        end = chrLocation.getEnd();
        if (chrLocation.getStrand() != null) {
            if ("1".equals(chrLocation.getStrand())) {
                strand = "+";
            } else if ("-1".equals(chrLocation.getStrand())) {
                strand = "-";
            }
        }
        TreeMap<String, List<String>> recordAttribute = new TreeMap<String, List<String>>(extraAttributes);
        if (lsf.getPrimaryIdentifier() != null) {
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(lsf.getPrimaryIdentifier());
            recordAttribute.put("ID", idList);
        }
        Double score = null;
        try {
            for (Class c : Util.decomposeClass(lsf.getClass())) {
                if (TypeUtil.getFieldInfo((Class)c, (String)"score") == null) continue;
                score = (Double)lsf.getFieldValue("score");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new GFF3Record(sequenceID, sourceName, type, start, end, score, strand, null, recordAttribute);
    }
}

