/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.struts;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.io.FastaWriterHelper;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.ontology.utils.SmallAnnotation;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.web.biojava.BioSequence;
import org.intermine.bio.web.biojava.BioSequenceFactory;
import org.intermine.bio.web.export.ResidueFieldExporter;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.BioEntity;
import org.intermine.model.bio.Protein;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;

public class SequenceExportAction
extends InterMineAction {
    private static final String PROPERTY_DESCRIPTIONLINE = "description_line";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer objectId;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ObjectStore os = im.getObjectStore();
        BioSequence bioSequence = null;
        Properties webProps = (Properties)session.getServletContext().getAttribute("WEB_PROPERTIES");
        InterMineObject obj = this.getObject(os, webProps, objectId = new Integer(request.getParameter("object")));
        if (obj instanceof SequenceFeature || obj instanceof Protein) {
            bioSequence = this.createBioSequence(obj);
            response.setContentType("text/plain");
            if (bioSequence != null) {
                ServletOutputStream out = response.getOutputStream();
                bioSequence.setAccession(new AccessionID((String)obj.getFieldValue("primaryIdentifier")));
                FastaWriterHelper.writeSequence((OutputStream)out, (Sequence)bioSequence);
            } else {
                PrintWriter out = response.getWriter();
                out.write("Sequence information not availble for this sequence feature...");
                out.flush();
            }
        }
        return null;
    }

    private BioSequence createBioSequence(InterMineObject obj) throws IllegalAccessException, CompoundNotFoundException {
        BioEntity bioEntity = (BioEntity)obj;
        BioSequence bioSequence = BioSequenceFactory.make(bioEntity, BioSequenceFactory.SequenceType.DNA);
        if (bioSequence == null) {
            return null;
        }
        SmallAnnotation annotation = bioSequence.getAnnotation();
        String identifier = bioEntity.getPrimaryIdentifier();
        if (identifier == null && (identifier = bioEntity.getSecondaryIdentifier()) == null && (identifier = bioEntity.getName()) == null) {
            try {
                identifier = (String)bioEntity.getFieldValue("primaryAccession");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (identifier == null) {
                identifier = "[no_identifier]";
            }
        }
        annotation.setProperty((Object)PROPERTY_DESCRIPTIONLINE, (Object)identifier);
        return bioSequence;
    }

    private InterMineObject getObject(ObjectStore os, Properties webProps, Integer objectId) throws ObjectStoreException {
        InterMineObject obj;
        block4: {
            Class clazz;
            String classNames = webProps.getProperty("fasta.export.classes");
            ArrayList<Class> classList = new ArrayList<Class>();
            if (classNames != null && classNames.length() != 0) {
                String[] classArray = classNames.split(",");
                for (int i = 0; i < classArray.length; ++i) {
                    classList.add(TypeUtil.instantiate((String)(os.getModel().getPackageName() + "." + classArray[i])));
                }
            } else {
                classList.addAll(Arrays.asList(Protein.class, SequenceFeature.class));
            }
            obj = os.getObjectById(objectId);
            if (!(obj instanceof org.intermine.model.bio.Sequence)) break block4;
            org.intermine.model.bio.Sequence sequence = (org.intermine.model.bio.Sequence)obj;
            Iterator iterator = classList.iterator();
            while (iterator.hasNext() && (obj = ResidueFieldExporter.getIMObjectForSequence(os, clazz = (Class)iterator.next(), sequence)) == null) {
            }
        }
        return obj;
    }
}

