/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.bag;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.bag.UnknownBagTypeException;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.profile.BagState;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.MainHelper;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BagHelper {
    public static final String BAG_NAME_PREFIX = "bag";

    private BagHelper() {
    }

    public static InterMineBag createBagFromPathQuery(PathQuery query, String bagName, String bagDescription, String pathString, Profile profile, InterMineAPI im) throws ObjectStoreException {
        PathQuery pathQuery = query;
        pathQuery = pathQuery.clone();
        String bagType = pathString;
        try {
            Path idPath = pathQuery.makePath((String)pathQuery.getView().get(0));
            if (!"id".equals(idPath.getLastElement()) || pathString.contains(".")) {
                pathQuery.clearView();
                pathQuery.clearDescriptions();
                pathQuery.addView(pathString + ".id");
                Path path = new Path(im.getModel(), pathString);
                bagType = path.getLastClassDescriptor().getUnqualifiedName();
            }
        }
        catch (PathException e) {
            throw new RuntimeException("Query has invalid path: " + pathQuery.getView(), e);
        }
        ObjectStoreInterMineImpl os = (ObjectStoreInterMineImpl)im.getObjectStore();
        BagManager bagManager = im.getBagManager();
        Query q = MainHelper.makeQuery((PathQuery)pathQuery, (Map)bagManager.getBags(profile), null, (BagQueryRunner)im.getBagQueryRunner(), null);
        InterMineBag bag = null;
        try {
            List keyFielNames = ClassKeyHelper.getKeyFieldNames((Map)im.getClassKeys(), (String)bagType);
            bag = new InterMineBag(bagName, bagType, bagDescription, new Date(), BagState.CURRENT, (ObjectStore)os, profile.getUserId(), profile.getProfileManager().getProfileObjectStoreWriter(), keyFielNames);
        }
        catch (UnknownBagTypeException e) {
            throw new RuntimeException("Bag type determined from query is invalid", e);
        }
        bag.addToBagFromQuery(q);
        profile.saveBag(bag.getName(), bag);
        return bag;
    }

    public static String getAttributesFromBag(InterMineBag bag, ObjectStore os, String dbName, String attrName, String delimiter) {
        QueryClass queryClass;
        Query q = new Query();
        try {
            queryClass = new QueryClass(new Class[]{Class.forName(bag.getQualifiedType())});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("no type in the bag??! -> ", e);
        }
        q.addFrom((FromElement)queryClass);
        QueryField qf = new QueryField(queryClass, attrName);
        q.addToSelect((QuerySelectable)qf);
        QueryField id = new QueryField(queryClass, "id");
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        SimpleConstraint sc = new SimpleConstraint((QueryEvaluable)qf, ConstraintOp.IS_NOT_NULL);
        BagConstraint bagC = new BagConstraint((QueryNode)id, ConstraintOp.IN, bag.getOsb());
        cs.addConstraint((Constraint)sc);
        cs.addConstraint((Constraint)bagC);
        q.setConstraint((Constraint)cs);
        SingletonResults results = os.executeSingleton(q, 10000, true, true, true);
        return StringUtil.join((Collection)results, (String)delimiter);
    }

    public static String getAttributesFromBag(InterMineBag bag, ObjectStore os, String dbName, String attrName) {
        String defaultDelim = ",";
        return BagHelper.getAttributesFromBag((InterMineBag)bag, (ObjectStore)os, (String)dbName, (String)attrName, (String)",");
    }
}

