/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.export;

import java.util.List;
import java.util.StringTokenizer;
import org.intermine.web.logic.export.RowFormatter;

public class RowFormatterImpl
implements RowFormatter {
    private String delimiter;
    private boolean quoted;
    private static final String QUOTE = "\"";

    public RowFormatterImpl(String delimiter, boolean quoted) {
        this.delimiter = delimiter;
        this.quoted = quoted;
    }

    public String format(List<? extends Object> row) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            Object o = row.get(i);
            if (o != null) {
                if (o instanceof Number || !this.quoted && o.toString().indexOf(this.delimiter) < 0 && !"".equals(o.toString())) {
                    sb.append(this.getUnQuoted(o));
                } else {
                    sb.append(this.getQuoted(o));
                }
            } else {
                sb.append(this.getQuoted((Object)""));
            }
            if (i >= row.size() - 1) continue;
            sb.append(this.delimiter);
        }
        return sb.toString();
    }

    private String getQuoted(Object o) {
        String objectString = "" + o;
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokeniser = new StringTokenizer(objectString, QUOTE, true);
        buffer.append(QUOTE);
        while (tokeniser.hasMoreTokens()) {
            String tokenValue = tokeniser.nextToken();
            if (tokenValue.equals(QUOTE)) {
                buffer.append(tokenValue);
                buffer.append(tokenValue);
                continue;
            }
            buffer.append(tokenValue);
        }
        buffer.append('\"');
        return buffer.toString();
    }

    private String getUnQuoted(Object o) {
        return o.toString();
    }
}

