/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.util.PathUtil;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryHelper;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.widget.WidgetLdr;
import org.intermine.web.logic.widget.config.TableWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class TableWidgetLdr
extends WidgetLdr {
    private List<String> columns;
    private List<List<Object>> flattenedResults;
    private String title;
    private String description;
    private int widgetTotal = 0;
    private String pathString;
    private Model model;
    private String displayFields;
    private String exportField;
    private Path origPath;
    private String type;
    private TableWidgetConfig config;
    private ClassDescriptor cld;

    public TableWidgetLdr(WidgetConfig widgetConfig, InterMineBag bag, ObjectStore os, String ids) throws UnsupportedEncodingException {
        super(bag, os, null, widgetConfig, ids);
        this.config = (TableWidgetConfig)widgetConfig;
        this.pathString = this.config.getPathStrings();
        this.model = os.getModel();
        try {
            this.origPath = new Path(this.model, this.pathWithNoConstraints(this.pathString));
        }
        catch (PathException e) {
            throw new Error("Cannot create path for widget with path \"" + this.pathString + "\" - check widget configuration");
        }
        this.cld = this.origPath.getLastClassDescriptor();
        this.type = this.cld.getUnqualifiedName();
        this.displayFields = this.config.getDisplayFields();
        this.exportField = this.config.getExportField();
        this.setFlattenedResults();
    }

    public String getType() {
        return this.type;
    }

    public void setFlattenedResults() throws UnsupportedEncodingException {
        String newColumnName;
        List results;
        WebConfig webConfig = this.config.getWebConfig();
        Query q = this.getQuery(false, null);
        try {
            results = this.os.execute(q, 0, 5000, true, true, ObjectStore.SEQUENCE_IGNORE);
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        this.columns = new ArrayList();
        if (this.displayFields != null && this.displayFields.length() != 0) {
            String[] fieldArray = this.displayFields.split("[, ]+");
            for (int i = 0; i < fieldArray.length; ++i) {
                String field = fieldArray[i];
                newColumnName = this.type + "." + field;
                this.columns.add(newColumnName);
            }
        } else {
            for (FieldConfig fc : FieldConfigHelper.getClassFieldConfigs((WebConfig)webConfig, (ClassDescriptor)this.cld)) {
                if (!fc.getShowInResults()) continue;
                String fieldExpr = fc.getFieldExpr();
                newColumnName = this.type + "." + fieldExpr;
                this.columns.add(newColumnName);
            }
        }
        this.flattenedResults = new ArrayList();
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            ArrayList<Object> flattenedRow = new ArrayList<Object>();
            ResultsRow resRow = (ResultsRow)iter.next();
            for (int i = 0; i < q.getSelect().size(); ++i) {
                QuerySelectable select = (QuerySelectable)q.getSelect().get(i);
                if (select instanceof QueryFunction) {
                    flattenedRow.add(resRow.get(i));
                    continue;
                }
                if (select instanceof QueryClass) {
                    InterMineObject o = (InterMineObject)resRow.get(i);
                    for (String columnName : this.columns) {
                        Object fieldValue;
                        try {
                            Path path = new Path(this.model, columnName);
                            fieldValue = PathUtil.resolvePath((Path)path, (Object)o);
                        }
                        catch (PathException e) {
                            throw new Error("Cannot create path \"" + columnName + "\" for widget - check config");
                        }
                        flattenedRow.add(fieldValue);
                    }
                    flattenedRow.add(o.getId());
                    continue;
                }
                if (!(select instanceof QueryField)) continue;
                Object queryFieldObj = resRow.get(i);
                if (queryFieldObj instanceof Integer) {
                    flattenedRow.add((Integer)queryFieldObj);
                    continue;
                }
                flattenedRow.add(String.valueOf(resRow.get(i)));
            }
            this.flattenedResults.add(flattenedRow);
        }
        if (this.config.getColumnTitle() != null) {
            this.columns.add(this.config.getColumnTitle());
        } else {
            this.columns.add(this.bag.getType() + "s");
        }
        q = this.getQuery(true, null);
        this.widgetTotal = TableWidgetLdr.calcTotal((ObjectStore)this.os, (Query)q);
    }

    public List<List<Object>> getFlattenedResults() {
        return this.flattenedResults;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Query getQuery(boolean calcTotal, List<String> keys) {
        Query q = new Query();
        String[] queryBits = this.pathString.split("\\.");
        QueryClass qcStart = null;
        QueryField qfStartId = null;
        ClassDescriptor cldStart = this.origPath.getStartClassDescriptor();
        QueryClass qcExport = null;
        for (int i = 1; i < queryBits.length; ++i) {
            String refName;
            if (qcStart == null) {
                qcStart = new QueryClass(cldStart.getType());
                qfStartId = new QueryField(qcStart, "id");
                qcExport = qcStart;
                q.addFrom((FromElement)qcStart);
                QueryHelper.addAndConstraint((Query)q, (Constraint)new BagConstraint((QueryNode)qfStartId, ConstraintOp.IN, this.bag.getOsb()));
            }
            String constraintName = null;
            String constraintValue = null;
            ConstraintOp constraintOp = null;
            if (queryBits[i].indexOf(91) > 0) {
                int endOp;
                int startOp;
                String s = queryBits[i];
                refName = s.substring(0, s.indexOf(91));
                if (s.indexOf("!=") != -1) {
                    startOp = s.indexOf("!=");
                    endOp = startOp + 2;
                    constraintOp = ConstraintOp.NOT_EQUALS;
                } else {
                    startOp = s.indexOf("=");
                    endOp = startOp + 1;
                    constraintOp = ConstraintOp.EQUALS;
                }
                constraintName = s.substring(s.indexOf(91) + 1, startOp);
                constraintValue = s.substring(endOp, s.indexOf(93));
            } else {
                refName = queryBits[i];
            }
            FieldDescriptor fld = cldStart.getFieldDescriptorByName(refName);
            if (fld == null) {
                throw new IllegalArgumentException("Class '" + cldStart.getType() + "' has no '" + refName + "' field");
            }
            if (fld.isAttribute()) {
                throw new IllegalArgumentException("path element not a reference/collection: " + fld.getName());
            }
            ClassDescriptor cldEnd = ((ReferenceDescriptor)fld).getReferencedClassDescriptor();
            QueryClass qcEnd = new QueryClass(cldEnd.getType());
            this.addReferenceConstraint(q, qcStart, refName, qcEnd);
            if (constraintName != null && constraintValue != null) {
                AttributeDescriptor attFld = cldEnd.getAttributeDescriptorByName(constraintName);
                if (attFld == null) {
                    throw new IllegalArgumentException("Class '" + cldEnd.getType() + "' has no '" + constraintName + "' field");
                }
                if (!"java.lang.String".equals(attFld.getType())) {
                    throw new IllegalArgumentException("Constraints can only be on String fields '" + constraintName + "' is a " + attFld.getType());
                }
                SimpleConstraint sc = new SimpleConstraint((QueryEvaluable)new QueryField(qcEnd, constraintName), constraintOp, (QueryEvaluable)new QueryValue((Object)constraintValue));
                QueryHelper.addAndConstraint((Query)q, (Constraint)sc);
                constraintName = null;
                constraintValue = null;
            }
            QueryFunction qfCount = new QueryFunction();
            if (cldEnd.equals((Object)this.origPath.getLastClassDescriptor())) {
                if (keys != null) {
                    String[] fields;
                    q.setDistinct(true);
                    QueryField keyField = new QueryField(qcEnd, this.getKeyField(this.displayFields));
                    BagConstraint bc = new BagConstraint((QueryNode)keyField, ConstraintOp.IN, keys);
                    QueryHelper.addAndConstraint((Query)q, (Constraint)bc);
                    for (String field : fields = this.displayFields.split("[, ]+")) {
                        q.addToSelect((QuerySelectable)new QueryField(qcEnd, field));
                    }
                    q.addToSelect((QuerySelectable)new QueryField(qcExport, this.exportField));
                    break;
                }
                if (!calcTotal) {
                    Query mainQuery = new Query();
                    mainQuery.setDistinct(false);
                    Query subQ = q;
                    subQ.setDistinct(true);
                    subQ.addToSelect((QuerySelectable)qfStartId);
                    mainQuery.addFrom((FromElement)subQ);
                    QueryField outerQfEnd = null;
                    if (this.origPath.endIsAttribute()) {
                        QueryField qfEnd = new QueryField(qcEnd, this.origPath.getLastElement());
                        subQ.addToSelect((QuerySelectable)qfEnd);
                        outerQfEnd = new QueryField(subQ, (QueryEvaluable)qfEnd);
                    } else {
                        String[] fields;
                        for (String field : fields = this.displayFields.split("[, ]+")) {
                            QueryField qf = new QueryField(qcEnd, field);
                            subQ.addToSelect((QuerySelectable)qf);
                            outerQfEnd = new QueryField(subQ, (QueryEvaluable)qf);
                            mainQuery.addToSelect((QuerySelectable)outerQfEnd);
                            mainQuery.addToGroupBy((QueryNode)outerQfEnd);
                        }
                        QueryField qfId = new QueryField(qcEnd, "id");
                        subQ.addToSelect((QuerySelectable)qfId);
                        QueryField outerQfId = new QueryField(subQ, (QueryEvaluable)qfId);
                        mainQuery.addToSelect((QuerySelectable)outerQfId);
                        mainQuery.addToGroupBy((QueryNode)outerQfId);
                    }
                    mainQuery.addToSelect((QuerySelectable)qfCount);
                    mainQuery.addToOrderBy((QueryOrderable)qfCount, "desc");
                    return mainQuery;
                }
                Query subQ = new Query();
                subQ = q;
                subQ.setDistinct(true);
                subQ.clearSelect();
                subQ.addToSelect((QuerySelectable)qfStartId);
                q = new Query();
                q.setDistinct(false);
                q.addToSelect((QuerySelectable)qfCount);
                q.addFrom((FromElement)subQ);
                break;
            }
            cldStart = cldEnd;
            qcStart = qcEnd;
        }
        return q;
    }

    private QueryClass addReferenceConstraint(Query q, QueryClass qcStart, String refName, QueryClass qcEnd) {
        q.addFrom((FromElement)qcEnd);
        ClassDescriptor startCld = this.model.getClassDescriptorByName(qcStart.getType().getName());
        FieldDescriptor fd = startCld.getFieldDescriptorByName(refName);
        Object qRef = fd.isReference() ? new QueryObjectReference(qcStart, refName) : new QueryCollectionReference(qcStart, refName);
        ContainsConstraint cc = new ContainsConstraint((QueryReference)qRef, ConstraintOp.CONTAINS, qcEnd);
        QueryHelper.addAndConstraint((Query)q, (Constraint)cc);
        return qcEnd;
    }

    protected String pathWithNoConstraints(String path) {
        StringBuffer sb = new StringBuffer(path.length());
        String[] queryBits = path.split("\\.");
        for (int i = 0; i < queryBits.length; ++i) {
            String refName = queryBits[i];
            if (refName.indexOf(91) > 0) {
                refName = refName.substring(0, refName.indexOf(91));
            }
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(refName);
        }
        return sb.toString();
    }

    public int getWidgetTotal() {
        return this.widgetTotal;
    }

    private static int calcTotal(ObjectStore os, Query q) {
        Results res = os.execute(q);
        Iterator iter = res.iterator();
        int n = 0;
        while (iter.hasNext()) {
            ResultsRow resRow = (ResultsRow)iter.next();
            n = ((Long)resRow.get(0)).intValue();
        }
        return n;
    }

    public List<List<String>> getExportResults(String[] selected) throws Exception {
        ArrayList<List<String>> exportResults = new ArrayList<List<String>>();
        List<String> selectedIds = Arrays.asList(selected);
        HashMap<String, String> termToLabel = new HashMap<String, String>();
        Query q = this.getQuery(false, selectedIds);
        Results res = this.os.execute(q);
        Iterator iter = res.iterator();
        HashMap termsToIds = new HashMap();
        boolean hasLabelColumn = false;
        while (iter.hasNext()) {
            ResultsRow resRow = (ResultsRow)iter.next();
            String term = resRow.get(0).toString();
            String id = null;
            if (resRow.size() > 2) {
                termToLabel.put(term, resRow.get(1).toString());
                id = resRow.get(2).toString();
                hasLabelColumn = true;
            } else {
                id = resRow.get(1).toString();
            }
            if (!termsToIds.containsKey(term)) {
                termsToIds.put(term, new ArrayList());
            }
            ((List)termsToIds.get(term)).add(id);
        }
        for (String term : selectedIds) {
            if (termsToIds.get(term) == null) continue;
            LinkedList<String> row = new LinkedList<String>();
            row.add(term);
            if (hasLabelColumn) {
                row.add((String)termToLabel.get(term));
            }
            List ids = (List)termsToIds.get(term);
            StringBuffer sb = new StringBuffer();
            for (String identifier : ids) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(identifier);
            }
            row.add(sb.toString());
            exportResults.add(row);
        }
        return exportResults;
    }

    private String getKeyField(String s) {
        if (s.contains(",")) {
            String[] strings = s.split("[, ]+");
            return strings[0];
        }
        return s;
    }

    public PathQuery createPathQuery() {
        PathQuery q = new PathQuery(this.model);
        String[] views = this.config.getViews().split("\\s*,\\s*");
        String prefix = this.config.getTypeClass();
        for (String view : views) {
            if (!view.startsWith(prefix)) {
                view = prefix + "." + view;
            }
            q.addView(view);
        }
        q.addConstraint((PathConstraint)Constraints.in((String)prefix, (String)this.bag.getName()));
        String ps = this.config.getPathStrings();
        if (ps.contains("[") && ps.contains("]")) {
            int endOp;
            int startOp;
            if (ps.indexOf("!=") != -1) {
                startOp = ps.indexOf("!=");
                endOp = startOp + 2;
            } else {
                startOp = ps.indexOf("=");
                endOp = startOp + 1;
            }
            String constraintPath = ps.substring(ps.indexOf(91) + 1, startOp);
            String constraintValue = ps.substring(endOp, ps.indexOf(93));
            if (ps.contains("!=")) {
                q.addConstraint((PathConstraint)Constraints.neq((String)(ps.substring(0, ps.indexOf(91)) + "." + constraintPath), (String)constraintValue));
            } else {
                q.addConstraint((PathConstraint)Constraints.neq((String)(ps.substring(0, ps.indexOf(91)) + "." + constraintPath), (String)constraintValue));
            }
        }
        return q;
    }
}

