/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;

public class LabelsSummaryAction
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(LabelsSummaryAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InterMineAPI api = SessionMethods.getInterMineAPI((HttpServletRequest)request);
        Model model = api.getModel();
        WebConfig config = SessionMethods.getWebConfig((HttpServletRequest)request);
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition", "inline; filename=labels.csv");
        try {
            PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
            for (ClassDescriptor cd : model.getClassDescriptors()) {
                out.print(cd.getUnqualifiedName());
                out.print(",");
                out.print(WebUtil.formatPath((String)cd.getUnqualifiedName(), (Model)model, (WebConfig)config));
                out.println();
                for (FieldDescriptor fd : cd.getFieldDescriptors()) {
                    String path = cd.getUnqualifiedName() + "." + fd.getName();
                    out.print(path);
                    out.print(",");
                    out.print(WebUtil.formatPath((String)path, (Model)model, (WebConfig)config));
                    out.println();
                }
            }
            out.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return mapping.findForward("begin");
        }
        return null;
    }
}

